/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.dataaccess.missing;

import com.netflix.hollow.api.sampling.HollowListSampler;
import com.netflix.hollow.api.sampling.HollowSampler;
import com.netflix.hollow.api.sampling.HollowSamplingDirector;
import com.netflix.hollow.core.read.dataaccess.HollowDataAccess;
import com.netflix.hollow.core.read.dataaccess.HollowListTypeDataAccess;
import com.netflix.hollow.core.read.engine.HollowTypeReadState;
import com.netflix.hollow.core.read.filter.HollowFilterConfig;
import com.netflix.hollow.core.read.iterator.HollowOrdinalIterator;
import com.netflix.hollow.core.read.missing.MissingDataHandler;
import com.netflix.hollow.core.schema.HollowListSchema;

public class HollowListMissingDataAccess
implements HollowListTypeDataAccess {
    private final HollowDataAccess dataAccess;
    private final String typeName;

    public HollowListMissingDataAccess(HollowDataAccess dataAccess, String typeName) {
        this.dataAccess = dataAccess;
        this.typeName = typeName;
    }

    @Override
    public HollowDataAccess getDataAccess() {
        return this.dataAccess;
    }

    @Override
    public HollowListSchema getSchema() {
        return (HollowListSchema)this.missingDataHandler().handleSchema(this.typeName);
    }

    @Override
    public int getElementOrdinal(int ordinal, int listIndex) {
        return this.missingDataHandler().handleListElementOrdinal(this.typeName, ordinal, listIndex);
    }

    @Override
    public int size(int ordinal) {
        return this.missingDataHandler().handleListSize(this.typeName, ordinal);
    }

    @Override
    public HollowOrdinalIterator ordinalIterator(int ordinal) {
        return this.missingDataHandler().handleListIterator(this.typeName, ordinal);
    }

    private MissingDataHandler missingDataHandler() {
        return this.dataAccess.getMissingDataHandler();
    }

    @Override
    public HollowTypeReadState getTypeState() {
        throw new UnsupportedOperationException("No HollowTypeReadState exists for " + this.typeName);
    }

    @Override
    public void setSamplingDirector(HollowSamplingDirector director) {
    }

    @Override
    public void setFieldSpecificSamplingDirector(HollowFilterConfig fieldSpec, HollowSamplingDirector director) {
    }

    @Override
    public void ignoreUpdateThreadForSampling(Thread t) {
    }

    @Override
    public HollowSampler getSampler() {
        return HollowListSampler.NULL_SAMPLER;
    }
}

