/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.memory.pool;

import com.netflix.hollow.core.memory.pool.ArraySegmentRecycler;
import com.netflix.hollow.core.memory.pool.RecyclingRecycler;
import com.netflix.hollow.core.memory.pool.WastefulRecycler;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryManagerMXBean;
import java.util.Arrays;
import java.util.List;

public class GarbageCollectorAwareRecycler
implements ArraySegmentRecycler {
    private static final List<String> LOW_PAUSE_COLLECTORS = Arrays.asList("GPGC", "Shenandoah", "ZGC");
    private final ArraySegmentRecycler delegate;

    public GarbageCollectorAwareRecycler() {
        this(11, 8);
    }

    public GarbageCollectorAwareRecycler(int log2OfByteSegmentSize, int log2OfLongSegmentSize) {
        boolean isLowPause = ManagementFactory.getGarbageCollectorMXBeans().stream().map(MemoryManagerMXBean::getName).map(name -> name.split(" ")[0]).anyMatch(LOW_PAUSE_COLLECTORS::contains);
        this.delegate = isLowPause ? new WastefulRecycler(log2OfByteSegmentSize, log2OfLongSegmentSize) : new RecyclingRecycler(log2OfByteSegmentSize, log2OfLongSegmentSize);
    }

    @Override
    public int getLog2OfByteSegmentSize() {
        return this.delegate.getLog2OfByteSegmentSize();
    }

    @Override
    public int getLog2OfLongSegmentSize() {
        return this.delegate.getLog2OfLongSegmentSize();
    }

    @Override
    public long[] getLongArray() {
        return this.delegate.getLongArray();
    }

    @Override
    public void recycleLongArray(long[] arr) {
        this.delegate.recycleLongArray(arr);
    }

    @Override
    public byte[] getByteArray() {
        return this.delegate.getByteArray();
    }

    @Override
    public void recycleByteArray(byte[] arr) {
        this.delegate.recycleByteArray(arr);
    }

    @Override
    public void swap() {
        this.delegate.swap();
    }
}

