/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.memory.encoding;

import com.netflix.hollow.core.memory.ArrayByteData;
import com.netflix.hollow.core.memory.ByteData;
import com.netflix.hollow.core.memory.ByteDataArray;
import com.netflix.hollow.core.memory.encoding.VarInt;

public class HashCodes {
    private static final int MURMURHASH_SEED = -357227335;

    public static int hashCode(ByteDataArray data) {
        return HashCodes.hashCode(data.getUnderlyingArray(), 0L, (int)data.length());
    }

    public static int hashCode(final String data) {
        if (data == null) {
            return -1;
        }
        int arrayLen = HashCodes.calculateByteArrayLength(data);
        if (arrayLen == data.length()) {
            return HashCodes.hashCode(new ByteData(){

                @Override
                public byte get(long position) {
                    return (byte)(data.charAt((int)position) & 0x7F);
                }
            }, 0L, data.length());
        }
        byte[] array = HashCodes.createByteArrayFromString(data, arrayLen);
        return HashCodes.hashCode(array);
    }

    public static int hashCode(byte[] data) {
        return HashCodes.hashCode(new ArrayByteData(data), 0L, data.length);
    }

    private static int calculateByteArrayLength(String data) {
        int length = data.length();
        for (int i = 0; i < data.length(); ++i) {
            if (data.charAt(i) <= '\u007f') continue;
            length += VarInt.sizeOfVInt(data.charAt(i)) - 1;
        }
        return length;
    }

    private static byte[] createByteArrayFromString(String data, int arrayLen) {
        byte[] array = new byte[arrayLen];
        int pos = 0;
        for (int i = 0; i < data.length(); ++i) {
            pos = VarInt.writeVInt(array, pos, data.charAt(i));
        }
        return array;
    }

    public static int hashCode(ByteData data, long offset, int len) {
        int c1 = -862048943;
        int c2 = 461845907;
        int h1 = -357227335;
        long roundedEnd = offset + ((long)len & 0xFFFFFFFFFFFFFFFCL);
        for (long i = offset; i < roundedEnd; i += 4L) {
            int k1 = data.get(i) & 0xFF | (data.get(i + 1L) & 0xFF) << 8 | (data.get(i + 2L) & 0xFF) << 16 | data.get(i + 3L) << 24;
            k1 *= -862048943;
            k1 = k1 << 15 | k1 >>> 17;
            h1 ^= (k1 *= 461845907);
            h1 = h1 << 13 | h1 >>> 19;
            h1 = h1 * 5 + -430675100;
        }
        int k1 = 0;
        switch (len & 3) {
            case 3: {
                k1 = (data.get(roundedEnd + 2L) & 0xFF) << 16;
            }
            case 2: {
                k1 |= (data.get(roundedEnd + 1L) & 0xFF) << 8;
            }
            case 1: {
                k1 |= data.get(roundedEnd) & 0xFF;
                k1 *= -862048943;
                k1 = k1 << 15 | k1 >>> 17;
                h1 ^= (k1 *= 461845907);
            }
        }
        h1 ^= len;
        h1 ^= h1 >>> 16;
        h1 *= -2048144789;
        h1 ^= h1 >>> 13;
        h1 *= -1028477387;
        h1 ^= h1 >>> 16;
        return h1;
    }

    public static int hashLong(long key) {
        key = (key ^ 0xFFFFFFFFFFFFFFFFL) + (key << 18);
        key ^= key >>> 31;
        key *= 21L;
        key ^= key >>> 11;
        key += key << 6;
        key ^= key >>> 22;
        return (int)key;
    }

    public static int hashInt(int key) {
        key = ~key + (key << 15);
        key ^= key >>> 12;
        key += key << 2;
        key ^= key >>> 4;
        key *= 2057;
        key ^= key >>> 16;
        return key;
    }

    public static int hashTableSize(int numElements) throws IllegalArgumentException {
        if (numElements < 0) {
            throw new IllegalArgumentException("cannot be negative; numElements=" + numElements);
        }
        if (numElements > 0x2CCCCCCC) {
            throw new IllegalArgumentException("exceeds maximum number of buckets; numElements=" + numElements);
        }
        if (numElements == 0) {
            return 1;
        }
        if (numElements < 3) {
            return numElements * 2;
        }
        int sizeAfterLoadFactor = (int)((long)numElements * 10L / 7L);
        int bits = 32 - Integer.numberOfLeadingZeros(sizeAfterLoadFactor - 1);
        return 1 << bits;
    }
}

