/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.memory.encoding;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public final class BlobByteBuffer {
    public static final int MAX_SINGLE_BUFFER_CAPACITY = 0x40000000;
    private final ByteBuffer[] spine;
    private final long capacity;
    private final int shift;
    private final int mask;
    private long position;

    private BlobByteBuffer(long capacity, int shift, int mask, ByteBuffer[] spine) {
        this(capacity, shift, mask, spine, 0L);
    }

    private BlobByteBuffer(long capacity, int shift, int mask, ByteBuffer[] spine, long position) {
        if (!spine[0].order().equals(ByteOrder.BIG_ENDIAN)) {
            throw new UnsupportedOperationException("Little endian memory layout is not supported");
        }
        this.capacity = capacity;
        this.shift = shift;
        this.mask = mask;
        this.position = position;
        this.spine = spine;
    }

    public BlobByteBuffer duplicate() {
        return new BlobByteBuffer(this.capacity, this.shift, this.mask, this.spine, this.position);
    }

    public static BlobByteBuffer mmapBlob(FileChannel channel, int singleBufferCapacity) throws IOException {
        long bufferCount;
        long size = channel.size();
        if (size == 0L) {
            throw new IllegalStateException("File to be mmap-ed has no data");
        }
        if ((singleBufferCapacity & singleBufferCapacity - 1) != 0) {
            throw new IllegalArgumentException("singleBufferCapacity must be a power of 2");
        }
        int bufferCapacity = size > (long)singleBufferCapacity ? singleBufferCapacity : Integer.highestOneBit((int)size);
        long l = bufferCount = size % (long)bufferCapacity == 0L ? size / (long)bufferCapacity : size / (long)bufferCapacity + 1L;
        if (bufferCount > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("file too large; size=" + size);
        }
        int shift = 31 - Integer.numberOfLeadingZeros(bufferCapacity);
        int mask = (1 << shift) - 1;
        ByteBuffer[] spine = new MappedByteBuffer[(int)bufferCount];
        int i = 0;
        while ((long)i < bufferCount) {
            long pos = (long)i * (long)bufferCapacity;
            int cap = (long)i == bufferCount - 1L ? (int)(size - pos) : bufferCapacity;
            MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_ONLY, pos, cap);
            spine[i] = buffer;
            ++i;
        }
        return new BlobByteBuffer(size, shift, mask, spine);
    }

    public long position() {
        return this.position;
    }

    public BlobByteBuffer position(long position) {
        if (position > this.capacity || position < 0L) {
            throw new IllegalArgumentException("invalid position; position=" + position + " capacity=" + this.capacity);
        }
        this.position = position;
        return this;
    }

    public byte getByte(long index) throws BufferUnderflowException {
        if (index < this.capacity) {
            int spineIndex = (int)(index >>> this.shift);
            int bufferIndex = (int)(index & (long)this.mask);
            return this.spine[spineIndex].get(bufferIndex);
        }
        assert (index < this.capacity + 8L);
        return 0;
    }

    public long getLong(long startByteIndex) throws BufferUnderflowException {
        int alignmentOffset = (int)((startByteIndex - this.position()) % 8L);
        long nextAlignedPos = startByteIndex - (long)alignmentOffset + 8L;
        byte[] bytes = new byte[8];
        for (int i = 0; i < 8; ++i) {
            bytes[i] = this.getByte(this.bigEndian(startByteIndex + (long)i, nextAlignedPos));
        }
        return (long)bytes[7] << 56 | (long)(bytes[6] & 0xFF) << 48 | (long)(bytes[5] & 0xFF) << 40 | (long)(bytes[4] & 0xFF) << 32 | (long)(bytes[3] & 0xFF) << 24 | (long)(bytes[2] & 0xFF) << 16 | (long)(bytes[1] & 0xFF) << 8 | (long)(bytes[0] & 0xFF);
    }

    private long bigEndian(long index, long boundary) {
        long result = index < boundary ? boundary - 8L + (boundary - index) - 1L : boundary + (boundary + 8L - index) - 1L;
        return result;
    }
}

