/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.memory;

import com.netflix.hollow.core.memory.ByteData;
import com.netflix.hollow.core.memory.HollowUnsafeHandle;
import com.netflix.hollow.core.memory.VariableLengthData;
import com.netflix.hollow.core.memory.pool.ArraySegmentRecycler;
import com.netflix.hollow.core.read.HollowBlobInput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import sun.misc.Unsafe;

public class SegmentedByteArray
implements VariableLengthData {
    private static final Unsafe unsafe = HollowUnsafeHandle.getUnsafe();
    private byte[][] segments = new byte[2][];
    private final int log2OfSegmentSize;
    private final int bitmask;
    private final ArraySegmentRecycler memoryRecycler;

    public SegmentedByteArray(ArraySegmentRecycler memoryRecycler) {
        this.log2OfSegmentSize = memoryRecycler.getLog2OfByteSegmentSize();
        this.bitmask = (1 << this.log2OfSegmentSize) - 1;
        this.memoryRecycler = memoryRecycler;
    }

    public void set(long index, byte value) {
        int segmentIndex = (int)(index >> this.log2OfSegmentSize);
        this.ensureCapacity(segmentIndex);
        this.segments[segmentIndex][(int)(index & (long)this.bitmask)] = value;
    }

    @Override
    public byte get(long index) {
        return this.segments[(int)(index >>> this.log2OfSegmentSize)][(int)(index & (long)this.bitmask)];
    }

    @Override
    public void copy(ByteData src, long srcPos, long destPos, long length) {
        for (long i = 0L; i < length; ++i) {
            this.set(destPos++, src.get(srcPos++));
        }
    }

    public void copy(SegmentedByteArray src, long srcPos, long destPos, long length) {
        int segmentLength = 1 << this.log2OfSegmentSize;
        int currentSegment = (int)(destPos >>> this.log2OfSegmentSize);
        int segmentStartPos = (int)(destPos & (long)this.bitmask);
        int remainingBytesInSegment = segmentLength - segmentStartPos;
        while (length > 0L) {
            int bytesToCopyFromSegment = (int)Math.min((long)remainingBytesInSegment, length);
            this.ensureCapacity(currentSegment);
            int copiedBytes = src.copy(srcPos, this.segments[currentSegment], segmentStartPos, bytesToCopyFromSegment);
            srcPos += (long)copiedBytes;
            length -= (long)copiedBytes;
            segmentStartPos = 0;
            remainingBytesInSegment = segmentLength;
            ++currentSegment;
        }
    }

    public int copy(long srcPos, byte[] data, int destPos, int length) {
        int segmentSize = 1 << this.log2OfSegmentSize;
        int remainingBytesInSegment = (int)((long)segmentSize - (srcPos & (long)this.bitmask));
        int dataPosition = destPos;
        while (length > 0) {
            byte[] segment = this.segments[(int)(srcPos >>> this.log2OfSegmentSize)];
            int bytesToCopyFromSegment = Math.min(remainingBytesInSegment, length);
            System.arraycopy(segment, (int)(srcPos & (long)this.bitmask), data, dataPosition, bytesToCopyFromSegment);
            dataPosition += bytesToCopyFromSegment;
            remainingBytesInSegment = segmentSize - (int)((srcPos += (long)bytesToCopyFromSegment) & (long)this.bitmask);
            length -= bytesToCopyFromSegment;
        }
        return dataPosition - destPos;
    }

    public boolean rangeEquals(long rangeStart, SegmentedByteArray compareTo, long cmpStart, int length) {
        for (int i = 0; i < length; ++i) {
            if (this.get(rangeStart + (long)i) == compareTo.get(cmpStart + (long)i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void orderedCopy(VariableLengthData src, long srcPos, long destPos, long length) {
        int segmentLength = 1 << this.log2OfSegmentSize;
        int currentSegment = (int)(destPos >>> this.log2OfSegmentSize);
        int segmentStartPos = (int)(destPos & (long)this.bitmask);
        int remainingBytesInSegment = segmentLength - segmentStartPos;
        while (length > 0L) {
            int bytesToCopyFromSegment = (int)Math.min((long)remainingBytesInSegment, length);
            this.ensureCapacity(currentSegment);
            int copiedBytes = ((SegmentedByteArray)src).orderedCopy(srcPos, this.segments[currentSegment], segmentStartPos, bytesToCopyFromSegment);
            srcPos += (long)copiedBytes;
            length -= (long)copiedBytes;
            segmentStartPos = 0;
            remainingBytesInSegment = segmentLength;
            ++currentSegment;
        }
    }

    private int orderedCopy(long srcPos, byte[] data, int destPos, int length) {
        int segmentSize = 1 << this.log2OfSegmentSize;
        int remainingBytesInSegment = (int)((long)segmentSize - (srcPos & (long)this.bitmask));
        int dataPosition = destPos;
        while (length > 0) {
            byte[] segment = this.segments[(int)(srcPos >>> this.log2OfSegmentSize)];
            int bytesToCopyFromSegment = Math.min(remainingBytesInSegment, length);
            this.orderedCopy(segment, (int)(srcPos & (long)this.bitmask), data, dataPosition, bytesToCopyFromSegment);
            dataPosition += bytesToCopyFromSegment;
            remainingBytesInSegment = segmentSize - (int)((srcPos += (long)bytesToCopyFromSegment) & (long)this.bitmask);
            length -= bytesToCopyFromSegment;
        }
        return dataPosition - destPos;
    }

    @Override
    public void loadFrom(HollowBlobInput is, long length) throws IOException {
        int segmentSize = 1 << this.log2OfSegmentSize;
        int segment = 0;
        byte[] scratch = new byte[segmentSize];
        while (length > 0L) {
            long bytesCopied;
            this.ensureCapacity(segment);
            long bytesToCopy = Math.min((long)segmentSize, length);
            for (bytesCopied = 0L; bytesCopied < bytesToCopy; bytesCopied += (long)is.read(scratch, (int)bytesCopied, (int)(bytesToCopy - bytesCopied))) {
            }
            this.orderedCopy(scratch, 0, this.segments[segment++], 0, (int)bytesCopied);
            length -= bytesCopied;
        }
    }

    public void writeTo(OutputStream os, long startPosition, long len) throws IOException {
        long bytesToCopyFromSegment;
        int segmentSize = 1 << this.log2OfSegmentSize;
        int remainingBytesInSegment = segmentSize - (int)(startPosition & (long)this.bitmask);
        for (long remainingBytesInCopy = len; remainingBytesInCopy > 0L; remainingBytesInCopy -= bytesToCopyFromSegment) {
            bytesToCopyFromSegment = Math.min((long)remainingBytesInSegment, remainingBytesInCopy);
            os.write(this.segments[(int)(startPosition >>> this.log2OfSegmentSize)], (int)(startPosition & (long)this.bitmask), (int)bytesToCopyFromSegment);
            remainingBytesInSegment = segmentSize - (int)((startPosition += bytesToCopyFromSegment) & (long)this.bitmask);
        }
    }

    private void orderedCopy(byte[] src, int srcPos, byte[] dest, int destPos, int length) {
        int endSrcPos = srcPos + length;
        destPos += Unsafe.ARRAY_BYTE_BASE_OFFSET;
        while (srcPos < endSrcPos) {
            unsafe.putByteVolatile(dest, destPos++, src[srcPos++]);
        }
    }

    private void ensureCapacity(int segmentIndex) {
        while (segmentIndex >= this.segments.length) {
            this.segments = (byte[][])Arrays.copyOf(this.segments, this.segments.length * 3 / 2);
        }
        if (this.segments[segmentIndex] == null) {
            this.segments[segmentIndex] = this.memoryRecycler.getByteArray();
        }
    }

    public void destroy() {
        for (int i = 0; i < this.segments.length; ++i) {
            if (this.segments[i] == null) continue;
            this.memoryRecycler.recycleByteArray(this.segments[i]);
        }
    }

    @Override
    public long size() {
        long size = 0L;
        for (int i = 0; i < this.segments.length; ++i) {
            if (this.segments[i] == null) continue;
            size += (long)this.segments[i].length;
        }
        return size;
    }
}

