/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.memory;

import java.util.Arrays;

public class FreeOrdinalTracker {
    private int[] freeOrdinals = new int[64];
    private int size;
    private int nextEmptyOrdinal;

    public FreeOrdinalTracker() {
        this(0);
    }

    private FreeOrdinalTracker(int nextEmptyOrdinal) {
        this.nextEmptyOrdinal = nextEmptyOrdinal;
        this.size = 0;
    }

    public int getFreeOrdinal() {
        if (this.size == 0) {
            return this.nextEmptyOrdinal++;
        }
        return this.freeOrdinals[--this.size];
    }

    public void returnOrdinalToPool(int ordinal) {
        if (this.size == this.freeOrdinals.length) {
            this.freeOrdinals = Arrays.copyOf(this.freeOrdinals, this.freeOrdinals.length * 3 / 2);
        }
        this.freeOrdinals[this.size] = ordinal;
        ++this.size;
    }

    public void setNextEmptyOrdinal(int nextEmptyOrdinal) {
        this.nextEmptyOrdinal = nextEmptyOrdinal;
    }

    public void sort() {
        Arrays.sort(this.freeOrdinals, 0, this.size);
        this.reverseFreeOrdinalPool();
    }

    public void sort(int numShards) {
        int i;
        int shardNumberMask = numShards - 1;
        Shard[] shards = new Shard[numShards];
        for (i = 0; i < shards.length; ++i) {
            shards[i] = new Shard();
        }
        for (i = 0; i < this.size; ++i) {
            shards[this.freeOrdinals[i] & shardNumberMask].freeOrdinalCount++;
        }
        Shard[] orderedShards = Arrays.copyOf(shards, shards.length);
        Arrays.sort(orderedShards, (s1, s2) -> ((Shard)s2).freeOrdinalCount - ((Shard)s1).freeOrdinalCount);
        for (int i2 = 1; i2 < numShards; ++i2) {
            orderedShards[i2].currentPos = orderedShards[i2 - 1].currentPos + orderedShards[i2 - 1].freeOrdinalCount;
        }
        Arrays.sort(this.freeOrdinals, 0, this.size);
        int[] newFreeOrdinals = new int[this.freeOrdinals.length];
        for (int i3 = 0; i3 < this.size; ++i3) {
            Shard shard = shards[this.freeOrdinals[i3] & shardNumberMask];
            newFreeOrdinals[((Shard)shard).currentPos] = this.freeOrdinals[i3];
            shard.currentPos++;
        }
        this.freeOrdinals = newFreeOrdinals;
        this.reverseFreeOrdinalPool();
    }

    private void reverseFreeOrdinalPool() {
        int midpoint = this.size / 2;
        for (int i = 0; i < midpoint; ++i) {
            int temp = this.freeOrdinals[i];
            this.freeOrdinals[i] = this.freeOrdinals[this.size - i - 1];
            this.freeOrdinals[this.size - i - 1] = temp;
        }
    }

    public void reset() {
        this.size = 0;
        this.nextEmptyOrdinal = 0;
    }

    private static class Shard {
        private int freeOrdinalCount;
        private int currentPos;

        private Shard() {
        }
    }
}

