/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.memory;

import com.netflix.hollow.core.memory.ByteData;
import com.netflix.hollow.core.memory.VariableLengthData;
import com.netflix.hollow.core.memory.encoding.BlobByteBuffer;
import com.netflix.hollow.core.read.HollowBlobInput;
import java.io.IOException;

public class EncodedByteBuffer
implements VariableLengthData {
    private BlobByteBuffer bufferView;
    private long size = 0L;

    @Override
    public byte get(long index) {
        if (index >= this.size) {
            throw new IllegalStateException();
        }
        byte retVal = this.bufferView.getByte(this.bufferView.position() + index);
        return retVal;
    }

    @Override
    public void loadFrom(HollowBlobInput in, long length) throws IOException {
        BlobByteBuffer buffer = in.getBuffer();
        this.size = length;
        buffer.position(in.getFilePointer());
        this.bufferView = buffer.duplicate();
        buffer.position(buffer.position() + length);
        in.seek(in.getFilePointer() + length);
    }

    @Override
    public void copy(ByteData src, long srcPos, long destPos, long length) {
        throw new UnsupportedOperationException("Operation not supported in shared-memory mode");
    }

    @Override
    public void orderedCopy(VariableLengthData src, long srcPos, long destPos, long length) {
        throw new UnsupportedOperationException("Operation not supported in shared-memory mode");
    }

    @Override
    public long size() {
        return this.size;
    }
}

