/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.memory;

import com.netflix.hollow.core.memory.ByteDataArray;
import com.netflix.hollow.core.memory.FreeOrdinalTracker;
import com.netflix.hollow.core.memory.SegmentedByteArray;
import com.netflix.hollow.core.memory.ThreadSafeBitSet;
import com.netflix.hollow.core.memory.encoding.HashCodes;
import com.netflix.hollow.core.memory.encoding.VarInt;
import com.netflix.hollow.core.memory.pool.WastefulRecycler;
import java.util.Arrays;
import java.util.BitSet;
import java.util.concurrent.atomic.AtomicLongArray;

public class ByteArrayOrdinalMap {
    private static final long EMPTY_BUCKET_VALUE = -1L;
    private static final int BITS_PER_ORDINAL = 29;
    private static final int BITS_PER_POINTER = 35;
    private static final long POINTER_MASK = 0x7FFFFFFFFL;
    private static final long ORDINAL_MASK = 0x1FFFFFFFL;
    private static final long MAX_BYTE_DATA_LENGTH = 0x800000000L;
    private volatile AtomicLongArray pointersAndOrdinals;
    private final ByteDataArray byteData;
    private final FreeOrdinalTracker freeOrdinalTracker;
    private int size;
    private int sizeBeforeGrow;
    private BitSet unusedPreviousOrdinals;
    private long[] pointersByOrdinal;

    public ByteArrayOrdinalMap() {
        this(256);
    }

    public ByteArrayOrdinalMap(int size) {
        size = ByteArrayOrdinalMap.bucketSize(size);
        this.freeOrdinalTracker = new FreeOrdinalTracker();
        this.byteData = new ByteDataArray(WastefulRecycler.DEFAULT_INSTANCE);
        this.pointersAndOrdinals = this.emptyKeyArray(size);
        this.sizeBeforeGrow = (int)((double)size * 0.7);
        this.size = 0;
    }

    private static int bucketSize(int x) {
        --x;
        x |= x >> 1;
        x |= x >> 2;
        x |= x >> 4;
        x |= x >> 8;
        return (x |= x >> 16) < 256 ? 256 : (x >= 0x40000000 ? 0x40000000 : x + 1);
    }

    public int getOrAssignOrdinal(ByteDataArray serializedRepresentation) {
        return this.getOrAssignOrdinal(serializedRepresentation, -1);
    }

    public int getOrAssignOrdinal(ByteDataArray serializedRepresentation, int preferredOrdinal) {
        int hash = HashCodes.hashCode(serializedRepresentation);
        int ordinal = this.get(serializedRepresentation, hash);
        return ordinal != -1 ? ordinal : this.assignOrdinal(serializedRepresentation, hash, preferredOrdinal);
    }

    private synchronized int assignOrdinal(ByteDataArray serializedRepresentation, int hash, int preferredOrdinal) {
        if (preferredOrdinal < -1 || (long)preferredOrdinal > 0x1FFFFFFFL) {
            throw new IllegalArgumentException(String.format("The given preferred ordinal %s is out of bounds and not within the closed interval [-1, %s]", preferredOrdinal, 0x1FFFFFFFL));
        }
        if (this.size > this.sizeBeforeGrow) {
            this.growKeyArray();
        }
        AtomicLongArray pao = this.pointersAndOrdinals;
        int modBitmask = pao.length() - 1;
        int bucket = hash & modBitmask;
        long key = pao.get(bucket);
        while (key != -1L) {
            if (this.compare(serializedRepresentation, key)) {
                return (int)(key >>> 35);
            }
            bucket = bucket + 1 & modBitmask;
            key = pao.get(bucket);
        }
        int ordinal = this.findFreeOrdinal(preferredOrdinal);
        if ((long)ordinal > 0x1FFFFFFFL) {
            throw new IllegalStateException(String.format("Ordinal cannot be assigned. The to be assigned ordinal, %s, is greater than the maximum supported ordinal value of %s", ordinal, 0x1FFFFFFFL));
        }
        long pointer = this.byteData.length();
        VarInt.writeVInt(this.byteData, (int)serializedRepresentation.length());
        serializedRepresentation.copyTo(this.byteData);
        if (this.byteData.length() > 0x800000000L) {
            throw new IllegalStateException(String.format("The number of bytes for the serialized representations, %s, is too large and is greater than the maximum of %s bytes", this.byteData.length(), 0x800000000L));
        }
        key = (long)ordinal << 35 | pointer;
        ++this.size;
        pao.set(bucket, key);
        return ordinal;
    }

    private int findFreeOrdinal(int preferredOrdinal) {
        if (preferredOrdinal != -1 && this.unusedPreviousOrdinals.get(preferredOrdinal)) {
            this.unusedPreviousOrdinals.clear(preferredOrdinal);
            return preferredOrdinal;
        }
        return this.freeOrdinalTracker.getFreeOrdinal();
    }

    public void put(ByteDataArray serializedRepresentation, int ordinal) {
        if (ordinal < 0 || (long)ordinal > 0x1FFFFFFFL) {
            throw new IllegalArgumentException(String.format("The given ordinal %s is out of bounds and not within the closed interval [0, %s]", ordinal, 0x1FFFFFFFL));
        }
        if (this.size > this.sizeBeforeGrow) {
            this.growKeyArray();
        }
        int hash = HashCodes.hashCode(serializedRepresentation);
        AtomicLongArray pao = this.pointersAndOrdinals;
        int modBitmask = pao.length() - 1;
        int bucket = hash & modBitmask;
        long key = pao.get(bucket);
        while (key != -1L) {
            bucket = bucket + 1 & modBitmask;
            key = pao.get(bucket);
        }
        long pointer = this.byteData.length();
        VarInt.writeVInt(this.byteData, (int)serializedRepresentation.length());
        serializedRepresentation.copyTo(this.byteData);
        if (this.byteData.length() > 0x800000000L) {
            throw new IllegalStateException(String.format("The number of bytes for the serialized representations, %s, is too large and is greater than the maximum of %s bytes", this.byteData.length(), 0x800000000L));
        }
        key = (long)ordinal << 35 | pointer;
        ++this.size;
        pao.set(bucket, key);
    }

    public void recalculateFreeOrdinals() {
        BitSet populatedOrdinals = new BitSet();
        AtomicLongArray pao = this.pointersAndOrdinals;
        for (int i = 0; i < pao.length(); ++i) {
            long key = pao.get(i);
            if (key == -1L) continue;
            int ordinal = (int)(key >>> 35);
            populatedOrdinals.set(ordinal);
        }
        this.recalculateFreeOrdinals(populatedOrdinals);
    }

    public void reservePreviouslyPopulatedOrdinals(BitSet populatedOrdinals) {
        this.unusedPreviousOrdinals = BitSet.valueOf(populatedOrdinals.toLongArray());
        this.recalculateFreeOrdinals(populatedOrdinals);
    }

    private void recalculateFreeOrdinals(BitSet populatedOrdinals) {
        this.freeOrdinalTracker.reset();
        int length = populatedOrdinals.length();
        int ordinal = populatedOrdinals.nextClearBit(0);
        while (ordinal < length) {
            this.freeOrdinalTracker.returnOrdinalToPool(ordinal);
            ordinal = populatedOrdinals.nextClearBit(ordinal + 1);
        }
        this.freeOrdinalTracker.setNextEmptyOrdinal(length);
    }

    public BitSet getUnusedPreviousOrdinals() {
        return this.unusedPreviousOrdinals;
    }

    public int get(ByteDataArray serializedRepresentation) {
        return this.get(serializedRepresentation, HashCodes.hashCode(serializedRepresentation));
    }

    private int get(ByteDataArray serializedRepresentation, int hash) {
        AtomicLongArray pao = this.pointersAndOrdinals;
        int modBitmask = pao.length() - 1;
        int bucket = hash & modBitmask;
        long key = pao.get(bucket);
        while (key != -1L) {
            if (this.compare(serializedRepresentation, key)) {
                return (int)(key >>> 35);
            }
            bucket = bucket + 1 & modBitmask;
            key = pao.get(bucket);
        }
        return -1;
    }

    public void prepareForWrite() {
        int maxOrdinal = 0;
        AtomicLongArray pao = this.pointersAndOrdinals;
        for (int i = 0; i < pao.length(); ++i) {
            int ordinal;
            long key = pao.get(i);
            if (key == -1L || (ordinal = (int)(key >>> 35)) <= maxOrdinal) continue;
            maxOrdinal = ordinal;
        }
        long[] pbo = new long[maxOrdinal + 1];
        Arrays.fill(pbo, -1L);
        for (int i = 0; i < pao.length(); ++i) {
            long key = pao.get(i);
            if (key == -1L) continue;
            int ordinal = (int)(key >>> 35);
            pbo[ordinal] = key & 0x7FFFFFFFFL;
        }
        this.pointersByOrdinal = pbo;
    }

    public void compact(ThreadSafeBitSet usedOrdinals, int numShards, boolean focusHoleFillInFewestShards) {
        int i;
        long[] populatedReverseKeys = new long[this.size];
        int counter = 0;
        AtomicLongArray pao = this.pointersAndOrdinals;
        for (int i2 = 0; i2 < pao.length(); ++i2) {
            long key = pao.get(i2);
            if (key == -1L) continue;
            populatedReverseKeys[counter++] = key << 29 | key >>> 35;
        }
        Arrays.sort(populatedReverseKeys);
        SegmentedByteArray arr = this.byteData.getUnderlyingArray();
        long currentCopyPointer = 0L;
        for (i = 0; i < populatedReverseKeys.length; ++i) {
            int ordinal = (int)(populatedReverseKeys[i] & 0x1FFFFFFFL);
            if (usedOrdinals.get(ordinal)) {
                long pointer = populatedReverseKeys[i] >>> 29;
                int length = VarInt.readVInt(arr, pointer);
                length += VarInt.sizeOfVInt(length);
                if (currentCopyPointer != pointer) {
                    arr.copy(arr, pointer, currentCopyPointer, (long)length);
                }
                populatedReverseKeys[i] = populatedReverseKeys[i] << 35 | currentCopyPointer;
                currentCopyPointer += (long)length;
                continue;
            }
            this.freeOrdinalTracker.returnOrdinalToPool(ordinal);
            populatedReverseKeys[i] = -1L;
        }
        this.byteData.setPosition(currentCopyPointer);
        if (focusHoleFillInFewestShards && numShards > 1) {
            this.freeOrdinalTracker.sort(numShards);
        } else {
            this.freeOrdinalTracker.sort();
        }
        for (i = 0; i < pao.length(); ++i) {
            pao.lazySet(i, -1L);
        }
        this.populateNewHashArray(pao, populatedReverseKeys);
        this.size = usedOrdinals.cardinality();
        this.pointersByOrdinal = null;
        this.unusedPreviousOrdinals = null;
    }

    public long getPointerForData(int ordinal) {
        long pointer = this.pointersByOrdinal[ordinal] & 0x7FFFFFFFFL;
        return pointer + (long)VarInt.nextVLongSize(this.byteData.getUnderlyingArray(), pointer);
    }

    public boolean isReadyForWriting() {
        return this.pointersByOrdinal != null;
    }

    public boolean isReadyForAddingObjects() {
        return this.pointersByOrdinal == null;
    }

    public long getDataSize() {
        return this.byteData.length();
    }

    public int maxOrdinal() {
        int maxOrdinal = -1;
        AtomicLongArray pao = this.pointersAndOrdinals;
        for (int i = 0; i < pao.length(); ++i) {
            int ordinal;
            long key = pao.get(i);
            if (key == -1L || (ordinal = (int)(key >>> 35)) <= maxOrdinal) continue;
            maxOrdinal = ordinal;
        }
        return maxOrdinal;
    }

    private boolean compare(ByteDataArray serializedRepresentation, long key) {
        long position = key & 0x7FFFFFFFFL;
        int sizeOfData = VarInt.readVInt(this.byteData.getUnderlyingArray(), position);
        if ((long)sizeOfData != serializedRepresentation.length()) {
            return false;
        }
        position += (long)VarInt.sizeOfVInt(sizeOfData);
        for (int i = 0; i < sizeOfData; ++i) {
            if (serializedRepresentation.get(i) == this.byteData.get(position++)) continue;
            return false;
        }
        return true;
    }

    public void resize(int size) {
        size = ByteArrayOrdinalMap.bucketSize(size);
        if (this.pointersAndOrdinals.length() < size) {
            this.growKeyArray(size);
        }
    }

    private void growKeyArray() {
        int newSize = this.pointersAndOrdinals.length() << 1;
        if (newSize < 0) {
            throw new IllegalStateException("New size computed to grow the underlying array for the map is negative. This is most likely due to the total number of keys added to map has exceeded the max capacity of the keys map can hold. Current array size :" + this.pointersAndOrdinals.length() + " and size to grow :" + newSize);
        }
        this.growKeyArray(newSize);
    }

    private void growKeyArray(int newSize) {
        AtomicLongArray pao = this.pointersAndOrdinals;
        assert ((newSize & newSize - 1) == 0);
        assert (pao.length() < newSize);
        AtomicLongArray newKeys = this.emptyKeyArray(newSize);
        long[] valuesToAdd = new long[this.size];
        int counter = 0;
        for (int i = 0; i < pao.length(); ++i) {
            long key = pao.get(i);
            if (key == -1L) continue;
            valuesToAdd[counter++] = key;
        }
        Arrays.sort(valuesToAdd);
        this.populateNewHashArray(newKeys, valuesToAdd, counter);
        this.sizeBeforeGrow = (int)((double)newSize * 0.7);
        this.pointersAndOrdinals = newKeys;
    }

    private void populateNewHashArray(AtomicLongArray newKeys, long[] valuesToAdd) {
        this.populateNewHashArray(newKeys, valuesToAdd, valuesToAdd.length);
    }

    private void populateNewHashArray(AtomicLongArray newKeys, long[] valuesToAdd, int length) {
        assert (length <= valuesToAdd.length);
        int modBitmask = newKeys.length() - 1;
        for (int i = 0; i < length; ++i) {
            long value = valuesToAdd[i];
            if (value == -1L) continue;
            int hash = this.rehashPreviouslyAddedData(value);
            int bucket = hash & modBitmask;
            while (newKeys.get(bucket) != -1L) {
                bucket = bucket + 1 & modBitmask;
            }
            newKeys.lazySet(bucket, value);
        }
    }

    private int rehashPreviouslyAddedData(long key) {
        long position = key & 0x7FFFFFFFFL;
        int sizeOfData = VarInt.readVInt(this.byteData.getUnderlyingArray(), position);
        return HashCodes.hashCode(this.byteData.getUnderlyingArray(), position += (long)VarInt.sizeOfVInt(sizeOfData), sizeOfData);
    }

    private AtomicLongArray emptyKeyArray(int size) {
        AtomicLongArray arr = new AtomicLongArray(size);
        for (int i = 0; i < arr.length(); ++i) {
            arr.lazySet(i, -1L);
        }
        return arr;
    }

    public ByteDataArray getByteData() {
        return this.byteData;
    }

    public AtomicLongArray getPointersAndOrdinals() {
        return this.pointersAndOrdinals;
    }

    public static boolean isPointerAndOrdinalEmpty(long pointerAndOrdinal) {
        return pointerAndOrdinal == -1L;
    }

    public static long getPointer(long pointerAndOrdinal) {
        return pointerAndOrdinal & 0x7FFFFFFFFL;
    }

    public static int getOrdinal(long pointerAndOrdinal) {
        return (int)(pointerAndOrdinal >>> 35);
    }
}

