/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.index;

import com.netflix.hollow.core.index.HollowHashIndex;
import com.netflix.hollow.core.memory.encoding.HashCodes;
import com.netflix.hollow.core.read.iterator.HollowOrdinalIterator;
import java.util.Spliterator;
import java.util.function.IntConsumer;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;

public class HollowHashIndexResult {
    private final HollowHashIndex.HollowHashIndexState hashIndexState;
    private final long selectTableStartPointer;
    private final int selectTableSize;
    private final int selectTableBuckets;
    private final int selectBucketMask;

    HollowHashIndexResult(HollowHashIndex.HollowHashIndexState hashIndexState, long selectTableStartPointer, int selectTableSize) {
        this.hashIndexState = hashIndexState;
        this.selectTableStartPointer = selectTableStartPointer;
        this.selectTableSize = selectTableSize;
        this.selectTableBuckets = HashCodes.hashTableSize(selectTableSize);
        this.selectBucketMask = this.selectTableBuckets - 1;
    }

    public int numResults() {
        return this.selectTableSize;
    }

    public boolean contains(int value) {
        int hash = HashCodes.hashInt(value);
        int bucket = hash & this.selectBucketMask;
        int selectOrdinal = (int)this.hashIndexState.getSelectHashArray().getElementValue((this.selectTableStartPointer + (long)bucket) * (long)this.hashIndexState.getBitsPerSelectHashEntry(), this.hashIndexState.getBitsPerSelectHashEntry()) - 1;
        while (selectOrdinal != -1) {
            if (selectOrdinal == value) {
                return true;
            }
            bucket = bucket + 1 & this.selectBucketMask;
            selectOrdinal = (int)this.hashIndexState.getSelectHashArray().getElementValue((this.selectTableStartPointer + (long)bucket) * (long)this.hashIndexState.getBitsPerSelectHashEntry(), this.hashIndexState.getBitsPerSelectHashEntry()) - 1;
        }
        return false;
    }

    public HollowOrdinalIterator iterator() {
        return new HollowOrdinalIterator(){
            final long endBucket;
            long currentBucket;
            {
                this.endBucket = HollowHashIndexResult.this.selectTableStartPointer + (long)HollowHashIndexResult.this.selectTableBuckets;
                this.currentBucket = HollowHashIndexResult.this.selectTableStartPointer;
            }

            @Override
            public int next() {
                while (this.currentBucket < this.endBucket) {
                    int selectOrdinal = (int)HollowHashIndexResult.this.hashIndexState.getSelectHashArray().getElementValue(this.currentBucket++ * (long)HollowHashIndexResult.this.hashIndexState.getBitsPerSelectHashEntry(), HollowHashIndexResult.this.hashIndexState.getBitsPerSelectHashEntry()) - 1;
                    if (selectOrdinal == -1) continue;
                    return selectOrdinal;
                }
                return Integer.MAX_VALUE;
            }
        };
    }

    public IntStream stream() {
        Spliterator.OfInt si = new Spliterator.OfInt(){
            final long endBucket;
            long currentBucket;
            {
                this.endBucket = HollowHashIndexResult.this.selectTableStartPointer + (long)HollowHashIndexResult.this.selectTableBuckets;
                this.currentBucket = HollowHashIndexResult.this.selectTableStartPointer;
            }

            @Override
            public Spliterator.OfInt trySplit() {
                return null;
            }

            @Override
            public boolean tryAdvance(IntConsumer action) {
                while (this.currentBucket < this.endBucket) {
                    int selectOrdinal = (int)HollowHashIndexResult.this.hashIndexState.getSelectHashArray().getElementValue(this.currentBucket++ * (long)HollowHashIndexResult.this.hashIndexState.getBitsPerSelectHashEntry(), HollowHashIndexResult.this.hashIndexState.getBitsPerSelectHashEntry()) - 1;
                    if (selectOrdinal == -1) continue;
                    action.accept(selectOrdinal);
                    return true;
                }
                return false;
            }

            @Override
            public long estimateSize() {
                return 0L;
            }

            @Override
            public int characteristics() {
                return 0;
            }
        };
        return StreamSupport.intStream(si, false);
    }
}

