/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.producer.validation;

import com.netflix.hollow.api.consumer.data.AbstractHollowDataAccessor;
import com.netflix.hollow.api.producer.HollowProducer;
import com.netflix.hollow.api.producer.validation.RecordCountVarianceValidator;
import com.netflix.hollow.api.producer.validation.ValidationResult;
import com.netflix.hollow.api.producer.validation.ValidatorListener;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.read.engine.HollowTypeReadState;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Logger;

public class RecordCountPercentChangeValidator
implements ValidatorListener {
    private static final String NAME = RecordCountVarianceValidator.class.getName();
    private final Logger log = Logger.getLogger(RecordCountPercentChangeValidator.class.getName());
    private final String typeName;
    private final Threshold threshold;
    private AbstractHollowDataAccessor accessor;

    public RecordCountPercentChangeValidator(String typeName, Threshold threshold) {
        this.typeName = typeName;
        this.threshold = threshold;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public ValidationResult onValidate(HollowProducer.ReadState readState) {
        HollowReadStateEngine readStateEngine = Objects.requireNonNull(readState.getStateEngine(), "read state is null");
        HollowTypeReadState typeState = Objects.requireNonNull(readStateEngine.getTypeState(this.typeName), "type not loaded or does not exist in dataset; type=" + this.typeName);
        this.accessor = new AbstractHollowDataAccessor<Object>(readStateEngine, this.typeName){

            @Override
            public Object getRecord(int ordinal) {
                return null;
            }
        };
        ValidationResult validationResult = this.validateChanges(typeState);
        this.log.info(validationResult.toString());
        return validationResult;
    }

    private ValidationResult validateChanges(HollowTypeReadState typeState) {
        boolean pass;
        if (typeState.getPreviousOrdinals().isEmpty()) {
            return ValidationResult.from(this).passed("Ignore the check if previous records are empty.");
        }
        int addRecordNumber = this.accessor.getAddedRecords().size();
        int removeRecordNumber = this.accessor.getRemovedRecords().size();
        int updatedRecordNumber = this.accessor.getUpdatedRecords().size();
        int previousRecordNumber = typeState.getPreviousOrdinals().cardinality();
        float addedPercent = (float)addRecordNumber / (float)previousRecordNumber;
        float removedPercent = (float)removeRecordNumber / (float)previousRecordNumber;
        float updatedPercent = (float)updatedRecordNumber / (float)previousRecordNumber;
        float addedPercentageThreshold = ((Float)this.threshold.addedPercentageThreshold.get()).floatValue();
        float removedPercentageThreshold = ((Float)this.threshold.removedPercentageThreshold.get()).floatValue();
        float updatedPercentageThreshold = ((Float)this.threshold.updatedPercentageThreshold.get()).floatValue();
        ValidationResult.ValidationResultBuilder builder = ValidationResult.from(this);
        builder.detail("addedRecordNumber", addRecordNumber);
        builder.detail("removedRecordNumber", removeRecordNumber);
        builder.detail("updatedRecordNumber", updatedRecordNumber);
        builder.detail("previousRecordNumber", previousRecordNumber);
        builder.detail("addedPercentageThreshold", Float.valueOf(addedPercentageThreshold));
        builder.detail("removedPercentageThreshold", Float.valueOf(removedPercentageThreshold));
        builder.detail("updatedPercentageThreshold", Float.valueOf(updatedPercentageThreshold));
        boolean bl = pass = (addedPercentageThreshold < 0.0f || addedPercent < addedPercentageThreshold) && (removedPercentageThreshold < 0.0f || removedPercent < removedPercentageThreshold) && (updatedPercentageThreshold < 0.0f || updatedPercent < updatedPercentageThreshold);
        if (pass) {
            return builder.passed();
        }
        return builder.failed("record count change is more than threshold");
    }

    public static class Threshold {
        private final Supplier<Float> removedPercentageThreshold;
        private final Supplier<Float> addedPercentageThreshold;
        private final Supplier<Float> updatedPercentageThreshold;

        public Threshold(Supplier<Float> removedPercentageThreshold, Supplier<Float> addedPercentageThreshold, Supplier<Float> updatedPercentageThreshold) {
            this.removedPercentageThreshold = removedPercentageThreshold;
            this.addedPercentageThreshold = addedPercentageThreshold;
            this.updatedPercentageThreshold = updatedPercentageThreshold;
        }

        public static ThresholdBuilder builder() {
            return new ThresholdBuilder();
        }

        public static class ThresholdBuilder {
            private Supplier<Float> removedPercentageThreshold;
            private Supplier<Float> addedPercentageThreshold;
            private Supplier<Float> updatedPercentageThreshold;

            public ThresholdBuilder withRemovedPercentageThreshold(Supplier<Float> removedPercentageThreshold) {
                this.removedPercentageThreshold = removedPercentageThreshold;
                return this;
            }

            public ThresholdBuilder withAddedPercentageThreshold(Supplier<Float> addedPercentageThreshold) {
                this.addedPercentageThreshold = addedPercentageThreshold;
                return this;
            }

            public ThresholdBuilder withUpdatedPercentageThreshold(Supplier<Float> updatedPercentageThreshold) {
                this.updatedPercentageThreshold = updatedPercentageThreshold;
                return this;
            }

            public Threshold build() {
                if (this.removedPercentageThreshold != null && (this.removedPercentageThreshold.get().floatValue() < 0.0f || this.removedPercentageThreshold.get().floatValue() > 1.0f)) {
                    throw new RuntimeException("removed percentage threshold must be between 0 and 1, value " + this.removedPercentageThreshold.get() + " is invalid.");
                }
                if (this.updatedPercentageThreshold != null && (this.updatedPercentageThreshold.get().floatValue() < 0.0f || this.updatedPercentageThreshold.get().floatValue() > 1.0f)) {
                    throw new RuntimeException("updated percentage threshold must be between 0 and 1, value " + this.updatedPercentageThreshold.get() + " is invalid.");
                }
                if (this.addedPercentageThreshold != null && this.addedPercentageThreshold.get().floatValue() < 0.0f) {
                    throw new RuntimeException("added percentage threshold must be >= 0, value " + this.addedPercentageThreshold.get() + " is invalid.");
                }
                if (this.removedPercentageThreshold == null) {
                    this.removedPercentageThreshold = () -> Float.valueOf(-1.0f);
                }
                if (this.updatedPercentageThreshold == null) {
                    this.updatedPercentageThreshold = () -> Float.valueOf(-1.0f);
                }
                if (this.addedPercentageThreshold == null) {
                    this.addedPercentageThreshold = () -> Float.valueOf(-1.0f);
                }
                return new Threshold(this.removedPercentageThreshold, this.addedPercentageThreshold, this.updatedPercentageThreshold);
            }
        }
    }
}

