/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.producer.fs;

import com.netflix.hollow.api.producer.HollowProducer;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;

public class HollowFilesystemAnnouncer
implements HollowProducer.Announcer {
    public static final String ANNOUNCEMENT_FILENAME = "announced.version";
    public static final String ANNOUNCEMENT_FILENAME_TEMPORARY = "announced.version.tmp";
    private final Path publishPath;

    public HollowFilesystemAnnouncer(Path publishPath) {
        this.publishPath = publishPath;
    }

    @Override
    public void announce(long stateVersion) {
        Path announcePath = this.publishPath.resolve(ANNOUNCEMENT_FILENAME);
        Path announcePathTmp = this.publishPath.resolve(ANNOUNCEMENT_FILENAME_TEMPORARY);
        try {
            Files.write(announcePathTmp, String.valueOf(stateVersion).getBytes(), new OpenOption[0]);
            Files.move(announcePathTmp, announcePath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to write to announcement file; path=" + announcePath, ex);
        }
    }
}

