/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.producer;

import com.netflix.hollow.api.producer.HollowProducer;
import java.time.Duration;

public final class Status {
    final StatusType type;
    final Throwable cause;

    public Status(StatusType type, Throwable cause) {
        this.type = type;
        this.cause = cause;
    }

    public StatusType getType() {
        return this.type;
    }

    public Throwable getCause() {
        return this.cause;
    }

    static final class RestoreStageBuilder
    extends AbstractStatusBuilder<RestoreStageBuilder> {
        long versionDesired;
        long versionReached;

        RestoreStageBuilder() {
        }

        RestoreStageBuilder versions(long versionDesired, long versionReached) {
            this.versionDesired = versionDesired;
            this.versionReached = versionReached;
            return this;
        }
    }

    static final class PublishBuilder
    extends AbstractStatusBuilder<PublishBuilder> {
        HollowProducer.Blob blob;

        PublishBuilder() {
        }

        PublishBuilder blob(HollowProducer.Blob blob) {
            this.blob = blob;
            return this;
        }
    }

    static final class IncrementalPopulateBuilder
    extends AbstractStatusBuilder<PublishBuilder> {
        long version;
        long removed;
        long addedOrModified;

        IncrementalPopulateBuilder() {
        }

        IncrementalPopulateBuilder version(long version) {
            this.version = version;
            return this;
        }

        IncrementalPopulateBuilder changes(long removed, long addedOrModified) {
            this.removed = removed;
            this.addedOrModified = addedOrModified;
            return this;
        }
    }

    static final class StageWithStateBuilder
    extends AbstractStatusBuilder<StageWithStateBuilder> {
        HollowProducer.ReadState readState;
        long version;

        StageWithStateBuilder() {
        }

        StageWithStateBuilder readState(HollowProducer.ReadState readState) {
            this.readState = readState;
            return this.version(readState.getVersion());
        }

        StageWithStateBuilder version(long version) {
            this.version = version;
            return this;
        }
    }

    static final class StageBuilder
    extends AbstractStatusBuilder<StageBuilder> {
        long version;

        StageBuilder() {
        }

        StageBuilder version(long version) {
            this.version = version;
            return this;
        }
    }

    static abstract class AbstractStatusBuilder<T extends AbstractStatusBuilder<T>> {
        StatusType type;
        Throwable cause;
        long start = System.currentTimeMillis();
        long end;

        AbstractStatusBuilder() {
        }

        T success() {
            this.type = StatusType.SUCCESS;
            return (T)this;
        }

        T fail(Throwable cause) {
            this.type = StatusType.FAIL;
            this.cause = cause;
            return (T)this;
        }

        Status build() {
            this.end = System.currentTimeMillis();
            return new Status(this.type, this.cause);
        }

        Duration elapsed() {
            return Duration.ofMillis(this.end - this.start);
        }
    }

    public static enum StatusType {
        SUCCESS,
        FAIL;

    }
}

