/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.producer;

import com.netflix.hollow.api.producer.HollowProducer;
import com.netflix.hollow.api.producer.Status;
import com.netflix.hollow.api.producer.listener.AnnouncementListener;
import com.netflix.hollow.api.producer.listener.CycleListener;
import com.netflix.hollow.api.producer.listener.DataModelInitializationListener;
import com.netflix.hollow.api.producer.listener.IntegrityCheckListener;
import com.netflix.hollow.api.producer.listener.PopulateListener;
import com.netflix.hollow.api.producer.listener.PublishListener;
import com.netflix.hollow.api.producer.listener.RestoreListener;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

public interface HollowProducerListener
extends DataModelInitializationListener,
RestoreListener,
CycleListener,
PopulateListener,
PublishListener,
IntegrityCheckListener,
AnnouncementListener {
    @Override
    default public void onProducerInit(Duration elapsed) {
        this.onProducerInit(elapsed.toMillis(), TimeUnit.MILLISECONDS);
    }

    public void onProducerInit(long var1, TimeUnit var3);

    @Override
    public void onProducerRestoreStart(long var1);

    @Override
    default public void onProducerRestoreComplete(com.netflix.hollow.api.producer.Status status, long versionDesired, long versionReached, Duration elapsed) {
        this.onProducerRestoreComplete(new RestoreStatus(status, versionDesired, versionReached), elapsed.toMillis(), TimeUnit.MILLISECONDS);
    }

    public void onProducerRestoreComplete(RestoreStatus var1, long var2, TimeUnit var4);

    @Override
    default public void onCycleSkip(CycleListener.CycleSkipReason reason) {
    }

    @Override
    public void onNewDeltaChain(long var1);

    @Override
    public void onCycleStart(long var1);

    @Override
    default public void onCycleComplete(com.netflix.hollow.api.producer.Status status, HollowProducer.ReadState readState, long version, Duration elapsed) {
        this.onCycleComplete(new ProducerStatus(status, readState, version), elapsed.toMillis(), TimeUnit.MILLISECONDS);
    }

    public void onCycleComplete(ProducerStatus var1, long var2, TimeUnit var4);

    @Override
    public void onPopulateStart(long var1);

    @Override
    default public void onPopulateComplete(com.netflix.hollow.api.producer.Status status, long version, Duration elapsed) {
        this.onPopulateComplete(new ProducerStatus(status, version), elapsed.toMillis(), TimeUnit.MILLISECONDS);
    }

    public void onPopulateComplete(ProducerStatus var1, long var2, TimeUnit var4);

    @Override
    public void onNoDeltaAvailable(long var1);

    @Override
    public void onPublishStart(long var1);

    @Override
    default public void onBlobPublish(com.netflix.hollow.api.producer.Status status, HollowProducer.Blob blob, Duration elapsed) {
        this.onArtifactPublish(new PublishStatus(status, blob), elapsed.toMillis(), TimeUnit.MILLISECONDS);
    }

    public void onArtifactPublish(PublishStatus var1, long var2, TimeUnit var4);

    @Override
    default public void onPublishComplete(com.netflix.hollow.api.producer.Status status, long version, Duration elapsed) {
        this.onPublishComplete(new ProducerStatus(status, version), elapsed.toMillis(), TimeUnit.MILLISECONDS);
    }

    public void onPublishComplete(ProducerStatus var1, long var2, TimeUnit var4);

    @Override
    public void onIntegrityCheckStart(long var1);

    @Override
    default public void onIntegrityCheckComplete(com.netflix.hollow.api.producer.Status status, HollowProducer.ReadState readState, long version, Duration elapsed) {
        this.onIntegrityCheckComplete(new ProducerStatus(status, readState, version), elapsed.toMillis(), TimeUnit.MILLISECONDS);
    }

    public void onIntegrityCheckComplete(ProducerStatus var1, long var2, TimeUnit var4);

    public void onValidationStart(long var1);

    public void onValidationComplete(ProducerStatus var1, long var2, TimeUnit var4);

    @Override
    public void onAnnouncementStart(long var1);

    @Override
    default public void onAnnouncementComplete(com.netflix.hollow.api.producer.Status status, HollowProducer.ReadState readState, long version, Duration elapsed) {
        this.onAnnouncementComplete(new ProducerStatus(status, readState, version), elapsed.toMillis(), TimeUnit.MILLISECONDS);
    }

    public void onAnnouncementComplete(ProducerStatus var1, long var2, TimeUnit var4);

    public static enum Status {
        SUCCESS,
        FAIL,
        SKIP;


        static Status of(Status.StatusType st) {
            return st == Status.StatusType.SUCCESS ? SUCCESS : FAIL;
        }

        static Status.StatusType from(Status s) {
            return s == SUCCESS ? Status.StatusType.SUCCESS : Status.StatusType.FAIL;
        }
    }

    public static class PublishStatus {
        private final Status status;
        private final HollowProducer.Blob blob;
        private final Throwable throwable;

        PublishStatus(com.netflix.hollow.api.producer.Status s, HollowProducer.Blob blob) {
            this.status = Status.of(s.getType());
            this.throwable = s.getCause();
            this.blob = blob;
        }

        public Status getStatus() {
            return this.status;
        }

        public HollowProducer.Blob getBlob() {
            return this.blob;
        }

        public Throwable getCause() {
            return this.throwable;
        }
    }

    public static class RestoreStatus {
        private final Status status;
        private final long versionDesired;
        private final long versionReached;
        private final Throwable throwable;

        RestoreStatus(com.netflix.hollow.api.producer.Status s, long versionDesired, long versionReached) {
            this.status = Status.of(s.getType());
            this.throwable = s.getCause();
            this.versionDesired = versionDesired;
            this.versionReached = versionReached;
        }

        public long getDesiredVersion() {
            return this.versionDesired;
        }

        public long getVersionReached() {
            return this.versionReached;
        }

        public Status getStatus() {
            return this.status;
        }

        public Throwable getCause() {
            return this.throwable;
        }
    }

    public static class ProducerStatus {
        private final long version;
        private final Status status;
        private final Throwable throwable;
        private final HollowProducer.ReadState readState;

        ProducerStatus(com.netflix.hollow.api.producer.Status s, long version) {
            this(s, null, version);
        }

        ProducerStatus(com.netflix.hollow.api.producer.Status s, HollowProducer.ReadState readState, long version) {
            this.status = Status.of(s.getType());
            this.throwable = s.getCause();
            this.readState = readState;
            this.version = version;
        }

        ProducerStatus(Status status, Throwable throwable, long version, HollowProducer.ReadState readState) {
            this.status = status;
            this.version = version;
            this.readState = readState;
            this.throwable = throwable;
        }

        public long getVersion() {
            return this.version;
        }

        public Status getStatus() {
            return this.status;
        }

        public Throwable getCause() {
            return this.throwable;
        }

        public HollowProducer.ReadState getReadState() {
            return this.readState;
        }
    }
}

