/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.perfapi;

import com.netflix.hollow.api.perfapi.HollowTypePerfAPI;
import com.netflix.hollow.api.perfapi.POJOInstantiator;
import com.netflix.hollow.api.perfapi.Ref;
import com.netflix.hollow.core.read.engine.PopulatedOrdinalListener;
import java.util.Arrays;
import java.util.BitSet;

public class HollowPerfAPICache<T> {
    private static final Object[] EMPTY_CACHE = new Object[0];
    private final HollowTypePerfAPI typeAPI;
    private final Object[] cachedItems;

    public HollowPerfAPICache(HollowTypePerfAPI typeAPI, POJOInstantiator<T> instantiator, HollowPerfAPICache<T> previous) {
        this.typeAPI = typeAPI;
        if (!typeAPI.isMissingType()) {
            PopulatedOrdinalListener listener = typeAPI.typeAccess().getTypeState().getListener(PopulatedOrdinalListener.class);
            BitSet populatedOrdinals = listener.getPopulatedOrdinals();
            BitSet previousOrdinals = listener.getPreviousOrdinals();
            int length = Math.max(populatedOrdinals.length(), previousOrdinals.length());
            Object[] arr = previous != null ? Arrays.copyOf(previous.cachedItems, length) : new Object[length];
            for (int ordinal = 0; ordinal < length; ++ordinal) {
                boolean previouslyPopulated;
                boolean bl = previouslyPopulated = previous != null && previousOrdinals.get(ordinal);
                if (previouslyPopulated) continue;
                boolean currentlyPopulated = populatedOrdinals.get(ordinal);
                arr[ordinal] = currentlyPopulated ? instantiator.instantiate(Ref.toRefWithTypeMasked(typeAPI.maskedTypeIdx, ordinal)) : null;
            }
            this.cachedItems = arr;
        } else {
            this.cachedItems = EMPTY_CACHE;
        }
    }

    public T get(long ref) {
        Object t = this.cachedItems[this.typeAPI.ordinal(ref)];
        return (T)t;
    }

    public Object[] getCachedItems() {
        return Arrays.copyOf(this.cachedItems, this.cachedItems.length);
    }
}

