/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.perfapi;

import com.netflix.hollow.api.perfapi.HollowPerfBackedList;
import com.netflix.hollow.api.perfapi.HollowPerfReferenceIterator;
import com.netflix.hollow.api.perfapi.HollowPerformanceAPI;
import com.netflix.hollow.api.perfapi.HollowTypePerfAPI;
import com.netflix.hollow.api.perfapi.POJOInstantiator;
import com.netflix.hollow.api.perfapi.Ref;
import com.netflix.hollow.core.read.dataaccess.HollowDataAccess;
import com.netflix.hollow.core.read.dataaccess.HollowListTypeDataAccess;
import com.netflix.hollow.core.read.dataaccess.missing.HollowListMissingDataAccess;
import com.netflix.hollow.core.read.iterator.HollowOrdinalIterator;
import java.util.List;

public class HollowListTypePerfAPI
extends HollowTypePerfAPI {
    private final HollowListTypeDataAccess typeAccess;
    final long elementMaskedTypeIdx;

    public HollowListTypePerfAPI(HollowDataAccess dataAccess, String typeName, HollowPerformanceAPI api) {
        super(typeName, api);
        HollowListTypeDataAccess typeAccess = (HollowListTypeDataAccess)dataAccess.getTypeDataAccess(typeName);
        int elementTypeIdx = typeAccess == null ? -1 : api.types.getIdx(typeAccess.getSchema().getElementType());
        this.elementMaskedTypeIdx = Ref.toTypeMasked(elementTypeIdx);
        if (typeAccess == null) {
            typeAccess = new HollowListMissingDataAccess(dataAccess, typeName);
        }
        this.typeAccess = typeAccess;
    }

    public int size(long ref) {
        return this.typeAccess.size(this.ordinal(ref));
    }

    public long get(long ref, int idx) {
        int ordinal = this.typeAccess.getElementOrdinal(this.ordinal(ref), idx);
        return Ref.toRefWithTypeMasked(this.elementMaskedTypeIdx, ordinal);
    }

    public HollowPerfReferenceIterator iterator(long ref) {
        HollowOrdinalIterator iter = this.typeAccess.ordinalIterator(this.ordinal(ref));
        return new HollowPerfReferenceIterator(iter, this.elementMaskedTypeIdx);
    }

    public <T> List<T> backedList(long ref, POJOInstantiator<T> instantiator) {
        return new HollowPerfBackedList<T>(this, this.ordinal(ref), instantiator);
    }

    @Override
    public HollowListTypeDataAccess typeAccess() {
        return this.typeAccess;
    }
}

