/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.objects.delegate;

import com.netflix.hollow.api.custom.HollowSetTypeAPI;
import com.netflix.hollow.api.custom.HollowTypeAPI;
import com.netflix.hollow.api.objects.HollowSet;
import com.netflix.hollow.api.objects.delegate.HollowCachedDelegate;
import com.netflix.hollow.api.objects.delegate.HollowSetDelegate;
import com.netflix.hollow.core.memory.encoding.HashCodes;
import com.netflix.hollow.core.read.dataaccess.HollowSetTypeDataAccess;
import com.netflix.hollow.core.read.iterator.HollowOrdinalIterator;
import com.netflix.hollow.core.schema.HollowSetSchema;

public class HollowSetCachedDelegate<T>
implements HollowSetDelegate<T>,
HollowCachedDelegate {
    private final int[] ordinals;
    private final int size;
    private final int hashMask;
    protected HollowSetTypeAPI typeAPI;
    private HollowSetTypeDataAccess dataAccess;

    public HollowSetCachedDelegate(HollowSetTypeDataAccess dataAccess, int ordinal) {
        this(dataAccess, null, ordinal);
    }

    public HollowSetCachedDelegate(HollowSetTypeAPI typeAPI, int ordinal) {
        this(typeAPI.getTypeDataAccess(), typeAPI, ordinal);
    }

    private HollowSetCachedDelegate(HollowSetTypeDataAccess dataAccess, HollowSetTypeAPI typeAPI, int ordinal) {
        int size = dataAccess.size(ordinal);
        int[] ordinals = new int[HashCodes.hashTableSize(size)];
        for (int i = 0; i < ordinals.length; ++i) {
            ordinals[i] = dataAccess.relativeBucketValue(ordinal, i);
        }
        this.ordinals = ordinals;
        this.size = size;
        this.hashMask = ordinals.length - 1;
        this.dataAccess = dataAccess;
        this.typeAPI = typeAPI;
    }

    @Override
    public int size(int ordinal) {
        return this.size;
    }

    @Override
    public boolean contains(HollowSet<T> set, int ordinal, Object o) {
        if (this.getSchema().getHashKey() != null) {
            for (int i = 0; i < this.ordinals.length; ++i) {
                if (this.ordinals[i] == -1 || !set.equalsElement(this.ordinals[i], o)) continue;
                return true;
            }
        } else {
            int hashCode = this.dataAccess.getDataAccess().getHashCodeFinder().hashCode(o);
            int bucket = HashCodes.hashInt(hashCode) & this.hashMask;
            while (this.ordinals[bucket] != -1) {
                if (set.equalsElement(this.ordinals[bucket], o)) {
                    return true;
                }
                ++bucket;
                bucket &= this.hashMask;
            }
        }
        return false;
    }

    @Override
    public T findElement(HollowSet<T> set, int ordinal, Object ... keys) {
        int elementOrdinal = this.dataAccess.findElement(ordinal, keys);
        if (elementOrdinal != -1) {
            return set.instantiateElement(elementOrdinal);
        }
        return null;
    }

    @Override
    public HollowOrdinalIterator iterator(int ordinal) {
        return new HollowOrdinalIterator(){
            private int bucket = -1;

            @Override
            public int next() {
                do {
                    ++this.bucket;
                } while (this.bucket < HollowSetCachedDelegate.this.ordinals.length && HollowSetCachedDelegate.this.ordinals[this.bucket] == -1);
                if (this.bucket >= HollowSetCachedDelegate.this.ordinals.length) {
                    return Integer.MAX_VALUE;
                }
                return HollowSetCachedDelegate.this.ordinals[this.bucket];
            }
        };
    }

    @Override
    public HollowSetSchema getSchema() {
        return this.dataAccess.getSchema();
    }

    @Override
    public HollowSetTypeDataAccess getTypeDataAccess() {
        return this.dataAccess;
    }

    @Override
    public HollowSetTypeAPI getTypeAPI() {
        return this.typeAPI;
    }

    @Override
    public void updateTypeAPI(HollowTypeAPI typeAPI) {
        this.typeAPI = (HollowSetTypeAPI)typeAPI;
        this.dataAccess = this.typeAPI.getTypeDataAccess();
    }
}

