/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.objects.delegate;

import com.netflix.hollow.api.custom.HollowMapTypeAPI;
import com.netflix.hollow.api.objects.HollowMap;
import com.netflix.hollow.api.objects.delegate.HollowMapDelegate;
import com.netflix.hollow.core.read.dataaccess.HollowMapTypeDataAccess;
import com.netflix.hollow.core.read.iterator.HollowMapEntryOrdinalIterator;
import com.netflix.hollow.core.schema.HollowMapSchema;
import java.util.Map;

public class HollowMapLookupDelegate<K, V>
implements HollowMapDelegate<K, V> {
    private final HollowMapTypeDataAccess dataAccess;
    protected final HollowMapTypeAPI typeAPI;

    public HollowMapLookupDelegate(HollowMapTypeDataAccess dataAccess) {
        this(dataAccess, null);
    }

    public HollowMapLookupDelegate(HollowMapTypeAPI typeAPI) {
        this(typeAPI.getTypeDataAccess(), typeAPI);
    }

    private HollowMapLookupDelegate(HollowMapTypeDataAccess dataAccess, HollowMapTypeAPI typeAPI) {
        this.dataAccess = dataAccess;
        this.typeAPI = typeAPI;
    }

    @Override
    public int size(int ordinal) {
        return this.dataAccess.size(ordinal);
    }

    @Override
    public V get(HollowMap<K, V> map, int ordinal, Object key) {
        HollowMapEntryOrdinalIterator iter;
        if (this.getSchema().getHashKey() != null) {
            iter = this.dataAccess.ordinalIterator(ordinal);
        } else {
            int hashCode = this.dataAccess.getDataAccess().getHashCodeFinder().hashCode(key);
            iter = this.dataAccess.potentialMatchOrdinalIterator(ordinal, hashCode);
        }
        while (iter.next()) {
            if (!map.equalsKey(iter.getKey(), key)) continue;
            return map.instantiateValue(iter.getValue());
        }
        return null;
    }

    @Override
    public boolean containsKey(HollowMap<K, V> map, int ordinal, Object key) {
        HollowMapEntryOrdinalIterator iter;
        if (this.getSchema().getHashKey() != null) {
            iter = this.dataAccess.ordinalIterator(ordinal);
        } else {
            int hashCode = this.dataAccess.getDataAccess().getHashCodeFinder().hashCode(key);
            iter = this.dataAccess.potentialMatchOrdinalIterator(ordinal, hashCode);
        }
        while (iter.next()) {
            if (!map.equalsKey(iter.getKey(), key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(HollowMap<K, V> map, int ordinal, Object value) {
        HollowMapEntryOrdinalIterator iter = this.iterator(ordinal);
        while (iter.next()) {
            if (!map.equalsValue(iter.getValue(), value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public K findKey(HollowMap<K, V> map, int ordinal, Object ... hashKey) {
        int keyOrdinal = this.dataAccess.findKey(ordinal, hashKey);
        if (keyOrdinal != -1) {
            return map.instantiateKey(keyOrdinal);
        }
        return null;
    }

    @Override
    public V findValue(HollowMap<K, V> map, int ordinal, Object ... hashKey) {
        int valueOrdinal = this.dataAccess.findValue(ordinal, hashKey);
        if (valueOrdinal != -1) {
            return map.instantiateValue(valueOrdinal);
        }
        return null;
    }

    @Override
    public Map.Entry<K, V> findEntry(final HollowMap<K, V> map, int ordinal, Object ... hashKey) {
        final long entryOrdinals = this.dataAccess.findEntry(ordinal, hashKey);
        if (entryOrdinals != -1L) {
            return new Map.Entry<K, V>(){

                @Override
                public K getKey() {
                    return map.instantiateKey((int)(entryOrdinals >> 32));
                }

                @Override
                public V getValue() {
                    return map.instantiateValue((int)entryOrdinals);
                }

                @Override
                public V setValue(V value) {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return null;
    }

    @Override
    public HollowMapEntryOrdinalIterator iterator(int ordinal) {
        return this.dataAccess.ordinalIterator(ordinal);
    }

    @Override
    public HollowMapSchema getSchema() {
        return this.dataAccess.getSchema();
    }

    @Override
    public HollowMapTypeDataAccess getTypeDataAccess() {
        return this.dataAccess;
    }

    @Override
    public HollowMapTypeAPI getTypeAPI() {
        return this.typeAPI;
    }
}

