/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.objects.delegate;

import com.netflix.hollow.api.custom.HollowMapTypeAPI;
import com.netflix.hollow.api.custom.HollowTypeAPI;
import com.netflix.hollow.api.objects.HollowMap;
import com.netflix.hollow.api.objects.delegate.HollowCachedDelegate;
import com.netflix.hollow.api.objects.delegate.HollowMapDelegate;
import com.netflix.hollow.core.memory.encoding.HashCodes;
import com.netflix.hollow.core.read.dataaccess.HollowMapTypeDataAccess;
import com.netflix.hollow.core.read.iterator.HollowMapEntryOrdinalIterator;
import com.netflix.hollow.core.schema.HollowMapSchema;
import java.util.Map;

public class HollowMapCachedDelegate<K, V>
implements HollowMapDelegate<K, V>,
HollowCachedDelegate {
    private final int[] ordinals;
    private final int hashMask;
    private final int size;
    protected HollowMapTypeAPI typeAPI;
    private HollowMapTypeDataAccess dataAccess;

    public HollowMapCachedDelegate(HollowMapTypeDataAccess dataAccess, int ordinal) {
        this(dataAccess, null, ordinal);
    }

    public HollowMapCachedDelegate(HollowMapTypeAPI typeAPI, int ordinal) {
        this(typeAPI.getTypeDataAccess(), typeAPI, ordinal);
    }

    private HollowMapCachedDelegate(HollowMapTypeDataAccess dataAccess, HollowMapTypeAPI typeAPI, int ordinal) {
        int size = dataAccess.size(ordinal);
        int[] ordinals = new int[HashCodes.hashTableSize(size) * 2];
        for (int i = 0; i < ordinals.length; i += 2) {
            long bucketData = dataAccess.relativeBucket(ordinal, i / 2);
            ordinals[i] = (int)(bucketData >> 32);
            ordinals[i + 1] = (int)bucketData;
        }
        this.ordinals = ordinals;
        this.hashMask = ordinals.length / 2 - 1;
        this.size = size;
        this.dataAccess = dataAccess;
        this.typeAPI = typeAPI;
    }

    @Override
    public int size(int ordinal) {
        return this.size;
    }

    @Override
    public V get(HollowMap<K, V> map, int ordinal, Object key) {
        if (this.getSchema().getHashKey() != null) {
            for (int i = 0; i < this.ordinals.length; i += 2) {
                if (this.ordinals[i] == -1 || !map.equalsKey(this.ordinals[i], key)) continue;
                return map.instantiateValue(this.ordinals[i + 1]);
            }
        } else {
            int hashCode = this.dataAccess.getDataAccess().getHashCodeFinder().hashCode(key);
            int bucket = (HashCodes.hashInt(hashCode) & this.hashMask) * 2;
            while (this.ordinals[bucket] != -1) {
                if (map.equalsKey(this.ordinals[bucket], key)) {
                    return map.instantiateValue(this.ordinals[bucket + 1]);
                }
                bucket += 2;
                bucket &= this.ordinals.length - 1;
            }
        }
        return null;
    }

    @Override
    public boolean containsKey(HollowMap<K, V> map, int ordinal, Object key) {
        if (this.getSchema().getHashKey() != null) {
            for (int i = 0; i < this.ordinals.length; i += 2) {
                if (this.ordinals[i] == -1 || !map.equalsKey(this.ordinals[i], key)) continue;
                return true;
            }
        } else {
            int hashCode = this.dataAccess.getDataAccess().getHashCodeFinder().hashCode(key);
            int bucket = (HashCodes.hashInt(hashCode) & this.hashMask) * 2;
            while (this.ordinals[bucket] != -1) {
                if (map.equalsKey(this.ordinals[bucket], key)) {
                    return true;
                }
                bucket += 2;
                bucket &= this.ordinals.length - 1;
            }
        }
        return false;
    }

    @Override
    public boolean containsValue(HollowMap<K, V> map, int ordinal, Object value) {
        HollowMapEntryOrdinalIterator iter = this.iterator(ordinal);
        while (iter.next()) {
            if (!map.equalsValue(iter.getValue(), value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public K findKey(HollowMap<K, V> map, int ordinal, Object ... hashKey) {
        int keyOrdinal = this.dataAccess.findKey(ordinal, hashKey);
        if (keyOrdinal != -1) {
            return map.instantiateKey(keyOrdinal);
        }
        return null;
    }

    @Override
    public V findValue(HollowMap<K, V> map, int ordinal, Object ... hashKey) {
        int valueOrdinal = this.dataAccess.findValue(ordinal, hashKey);
        if (valueOrdinal != -1) {
            return map.instantiateValue(valueOrdinal);
        }
        return null;
    }

    @Override
    public Map.Entry<K, V> findEntry(final HollowMap<K, V> map, int ordinal, Object ... hashKey) {
        final long entryOrdinals = this.dataAccess.findEntry(ordinal, hashKey);
        if (entryOrdinals != -1L) {
            return new Map.Entry<K, V>(){

                @Override
                public K getKey() {
                    return map.instantiateKey((int)(entryOrdinals >> 32));
                }

                @Override
                public V getValue() {
                    return map.instantiateValue((int)entryOrdinals);
                }

                @Override
                public V setValue(V value) {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return null;
    }

    @Override
    public HollowMapEntryOrdinalIterator iterator(int ordinal) {
        return new HollowMapEntryOrdinalIterator(){
            private int bucket = -2;

            @Override
            public boolean next() {
                do {
                    this.bucket += 2;
                } while (this.bucket < HollowMapCachedDelegate.this.ordinals.length && HollowMapCachedDelegate.this.ordinals[this.bucket] == -1);
                return this.bucket < HollowMapCachedDelegate.this.ordinals.length;
            }

            @Override
            public int getValue() {
                return HollowMapCachedDelegate.this.ordinals[this.bucket + 1];
            }

            @Override
            public int getKey() {
                return HollowMapCachedDelegate.this.ordinals[this.bucket];
            }
        };
    }

    @Override
    public HollowMapSchema getSchema() {
        return this.dataAccess.getSchema();
    }

    @Override
    public HollowMapTypeDataAccess getTypeDataAccess() {
        return this.dataAccess;
    }

    @Override
    public HollowMapTypeAPI getTypeAPI() {
        return this.typeAPI;
    }

    @Override
    public void updateTypeAPI(HollowTypeAPI typeAPI) {
        this.typeAPI = (HollowMapTypeAPI)typeAPI;
        this.dataAccess = this.typeAPI.getTypeDataAccess();
    }
}

