/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.objects.delegate;

import com.netflix.hollow.api.custom.HollowListTypeAPI;
import com.netflix.hollow.api.objects.HollowList;
import com.netflix.hollow.api.objects.delegate.HollowListDelegate;
import com.netflix.hollow.core.read.dataaccess.HollowListTypeDataAccess;
import com.netflix.hollow.core.schema.HollowListSchema;

public class HollowListLookupDelegate<T>
implements HollowListDelegate<T> {
    private final HollowListTypeDataAccess dataAccess;
    protected final HollowListTypeAPI typeAPI;

    public HollowListLookupDelegate(HollowListTypeDataAccess dataAccess) {
        this(dataAccess, null);
    }

    public HollowListLookupDelegate(HollowListTypeAPI typeAPI) {
        this(typeAPI.getTypeDataAccess(), typeAPI);
    }

    private HollowListLookupDelegate(HollowListTypeDataAccess dataAccess, HollowListTypeAPI typeAPI) {
        this.dataAccess = dataAccess;
        this.typeAPI = typeAPI;
    }

    @Override
    public int size(int ordinal) {
        return this.dataAccess.size(ordinal);
    }

    @Override
    public T get(HollowList<T> list, int ordinal, int index) {
        int elementOrdinal = this.dataAccess.getElementOrdinal(ordinal, index);
        return list.instantiateElement(elementOrdinal);
    }

    @Override
    public final boolean contains(HollowList<T> list, int ordinal, Object o) {
        return this.indexOf(list, ordinal, o) != -1;
    }

    @Override
    public final int indexOf(HollowList<T> list, int ordinal, Object o) {
        int size = this.size(ordinal);
        for (int i = 0; i < size; ++i) {
            int elementOrdinal = this.dataAccess.getElementOrdinal(ordinal, i);
            if (!list.equalsElement(elementOrdinal, o)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final int lastIndexOf(HollowList<T> list, int ordinal, Object o) {
        int size = this.size(ordinal);
        for (int i = size - 1; i >= 0; --i) {
            int elementOrdinal = this.dataAccess.getElementOrdinal(ordinal, i);
            if (!list.equalsElement(elementOrdinal, o)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public HollowListSchema getSchema() {
        return this.dataAccess.getSchema();
    }

    @Override
    public HollowListTypeDataAccess getTypeDataAccess() {
        return this.dataAccess;
    }

    @Override
    public HollowListTypeAPI getTypeAPI() {
        return this.typeAPI;
    }
}

