/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.consumer.index;

import com.netflix.hollow.api.consumer.HollowConsumer;
import com.netflix.hollow.api.consumer.index.MatchFieldPathArgumentExtractor;
import com.netflix.hollow.api.consumer.index.SelectFieldPathResultExtractor;
import com.netflix.hollow.api.custom.HollowAPI;
import com.netflix.hollow.api.objects.HollowObject;
import com.netflix.hollow.core.index.FieldPaths;
import com.netflix.hollow.core.index.HollowPrimaryKeyIndex;
import com.netflix.hollow.core.index.key.PrimaryKey;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.core.write.objectmapper.HollowObjectTypeMapper;
import com.netflix.hollow.core.write.objectmapper.HollowTypeMapper;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class UniqueKeyIndex<T extends HollowObject, Q>
implements HollowConsumer.RefreshListener,
HollowConsumer.RefreshRegistrationListener,
Function<Q, T> {
    final HollowConsumer consumer;
    HollowAPI api;
    final SelectFieldPathResultExtractor<T> uniqueTypeExtractor;
    final List<MatchFieldPathArgumentExtractor<Q>> matchFields;
    final String uniqueSchemaName;
    final String[] matchFieldPaths;
    HollowPrimaryKeyIndex hpki;

    UniqueKeyIndex(HollowConsumer consumer, Class<T> uniqueType, PrimaryKey primaryTypeKey, List<MatchFieldPathArgumentExtractor<Q>> matchFields) {
        this.consumer = consumer;
        this.api = consumer.getAPI();
        this.uniqueSchemaName = HollowObjectTypeMapper.getDefaultTypeName(uniqueType);
        this.uniqueTypeExtractor = SelectFieldPathResultExtractor.from(consumer.getAPI().getClass(), consumer.getStateEngine(), uniqueType, "", uniqueType);
        if (primaryTypeKey != null) {
            matchFields = UniqueKeyIndex.validatePrimaryKeyFieldPaths(consumer, this.uniqueSchemaName, primaryTypeKey, matchFields);
        }
        this.matchFields = matchFields;
        this.matchFieldPaths = (String[])matchFields.stream().map(mf -> mf.fieldPath.toString()).toArray(String[]::new);
        this.hpki = new HollowPrimaryKeyIndex(consumer.getStateEngine(), this.uniqueSchemaName, this.matchFieldPaths);
    }

    static <Q> List<MatchFieldPathArgumentExtractor<Q>> validatePrimaryKeyFieldPaths(HollowConsumer consumer, String primaryTypeName, PrimaryKey primaryTypeKey, List<MatchFieldPathArgumentExtractor<Q>> matchFields) {
        List paths = Stream.of(primaryTypeKey.getFieldPaths()).map(fp -> FieldPaths.createFieldPathForPrimaryKey(consumer.getStateEngine(), primaryTypeName, fp)).collect(Collectors.toList());
        List<MatchFieldPathArgumentExtractor<Q>> orderedMatchFields = paths.stream().flatMap(path -> {
            MatchFieldPathArgumentExtractor mfe = matchFields.stream().filter(e -> e.fieldPath.equals(path)).findFirst().orElse(null);
            return mfe != null ? Stream.of(mfe) : null;
        }).collect(Collectors.toList());
        if (orderedMatchFields.size() != paths.size()) {
            throw new IllegalArgumentException();
        }
        return orderedMatchFields;
    }

    UniqueKeyIndex(HollowConsumer consumer, Class<T> uniqueType, PrimaryKey primaryTypeKey, Class<Q> matchFieldsType) {
        this(consumer, uniqueType, primaryTypeKey, MatchFieldPathArgumentExtractor.fromHolderClass(consumer.getStateEngine(), uniqueType, matchFieldsType, FieldPaths::createFieldPathForPrimaryKey));
    }

    UniqueKeyIndex(HollowConsumer consumer, Class<T> uniqueType, PrimaryKey primaryTypeKey, String fieldPath, Class<Q> matchFieldType) {
        this(consumer, uniqueType, primaryTypeKey, Collections.singletonList(MatchFieldPathArgumentExtractor.fromPathAndType(consumer.getStateEngine(), uniqueType, fieldPath, matchFieldType, FieldPaths::createFieldPathForPrimaryKey)));
    }

    @Override
    public T apply(Q key) {
        return this.findMatch(key);
    }

    public T findMatch(Q key) {
        Object[] keyArray = new Object[this.matchFields.size()];
        int keyArrayLogicalSize = 0;
        for (int i = 0; i < this.matchFields.size(); ++i) {
            Object matched = this.matchFields.get(i).extract(key);
            if (matched == null) continue;
            keyArray[keyArrayLogicalSize++] = matched;
        }
        int ordinal = -1;
        if (keyArrayLogicalSize <= 0) {
            return null;
        }
        ordinal = keyArrayLogicalSize == 1 ? this.hpki.getMatchingOrdinal(keyArray[0]) : (keyArrayLogicalSize == 2 ? this.hpki.getMatchingOrdinal(keyArray[0], keyArray[1]) : (keyArrayLogicalSize == 3 ? this.hpki.getMatchingOrdinal(keyArray[0], keyArray[1], keyArray[2]) : this.hpki.getMatchingOrdinal(keyArray)));
        if (ordinal == -1) {
            return null;
        }
        return (T)((HollowObject)this.uniqueTypeExtractor.extract(this.api, ordinal));
    }

    @Override
    public void refreshStarted(long currentVersion, long requestedVersion) {
    }

    @Override
    public void snapshotUpdateOccurred(HollowAPI api, HollowReadStateEngine stateEngine, long version) {
        HollowPrimaryKeyIndex hpki = this.hpki;
        hpki.detachFromDeltaUpdates();
        hpki = new HollowPrimaryKeyIndex(this.consumer.getStateEngine(), hpki.getPrimaryKey());
        hpki.listenForDeltaUpdates();
        this.hpki = hpki;
        this.api = api;
    }

    @Override
    public void deltaUpdateOccurred(HollowAPI api, HollowReadStateEngine stateEngine, long version) {
        this.api = api;
    }

    @Override
    public void blobLoaded(HollowConsumer.Blob transition) {
    }

    @Override
    public void refreshSuccessful(long beforeVersion, long afterVersion, long requestedVersion) {
    }

    @Override
    public void refreshFailed(long beforeVersion, long afterVersion, long requestedVersion, Throwable failureCause) {
    }

    @Override
    public void onBeforeAddition(HollowConsumer c) {
        if (c != this.consumer) {
            throw new IllegalStateException("The index's consumer and the listener's consumer are not the same");
        }
        this.hpki.listenForDeltaUpdates();
    }

    @Override
    public void onAfterRemoval(HollowConsumer c) {
        this.hpki.detachFromDeltaUpdates();
    }

    public static <T extends HollowObject> Builder<T> from(HollowConsumer consumer, Class<T> uniqueType) {
        Objects.requireNonNull(consumer);
        Objects.requireNonNull(uniqueType);
        return new Builder<T>(consumer, uniqueType);
    }

    public static final class Builder<T extends HollowObject> {
        final HollowConsumer consumer;
        final Class<T> uniqueType;
        PrimaryKey primaryTypeKey;

        Builder(HollowConsumer consumer, Class<T> uniqueType) {
            this.consumer = consumer;
            this.uniqueType = uniqueType;
        }

        public Builder<T> bindToPrimaryKey() {
            String primaryTypeName = HollowTypeMapper.getDefaultTypeName(this.uniqueType);
            HollowSchema schema = this.consumer.getStateEngine().getNonNullSchema(primaryTypeName);
            assert (schema.getSchemaType() == HollowSchema.SchemaType.OBJECT);
            this.primaryTypeKey = ((HollowObjectSchema)schema).getPrimaryKey();
            if (this.primaryTypeKey == null) {
                throw new IllegalArgumentException(String.format("No primary key associated with primary type %s", this.uniqueType));
            }
            return this;
        }

        public <Q> UniqueKeyIndex<T, Q> usingBean(Class<Q> keyType) {
            Objects.requireNonNull(keyType);
            return new UniqueKeyIndex<T, Q>(this.consumer, this.uniqueType, this.primaryTypeKey, keyType);
        }

        public <Q> UniqueKeyIndex<T, Q> usingPath(String keyFieldPath, Class<Q> keyFieldType) {
            Objects.requireNonNull(keyFieldPath);
            if (keyFieldPath.isEmpty()) {
                throw new IllegalArgumentException("keyFieldPath argument is an empty String");
            }
            Objects.requireNonNull(keyFieldType);
            return new UniqueKeyIndex<T, Q>(this.consumer, this.uniqueType, this.primaryTypeKey, keyFieldPath, keyFieldType);
        }
    }
}

