/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.consumer.fs;

import com.netflix.hollow.api.consumer.HollowConsumer;
import com.netflix.hollow.core.util.Threads;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HollowFilesystemAnnouncementWatcher
implements HollowConsumer.AnnouncementWatcher {
    private static final Logger log = Logger.getLogger(HollowFilesystemAnnouncementWatcher.class.getName());
    private final Path announcePath;
    private final List<HollowConsumer> subscribedConsumers;
    private final ScheduledExecutorService executor;
    private final ScheduledFuture<?> watchFuture;
    private boolean ownedExecutor;
    private long latestVersion;

    public HollowFilesystemAnnouncementWatcher(Path publishPath) {
        this(publishPath, Executors.newScheduledThreadPool(1, r -> Threads.daemonThread(r, HollowFilesystemAnnouncementWatcher.class, "watch; path=" + publishPath)));
        this.ownedExecutor = true;
    }

    public HollowFilesystemAnnouncementWatcher(Path publishPath, ScheduledExecutorService executor) {
        this.executor = executor;
        this.announcePath = publishPath.resolve("announced.version");
        this.subscribedConsumers = new CopyOnWriteArrayList<HollowConsumer>();
        this.latestVersion = this.readLatestVersion();
        this.watchFuture = this.setupWatch();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.watchFuture.cancel(true);
        if (this.ownedExecutor) {
            this.executor.shutdownNow();
        }
    }

    private ScheduledFuture setupWatch() {
        return this.executor.scheduleWithFixedDelay(new Watch(this), 0L, 1L, TimeUnit.SECONDS);
    }

    @Override
    public long getLatestVersion() {
        return this.latestVersion;
    }

    @Override
    public void subscribeToUpdates(HollowConsumer consumer) {
        this.subscribedConsumers.add(consumer);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long readLatestVersion() {
        if (!Files.isReadable(this.announcePath)) {
            return Long.MIN_VALUE;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(this.announcePath.toFile()));){
            long l = Long.parseLong(reader.readLine());
            return l;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static class Watch
    implements Runnable {
        private FileTime previousFileTime = FileTime.from(0L, TimeUnit.MILLISECONDS);
        private final WeakReference<HollowFilesystemAnnouncementWatcher> ref;

        Watch(HollowFilesystemAnnouncementWatcher watcher) {
            this.ref = new WeakReference<HollowFilesystemAnnouncementWatcher>(watcher);
        }

        @Override
        public void run() {
            try {
                HollowFilesystemAnnouncementWatcher watcher = (HollowFilesystemAnnouncementWatcher)this.ref.get();
                if (watcher != null) {
                    if (!Files.isReadable(watcher.announcePath)) {
                        return;
                    }
                    FileTime lastModifiedTime = Files.getLastModifiedTime(watcher.announcePath, new LinkOption[0]);
                    if (lastModifiedTime.compareTo(this.previousFileTime) > 0) {
                        this.previousFileTime = lastModifiedTime;
                        long currentVersion = watcher.readLatestVersion();
                        if (watcher.latestVersion != currentVersion) {
                            watcher.latestVersion = currentVersion;
                            for (HollowConsumer consumer : watcher.subscribedConsumers) {
                                consumer.triggerAsyncRefresh();
                            }
                        }
                    }
                }
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Exception reading the current announced version", ex);
            }
            catch (Throwable th) {
                log.log(Level.SEVERE, "Exception reading the current announced version", th);
                throw th;
            }
        }
    }
}

