/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.consumer.data;

import com.netflix.hollow.api.consumer.HollowConsumer;
import com.netflix.hollow.core.index.HollowPrimaryKeyIndex;
import com.netflix.hollow.core.index.key.HollowPrimaryKeyValueDeriver;
import com.netflix.hollow.core.index.key.PrimaryKey;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.read.engine.HollowTypeReadState;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.core.util.AllHollowRecordCollection;
import com.netflix.hollow.core.util.HollowRecordCollection;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public abstract class AbstractHollowDataAccessor<T> {
    protected final String type;
    protected final PrimaryKey primaryKey;
    protected final HollowReadStateEngine rStateEngine;
    protected final HollowTypeReadState typeState;
    private BitSet removedOrdinals = new BitSet();
    private BitSet addedOrdinals = new BitSet();
    private List<UpdatedRecord<T>> updatedRecords = Collections.emptyList();
    private boolean isDataChangeComputed = false;

    public AbstractHollowDataAccessor(HollowConsumer consumer, String type) {
        this(consumer.getStateEngine(), type);
    }

    public AbstractHollowDataAccessor(HollowReadStateEngine rStateEngine, String type) {
        this(rStateEngine, type, (PrimaryKey)null);
    }

    public AbstractHollowDataAccessor(HollowReadStateEngine rStateEngine, String type, String ... fieldPaths) {
        this(rStateEngine, type, new PrimaryKey(type, fieldPaths));
    }

    public AbstractHollowDataAccessor(HollowReadStateEngine rStateEngine, String type, PrimaryKey primaryKey) {
        this.rStateEngine = Objects.requireNonNull(rStateEngine, "read state required");
        this.typeState = Objects.requireNonNull(rStateEngine.getTypeState(type), "type not loaded or does not exist in dataset; type=" + type);
        HollowSchema schema = this.typeState.getSchema();
        if (schema instanceof HollowObjectSchema) {
            this.type = type;
            if (primaryKey == null) {
                HollowObjectSchema oSchema = (HollowObjectSchema)schema;
                this.primaryKey = oSchema.getPrimaryKey();
            } else {
                this.primaryKey = primaryKey;
            }
            if (this.primaryKey == null) {
                throw new RuntimeException(String.format("Unsupported DataType=%s with SchemaType=%s : %s", new Object[]{type, schema.getSchemaType(), "PrimaryKey is missing"}));
            }
        } else {
            throw new RuntimeException(String.format("Unsupported DataType=%s with SchemaType=%s : %s", new Object[]{type, schema.getSchemaType(), "Only supported type=" + (Object)((Object)HollowSchema.SchemaType.OBJECT)}));
        }
    }

    public boolean hasPriorState() {
        return !this.typeState.getPreviousOrdinals().isEmpty();
    }

    public synchronized void computeDataChange() {
        if (this.isDataChangeComputed) {
            return;
        }
        this.computeDataChange(this.type, this.rStateEngine, this.primaryKey);
        this.isDataChangeComputed = true;
    }

    public boolean isDataChangeComputed() {
        return this.isDataChangeComputed;
    }

    protected void computeDataChange(String type, HollowReadStateEngine stateEngine, PrimaryKey primaryKey) {
        HollowTypeReadState typeState = stateEngine.getTypeDataAccess(type).getTypeState();
        BitSet previousOrdinals = typeState.getPreviousOrdinals();
        BitSet currentOrdinals = typeState.getPopulatedOrdinals();
        this.removedOrdinals = new BitSet();
        this.removedOrdinals.or(previousOrdinals);
        this.removedOrdinals.andNot(currentOrdinals);
        this.addedOrdinals = new BitSet();
        this.addedOrdinals.or(currentOrdinals);
        this.addedOrdinals.andNot(previousOrdinals);
        this.updatedRecords = new ArrayList<UpdatedRecord<T>>();
        HollowPrimaryKeyValueDeriver keyDeriver = new HollowPrimaryKeyValueDeriver(primaryKey, stateEngine);
        HollowPrimaryKeyIndex removalsIndex = new HollowPrimaryKeyIndex(stateEngine, primaryKey, stateEngine.getMemoryRecycler(), this.removedOrdinals);
        int addedOrdinal = this.addedOrdinals.nextSetBit(0);
        while (addedOrdinal != -1) {
            Object[] key = keyDeriver.getRecordKey(addedOrdinal);
            int removedOrdinal = removalsIndex.getMatchingOrdinal(key);
            if (removedOrdinal != -1) {
                this.updatedRecords.add(new UpdatedRecordOrdinal(removedOrdinal, addedOrdinal));
                this.addedOrdinals.clear(addedOrdinal);
                this.removedOrdinals.clear(removedOrdinal);
            }
            addedOrdinal = this.addedOrdinals.nextSetBit(addedOrdinal + 1);
        }
    }

    public String getType() {
        return this.type;
    }

    public PrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public abstract T getRecord(int var1);

    public Collection<T> getAllRecords() {
        return new AllHollowRecordCollection<T>(this.rStateEngine.getTypeState(this.type)){

            @Override
            protected T getForOrdinal(int ordinal) {
                return AbstractHollowDataAccessor.this.getRecord(ordinal);
            }
        };
    }

    public Collection<T> getAddedRecords() {
        if (!this.isDataChangeComputed) {
            this.computeDataChange();
        }
        return new HollowRecordCollection<T>(this.addedOrdinals){

            @Override
            protected T getForOrdinal(int ordinal) {
                return AbstractHollowDataAccessor.this.getRecord(ordinal);
            }
        };
    }

    public Collection<T> getRemovedRecords() {
        if (!this.isDataChangeComputed) {
            this.computeDataChange();
        }
        return new HollowRecordCollection<T>(this.removedOrdinals){

            @Override
            protected T getForOrdinal(int ordinal) {
                return AbstractHollowDataAccessor.this.getRecord(ordinal);
            }
        };
    }

    public Collection<UpdatedRecord<T>> getUpdatedRecords() {
        if (!this.isDataChangeComputed) {
            this.computeDataChange();
        }
        return this.updatedRecords;
    }

    public static class UpdatedRecord<T> {
        private final T before;
        private final T after;

        public UpdatedRecord(T before, T after) {
            this.before = before;
            this.after = after;
        }

        public T getBefore() {
            return this.before;
        }

        public T getAfter() {
            return this.after;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.after == null ? 0 : this.after.hashCode());
            result = 31 * result + (this.before == null ? 0 : this.before.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UpdatedRecord other = (UpdatedRecord)obj;
            if (this.after == null ? other.after != null : !this.after.equals(other.after)) {
                return false;
            }
            return !(this.before == null ? other.before != null : !this.before.equals(other.before));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("UpdatedRecord [before=");
            builder.append(this.getBefore());
            builder.append(", after=");
            builder.append(this.getAfter());
            builder.append("]");
            return builder.toString();
        }
    }

    private class UpdatedRecordOrdinal
    extends UpdatedRecord<T> {
        private final int before;
        private final int after;

        private UpdatedRecordOrdinal(int before, int after) {
            super(null, null);
            this.before = before;
            this.after = after;
        }

        @Override
        public T getBefore() {
            return AbstractHollowDataAccessor.this.getRecord(this.before);
        }

        @Override
        public T getAfter() {
            return AbstractHollowDataAccessor.this.getRecord(this.after);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            UpdatedRecordOrdinal that = (UpdatedRecordOrdinal)o;
            return this.before == that.before && this.after == that.after;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.before, this.after);
        }
    }
}

