/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.consumer;

import com.netflix.hollow.PublicApi;
import com.netflix.hollow.PublicSpi;
import com.netflix.hollow.api.client.HollowAPIFactory;
import com.netflix.hollow.api.client.HollowClientUpdater;
import com.netflix.hollow.api.consumer.fs.HollowFilesystemBlobRetriever;
import com.netflix.hollow.api.custom.HollowAPI;
import com.netflix.hollow.api.metrics.HollowConsumerMetrics;
import com.netflix.hollow.api.metrics.HollowMetricsCollector;
import com.netflix.hollow.core.memory.MemoryMode;
import com.netflix.hollow.core.read.OptionalBlobPartInput;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.read.filter.HollowFilterConfig;
import com.netflix.hollow.core.read.filter.TypeFilter;
import com.netflix.hollow.core.util.DefaultHashCodeFinder;
import com.netflix.hollow.core.util.HollowObjectHashCodeFinder;
import com.netflix.hollow.core.util.Threads;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.UnaryOperator;
import java.util.logging.Level;
import java.util.logging.Logger;

@PublicApi
public class HollowConsumer {
    private static final Logger LOG = Logger.getLogger(HollowConsumer.class.getName());
    protected final AnnouncementWatcher announcementWatcher;
    protected final HollowClientUpdater updater;
    protected final ReadWriteLock refreshLock;
    protected final HollowConsumerMetrics metrics = new HollowConsumerMetrics();
    private final Executor refreshExecutor;
    private final MemoryMode memoryMode;

    @Deprecated
    protected HollowConsumer(BlobRetriever blobRetriever, AnnouncementWatcher announcementWatcher, List<RefreshListener> refreshListeners, HollowAPIFactory apiFactory, HollowFilterConfig dataFilter, ObjectLongevityConfig objectLongevityConfig, ObjectLongevityDetector objectLongevityDetector, DoubleSnapshotConfig doubleSnapshotConfig, HollowObjectHashCodeFinder hashCodeFinder, Executor refreshExecutor, MemoryMode memoryMode) {
        this(blobRetriever, announcementWatcher, refreshListeners, apiFactory, dataFilter, objectLongevityConfig, objectLongevityDetector, doubleSnapshotConfig, hashCodeFinder, refreshExecutor, memoryMode, null);
    }

    @Deprecated
    protected HollowConsumer(BlobRetriever blobRetriever, AnnouncementWatcher announcementWatcher, List<RefreshListener> refreshListeners, HollowAPIFactory apiFactory, HollowFilterConfig dataFilter, ObjectLongevityConfig objectLongevityConfig, ObjectLongevityDetector objectLongevityDetector, DoubleSnapshotConfig doubleSnapshotConfig, HollowObjectHashCodeFinder hashCodeFinder, Executor refreshExecutor, MemoryMode memoryMode, HollowMetricsCollector<HollowConsumerMetrics> metricsCollector) {
        this.updater = new HollowClientUpdater(blobRetriever, refreshListeners, apiFactory, doubleSnapshotConfig, hashCodeFinder, memoryMode, objectLongevityConfig, objectLongevityDetector, this.metrics, metricsCollector);
        this.updater.setFilter(dataFilter);
        this.announcementWatcher = announcementWatcher;
        this.refreshExecutor = refreshExecutor;
        this.refreshLock = new ReentrantReadWriteLock();
        if (announcementWatcher != null) {
            announcementWatcher.subscribeToUpdates(this);
        }
        this.memoryMode = memoryMode;
    }

    protected <B extends Builder<B>> HollowConsumer(B builder) {
        this.updater = new HollowClientUpdater(builder.blobRetriever, builder.refreshListeners, builder.apiFactory, builder.doubleSnapshotConfig, builder.hashCodeFinder, builder.memoryMode, builder.objectLongevityConfig, builder.objectLongevityDetector, this.metrics, builder.metricsCollector);
        this.updater.setFilter(builder.typeFilter);
        if (builder.skipTypeShardUpdateWithNoAdditions) {
            this.updater.setSkipShardUpdateWithNoAdditions(true);
        }
        this.announcementWatcher = builder.announcementWatcher;
        this.refreshExecutor = builder.refreshExecutor;
        this.refreshLock = new ReentrantReadWriteLock();
        this.memoryMode = builder.memoryMode;
        if (this.announcementWatcher != null) {
            this.announcementWatcher.subscribeToUpdates(this);
        }
    }

    public void triggerRefresh() {
        this.refreshLock.writeLock().lock();
        try {
            this.updater.updateTo(this.announcementWatcher == null ? new VersionInfo(Long.MAX_VALUE) : this.announcementWatcher.getLatestVersionInfo());
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        finally {
            this.refreshLock.writeLock().unlock();
        }
    }

    public void triggerAsyncRefresh() {
        this.triggerAsyncRefreshWithDelay(0);
    }

    public void triggerAsyncRefreshWithDelay(int delayMillis) {
        long targetBeginTime = System.currentTimeMillis() + (long)delayMillis;
        this.refreshExecutor.execute(() -> {
            try {
                long delay = targetBeginTime - System.currentTimeMillis();
                if (delay > 0L) {
                    Thread.sleep(delay);
                }
            }
            catch (InterruptedException e) {
                LOG.log(Level.INFO, "Async refresh interrupted before trigger, refresh cancelled", e);
                return;
            }
            try {
                this.triggerRefresh();
            }
            catch (Error | RuntimeException e) {
                LOG.log(Level.SEVERE, "Async refresh failed", e);
                throw e;
            }
        });
    }

    public void triggerRefreshTo(long version) {
        this.triggerRefreshTo(new VersionInfo(version));
    }

    public void triggerRefreshTo(VersionInfo versionInfo) {
        if (this.announcementWatcher != null) {
            throw new UnsupportedOperationException("Cannot trigger refresh to specified version when a HollowConsumer.AnnouncementWatcher is present");
        }
        try {
            this.updater.updateTo(versionInfo);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public HollowReadStateEngine getStateEngine() {
        return this.updater.getStateEngine();
    }

    public long getCurrentVersionId() {
        return this.updater.getCurrentVersionId();
    }

    public CompletableFuture<Long> getInitialLoad() {
        try {
            this.triggerAsyncRefresh();
        }
        catch (NullPointerException | RejectedExecutionException e) {
            LOG.log(Level.INFO, "Refresh triggered by getInitialLoad() failed; future attempts might succeed", e);
        }
        return this.updater.getInitialLoad();
    }

    public HollowAPI getAPI() {
        return this.updater.getAPI();
    }

    public <T extends HollowAPI> T getAPI(Class<T> apiClass) {
        return (T)((HollowAPI)apiClass.cast(this.updater.getAPI()));
    }

    public void forceDoubleSnapshotNextUpdate() {
        this.updater.forceDoubleSnapshotNextUpdate();
    }

    public void clearFailedTransitions() {
        this.updater.clearFailedTransitions();
    }

    public int getNumFailedSnapshotTransitions() {
        return this.updater.getNumFailedSnapshotTransitions();
    }

    public int getNumFailedDeltaTransitions() {
        return this.updater.getNumFailedDeltaTransitions();
    }

    public Lock getRefreshLock() {
        return this.refreshLock.readLock();
    }

    public void addRefreshListener(RefreshListener listener) {
        this.updater.addRefreshListener(listener, this);
    }

    public void removeRefreshListener(RefreshListener listener) {
        this.updater.removeRefreshListener(listener, this);
    }

    public HollowConsumerMetrics getMetrics() {
        return this.metrics;
    }

    public static <B extends Builder<B>> Builder<B> newHollowConsumer() {
        return new Builder();
    }

    public static Builder<?> withBlobRetriever(BlobRetriever blobRetriever) {
        Builder builder = new Builder();
        return builder.withBlobRetriever(blobRetriever);
    }

    public static Builder<?> withLocalBlobStore(File localBlobStoreDir) {
        Builder builder = new Builder();
        return builder.withLocalBlobStore(localBlobStoreDir);
    }

    @PublicSpi
    public static class Builder<B extends Builder<B>> {
        protected BlobRetriever blobRetriever = null;
        protected AnnouncementWatcher announcementWatcher = null;
        @Deprecated
        protected HollowFilterConfig filterConfig = null;
        protected TypeFilter typeFilter = null;
        protected List<RefreshListener> refreshListeners = new ArrayList<RefreshListener>();
        protected HollowAPIFactory apiFactory = HollowAPIFactory.DEFAULT_FACTORY;
        protected HollowObjectHashCodeFinder hashCodeFinder = new DefaultHashCodeFinder(new String[0]);
        protected DoubleSnapshotConfig doubleSnapshotConfig = DoubleSnapshotConfig.DEFAULT_CONFIG;
        protected ObjectLongevityConfig objectLongevityConfig = ObjectLongevityConfig.DEFAULT_CONFIG;
        protected ObjectLongevityDetector objectLongevityDetector = ObjectLongevityDetector.DEFAULT_DETECTOR;
        protected File localBlobStoreDir = null;
        protected boolean useExistingStaleSnapshot;
        protected Executor refreshExecutor = null;
        protected MemoryMode memoryMode = MemoryMode.ON_HEAP;
        protected HollowMetricsCollector<HollowConsumerMetrics> metricsCollector;
        protected boolean skipTypeShardUpdateWithNoAdditions = false;

        public B withBlobRetriever(BlobRetriever blobRetriever) {
            this.blobRetriever = blobRetriever;
            return (B)this;
        }

        public B withLocalBlobStore(File localBlobStoreDir) {
            this.localBlobStoreDir = localBlobStoreDir;
            return (B)this;
        }

        public B withLocalBlobStore(String localBlobStoreDir) {
            return this.withLocalBlobStore(new File(localBlobStoreDir));
        }

        public B withLocalBlobStore(File localBlobStoreDir, boolean useExistingStaleSnapshot) {
            this.localBlobStoreDir = localBlobStoreDir;
            this.useExistingStaleSnapshot = useExistingStaleSnapshot;
            return (B)this;
        }

        public B withLocalBlobStore(String localBlobStoreDir, boolean useExistingStaleSnapshot) {
            return this.withLocalBlobStore(new File(localBlobStoreDir), useExistingStaleSnapshot);
        }

        public B withAnnouncementWatcher(AnnouncementWatcher announcementWatcher) {
            this.announcementWatcher = announcementWatcher;
            return (B)this;
        }

        public B withRefreshListener(RefreshListener refreshListener) {
            this.refreshListeners.add(refreshListener);
            return (B)this;
        }

        public B withRefreshListeners(RefreshListener ... refreshListeners) {
            Collections.addAll(this.refreshListeners, refreshListeners);
            return (B)this;
        }

        public B withGeneratedAPIClass(Class<? extends HollowAPI> generatedAPIClass, String cachedType, String ... additionalCachedTypes) {
            if (HollowAPI.class.equals(generatedAPIClass)) {
                throw new IllegalArgumentException("must provide a code generated API class");
            }
            generatedAPIClass = Objects.requireNonNull(generatedAPIClass, "API class cannot be null");
            Objects.requireNonNull(additionalCachedTypes, "null detected for varargs parameter additionalCachedTypes");
            String[] cachedTypes = new String[additionalCachedTypes.length + 1];
            cachedTypes[0] = cachedType;
            System.arraycopy(additionalCachedTypes, 0, cachedTypes, 1, additionalCachedTypes.length);
            BitSet nulls = new BitSet(cachedTypes.length);
            for (int i = 0; i < cachedTypes.length; ++i) {
                if (cachedTypes[i] != null) continue;
                nulls.set(i);
            }
            if (!nulls.isEmpty()) {
                throw new NullPointerException("cached types cannot be null; argsWithNull=" + nulls.toString());
            }
            this.apiFactory = new HollowAPIFactory.ForGeneratedAPI<HollowAPI>(generatedAPIClass, cachedTypes);
            return (B)this;
        }

        public B withGeneratedAPIClass(Class<? extends HollowAPI> generatedAPIClass) {
            if (HollowAPI.class.equals(generatedAPIClass)) {
                throw new IllegalArgumentException("must provide a code generated API class");
            }
            this.apiFactory = new HollowAPIFactory.ForGeneratedAPI<HollowAPI>(generatedAPIClass);
            return (B)this;
        }

        @Deprecated
        public B withFilterConfig(HollowFilterConfig filterConfig) {
            this.typeFilter = filterConfig;
            return (B)this;
        }

        public B withTypeFilter(TypeFilter typeFilter) {
            this.typeFilter = typeFilter;
            return (B)this;
        }

        public B withTypeFilter(UnaryOperator<TypeFilter.Builder> op) {
            TypeFilter.Builder builder = (TypeFilter.Builder)op.apply(TypeFilter.newTypeFilter());
            return this.withTypeFilter(builder.build());
        }

        public B withDoubleSnapshotConfig(DoubleSnapshotConfig doubleSnapshotConfig) {
            this.doubleSnapshotConfig = doubleSnapshotConfig;
            return (B)this;
        }

        public B withObjectLongevityConfig(ObjectLongevityConfig objectLongevityConfig) {
            this.objectLongevityConfig = objectLongevityConfig;
            return (B)this;
        }

        public B withObjectLongevityDetector(ObjectLongevityDetector objectLongevityDetector) {
            this.objectLongevityDetector = objectLongevityDetector;
            return (B)this;
        }

        public B withRefreshExecutor(Executor refreshExecutor) {
            this.refreshExecutor = refreshExecutor;
            return (B)this;
        }

        public B withMemoryMode(MemoryMode memoryMode) {
            this.memoryMode = memoryMode;
            return (B)this;
        }

        public B withMetricsCollector(HollowMetricsCollector<HollowConsumerMetrics> metricsCollector) {
            this.metricsCollector = metricsCollector;
            return (B)this;
        }

        public B withSkipTypeShardUpdateWithNoAdditions() {
            this.skipTypeShardUpdateWithNoAdditions = true;
            return (B)this;
        }

        @Deprecated
        public B withHashCodeFinder(HollowObjectHashCodeFinder hashCodeFinder) {
            this.hashCodeFinder = hashCodeFinder;
            return (B)this;
        }

        protected void checkArguments() {
            if (this.filterConfig != null && this.typeFilter != null) {
                throw new IllegalStateException("Only one of typeFilter and filterConfig can be set");
            }
            if (this.blobRetriever == null && this.localBlobStoreDir == null) {
                throw new IllegalArgumentException("A HollowBlobRetriever or local blob store directory must be specified when building a HollowClient");
            }
            BlobRetriever blobRetriever = this.blobRetriever;
            if (this.localBlobStoreDir != null) {
                this.blobRetriever = new HollowFilesystemBlobRetriever(this.localBlobStoreDir.toPath(), blobRetriever, this.useExistingStaleSnapshot);
            }
            if (this.refreshExecutor == null) {
                Class<?> clazz = this.getClass();
                this.refreshExecutor = Executors.newSingleThreadExecutor(r -> Threads.daemonThread(r, clazz, "refresh"));
            }
            if (!this.memoryMode.consumerSupported()) {
                throw new UnsupportedOperationException("Cinder Consumer in " + (Object)((Object)this.memoryMode) + " mode is not supported");
            }
            if (!(this.filterConfig == null && this.typeFilter == null || this.memoryMode.supportsFiltering())) {
                throw new UnsupportedOperationException("Filtering is not supported in shared memory mode");
            }
        }

        public HollowConsumer build() {
            this.checkArguments();
            if (this.filterConfig != null) {
                this.typeFilter = this.filterConfig;
                this.filterConfig = null;
            }
            return new HollowConsumer(this);
        }
    }

    public static class AbstractRefreshListener
    implements TransitionAwareRefreshListener {
        @Override
        public void refreshStarted(long currentVersion, long requestedVersion) {
        }

        @Override
        public void transitionsPlanned(long beforeVersion, long desiredVersion, boolean isSnapshotPlan, List<Blob.BlobType> transitionSequence) {
        }

        @Override
        public void snapshotUpdateOccurred(HollowAPI api, HollowReadStateEngine stateEngine, long version) throws Exception {
        }

        @Override
        public void deltaUpdateOccurred(HollowAPI api, HollowReadStateEngine stateEngine, long version) throws Exception {
        }

        @Override
        public void blobLoaded(Blob transition) {
        }

        @Override
        public void refreshSuccessful(long beforeVersion, long afterVersion, long requestedVersion) {
        }

        @Override
        public void refreshFailed(long beforeVersion, long afterVersion, long requestedVersion, Throwable failureCause) {
        }

        @Override
        public void snapshotApplied(HollowAPI api, HollowReadStateEngine stateEngine, long version) throws Exception {
        }

        @Override
        public void deltaApplied(HollowAPI api, HollowReadStateEngine stateEngine, long version) throws Exception {
        }
    }

    public static interface RefreshRegistrationListener {
        public void onBeforeAddition(HollowConsumer var1);

        public void onAfterRemoval(HollowConsumer var1);
    }

    public static interface TransitionAwareRefreshListener
    extends RefreshListener {
        public void snapshotApplied(HollowAPI var1, HollowReadStateEngine var2, long var3) throws Exception;

        public void deltaApplied(HollowAPI var1, HollowReadStateEngine var2, long var3) throws Exception;

        default public void transitionsPlanned(long beforeVersion, long desiredVersion, boolean isSnapshotPlan, List<Blob.BlobType> transitionSequence) {
        }
    }

    public static interface RefreshListener {
        default public void versionDetected(VersionInfo requestedVersionInfo) {
        }

        public void refreshStarted(long var1, long var3);

        public void snapshotUpdateOccurred(HollowAPI var1, HollowReadStateEngine var2, long var3) throws Exception;

        public void deltaUpdateOccurred(HollowAPI var1, HollowReadStateEngine var2, long var3) throws Exception;

        public void blobLoaded(Blob var1);

        public void refreshSuccessful(long var1, long var3, long var5);

        public void refreshFailed(long var1, long var3, long var5, Throwable var7);
    }

    public static interface ObjectLongevityDetector {
        public static final ObjectLongevityDetector DEFAULT_DETECTOR = new ObjectLongevityDetector(){

            @Override
            public void staleReferenceUsageDetected(int count) {
            }

            @Override
            public void staleReferenceExistenceDetected(int count) {
            }
        };

        public void staleReferenceExistenceDetected(int var1);

        public void staleReferenceUsageDetected(int var1);
    }

    public static interface ObjectLongevityConfig {
        public static final ObjectLongevityConfig DEFAULT_CONFIG = new ObjectLongevityConfig(){

            @Override
            public boolean enableLongLivedObjectSupport() {
                return false;
            }

            @Override
            public boolean dropDataAutomatically() {
                return false;
            }

            @Override
            public boolean forceDropData() {
                return false;
            }

            @Override
            public boolean enableExpiredUsageStackTraces() {
                return false;
            }

            @Override
            public long usageDetectionPeriodMillis() {
                return 3600000L;
            }

            @Override
            public long gracePeriodMillis() {
                return 3600000L;
            }
        };

        public boolean enableLongLivedObjectSupport();

        public boolean enableExpiredUsageStackTraces();

        public long gracePeriodMillis();

        public long usageDetectionPeriodMillis();

        public boolean dropDataAutomatically();

        public boolean forceDropData();
    }

    public static interface DoubleSnapshotConfig {
        public static final DoubleSnapshotConfig DEFAULT_CONFIG = new DoubleSnapshotConfig(){

            @Override
            public int maxDeltasBeforeDoubleSnapshot() {
                return 32;
            }

            @Override
            public boolean allowDoubleSnapshot() {
                return true;
            }
        };

        public boolean allowDoubleSnapshot();

        public int maxDeltasBeforeDoubleSnapshot();

        default public boolean doubleSnapshotOnSchemaChange() {
            return false;
        }
    }

    public static interface AnnouncementWatcher {
        public static final long NO_ANNOUNCEMENT_AVAILABLE = Long.MIN_VALUE;

        public long getLatestVersion();

        public void subscribeToUpdates(HollowConsumer var1);

        default public VersionInfo getLatestVersionInfo() {
            return new VersionInfo(this.getLatestVersion(), Optional.empty(), Optional.empty());
        }
    }

    public static class VersionInfo {
        long version;
        Optional<Boolean> isPinned;
        Optional<Map<String, String>> announcementMetadata;

        public VersionInfo(long version) {
            this(version, Optional.empty(), Optional.empty());
        }

        public VersionInfo(long version, Optional<Map<String, String>> announcementMetadata, Optional<Boolean> isPinned) {
            this.version = version;
            this.announcementMetadata = announcementMetadata;
            this.isPinned = isPinned;
        }

        public long getVersion() {
            return this.version;
        }

        public Optional<Map<String, String>> getAnnouncementMetadata() {
            return this.announcementMetadata;
        }

        public Optional<Boolean> isPinned() {
            return this.isPinned;
        }
    }

    public static abstract class Blob
    implements VersionedBlob {
        protected final long fromVersion;
        protected final long toVersion;
        private final BlobType blobType;

        public Blob(long toVersion) {
            this(Long.MIN_VALUE, toVersion);
        }

        public Blob(long fromVersion, long toVersion) {
            this.fromVersion = fromVersion;
            this.toVersion = toVersion;
            this.blobType = this.isSnapshot() ? BlobType.SNAPSHOT : (this.isReverseDelta() ? BlobType.REVERSE_DELTA : BlobType.DELTA);
        }

        @Override
        public abstract InputStream getInputStream() throws IOException;

        public OptionalBlobPartInput getOptionalBlobPartInputs() throws IOException {
            return null;
        }

        public boolean isSnapshot() {
            return this.fromVersion == Long.MIN_VALUE;
        }

        public boolean isReverseDelta() {
            return this.toVersion < this.fromVersion;
        }

        public boolean isDelta() {
            return !this.isSnapshot() && !this.isReverseDelta();
        }

        public long getFromVersion() {
            return this.fromVersion;
        }

        public long getToVersion() {
            return this.toVersion;
        }

        public BlobType getBlobType() {
            return this.blobType;
        }

        public static enum BlobType {
            SNAPSHOT("snapshot"),
            DELTA("delta"),
            REVERSE_DELTA("reversedelta");

            private final String type;

            private BlobType(String type) {
                this.type = type;
            }

            public String getType() {
                return this.type;
            }
        }
    }

    public static abstract class HeaderBlob
    implements VersionedBlob {
        private final long version;

        protected HeaderBlob(long version) {
            this.version = version;
        }

        public long getVersion() {
            return this.version;
        }
    }

    protected static interface VersionedBlob {
        public InputStream getInputStream() throws IOException;

        default public File getFile() throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    public static interface BlobRetriever {
        public Blob retrieveSnapshotBlob(long var1);

        public Blob retrieveDeltaBlob(long var1);

        public Blob retrieveReverseDeltaBlob(long var1);

        default public Set<String> configuredOptionalBlobParts() {
            return null;
        }

        default public HeaderBlob retrieveHeaderBlob(long currentVersion) {
            throw new UnsupportedOperationException();
        }
    }
}

