/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.codegen.testdata;

import com.netflix.hollow.core.HollowDataset;
import com.netflix.hollow.core.schema.HollowSchema;
import java.util.ArrayList;
import java.util.Comparator;

class HollowTestDataAPIClassGenerator {
    private final HollowDataset dataset;
    private final String apiClassName;
    private final String packageName;

    public HollowTestDataAPIClassGenerator(HollowDataset dataset, String apiClassName, String packageName) {
        this.dataset = dataset;
        this.apiClassName = apiClassName;
        this.packageName = packageName;
    }

    public String generate() {
        StringBuilder builder = new StringBuilder();
        builder.append("package " + this.packageName + ";\n\n");
        builder.append("import com.netflix.hollow.api.testdata.HollowTestDataset;\n\n");
        builder.append("public class " + this.apiClassName + " extends HollowTestDataset {\n\n");
        ArrayList<HollowSchema> schemas = new ArrayList<HollowSchema>(this.dataset.getSchemas());
        schemas.sort(Comparator.comparing(HollowSchema::getName));
        for (HollowSchema schema : schemas) {
            builder.append("    public " + schema.getName() + "TestData<Void> " + schema.getName() + "() {\n");
            builder.append("        " + schema.getName() + "TestData<Void> rec = new " + schema.getName() + "TestData<>(null);\n");
            builder.append("        add(rec);\n");
            builder.append("        return rec;\n");
            builder.append("    }\n\n");
        }
        builder.append("}");
        return builder.toString();
    }
}

