/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.codegen.perfapi;

import com.netflix.hollow.core.HollowDataset;
import com.netflix.hollow.core.schema.HollowSchema;
import java.util.ArrayList;
import java.util.Comparator;

class HollowPerformanceAPIClassGenerator {
    private final HollowDataset dataset;
    private final String apiClassName;
    private final String packageName;

    public HollowPerformanceAPIClassGenerator(HollowDataset dataset, String apiClassName, String packageName) {
        this.dataset = dataset;
        this.apiClassName = apiClassName;
        this.packageName = packageName;
    }

    public String generate() {
        String schemaName;
        StringBuilder builder = new StringBuilder();
        builder.append("package " + this.packageName + ";\n\n");
        builder.append("import com.netflix.hollow.api.perfapi.HollowListTypePerfAPI;\nimport com.netflix.hollow.api.perfapi.HollowMapTypePerfAPI;\nimport com.netflix.hollow.api.perfapi.HollowPerformanceAPI;\nimport com.netflix.hollow.api.perfapi.HollowSetTypePerfAPI;\nimport com.netflix.hollow.core.read.dataaccess.HollowDataAccess;\nimport com.netflix.hollow.core.read.dataaccess.HollowListTypeDataAccess;\nimport com.netflix.hollow.core.read.dataaccess.HollowMapTypeDataAccess;\nimport com.netflix.hollow.core.read.dataaccess.HollowObjectTypeDataAccess;\nimport com.netflix.hollow.core.read.dataaccess.HollowSetTypeDataAccess;\nimport com.netflix.hollow.core.read.dataaccess.HollowTypeDataAccess;\nimport java.util.Set;\n\n");
        builder.append("\n@SuppressWarnings(\"all\")\n");
        builder.append("public class " + this.apiClassName + " extends HollowPerformanceAPI {\n\n");
        ArrayList<HollowSchema> schemas = new ArrayList<HollowSchema>(this.dataset.getSchemas());
        schemas.sort(Comparator.comparing(HollowSchema::getName));
        for (HollowSchema schema : schemas) {
            schemaName = schema.getName();
            switch (schema.getSchemaType()) {
                case OBJECT: {
                    builder.append("    public final " + schemaName + "PerfAPI " + schemaName + ";\n");
                    break;
                }
                case LIST: {
                    builder.append("    public final HollowListTypePerfAPI " + schemaName + ";\n");
                    break;
                }
                case SET: {
                    builder.append("    public final HollowSetTypePerfAPI " + schemaName + ";\n");
                    break;
                }
                case MAP: {
                    builder.append("    public final HollowMapTypePerfAPI " + schemaName + ";\n");
                }
            }
        }
        builder.append("\n");
        builder.append("    public " + this.apiClassName + "(HollowDataAccess dataAccess) {\n");
        builder.append("        super(dataAccess);\n\n");
        for (HollowSchema schema : schemas) {
            schemaName = schema.getName();
            switch (schema.getSchemaType()) {
                case OBJECT: {
                    builder.append("        this." + schemaName + " = new " + schemaName + "PerfAPI(dataAccess, \"" + schemaName + "\", this);\n");
                    break;
                }
                case LIST: {
                    builder.append("        this." + schemaName + " = new HollowListTypePerfAPI(dataAccess, \"" + schemaName + "\", this);\n");
                    break;
                }
                case MAP: {
                    builder.append("        this." + schemaName + " = new HollowMapTypePerfAPI(dataAccess, \"" + schemaName + "\",  this);\n");
                    break;
                }
                case SET: {
                    builder.append("        this." + schemaName + " = new HollowSetTypePerfAPI(dataAccess, \"" + schemaName + "\",  this);\n");
                }
            }
        }
        builder.append("    }\n");
        builder.append("}");
        return builder.toString();
    }
}

