/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.codegen.objects;

import com.netflix.hollow.api.codegen.CodeGeneratorConfig;
import com.netflix.hollow.api.codegen.HollowCodeGenerationUtils;
import com.netflix.hollow.api.codegen.HollowConsumerJavaFileGenerator;
import com.netflix.hollow.api.codegen.HollowErgonomicAPIShortcuts;
import com.netflix.hollow.api.consumer.HollowConsumer;
import com.netflix.hollow.api.consumer.index.FieldPath;
import com.netflix.hollow.api.consumer.index.UniqueKeyIndex;
import com.netflix.hollow.api.objects.HollowObject;
import com.netflix.hollow.core.HollowDataset;
import com.netflix.hollow.core.index.key.PrimaryKey;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.write.objectmapper.HollowTypeName;
import com.netflix.hollow.tools.stringifier.HollowRecordStringifier;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.stream.Collectors;

public class HollowObjectJavaGenerator
extends HollowConsumerJavaFileGenerator {
    public static final String SUB_PACKAGE_NAME = "";
    private final HollowObjectSchema schema;
    private final String apiClassname;
    private final Set<String> parameterizedTypes;
    private final boolean parameterizeClassNames;
    private final String getterPrefix;
    private final HollowErgonomicAPIShortcuts ergonomicShortcuts;
    private final boolean useBooleanFieldErgonomics;
    private final boolean restrictApiToFieldType;

    public HollowObjectJavaGenerator(String packageName, String apiClassname, HollowObjectSchema schema, Set<String> parameterizedTypes, boolean parameterizeClassNames, HollowErgonomicAPIShortcuts ergonomicShortcuts, HollowDataset dataset, CodeGeneratorConfig config) {
        super(packageName, HollowObjectJavaGenerator.computeSubPackageName(schema), dataset, config);
        this.apiClassname = apiClassname;
        this.schema = schema;
        this.className = this.hollowImplClassname(schema.getName());
        this.parameterizedTypes = parameterizedTypes;
        this.parameterizeClassNames = parameterizeClassNames;
        this.getterPrefix = config.getGetterPrefix();
        this.ergonomicShortcuts = ergonomicShortcuts;
        this.useBooleanFieldErgonomics = config.isUseBooleanFieldErgonomics();
        this.restrictApiToFieldType = config.isRestrictApiToFieldType();
    }

    private static String computeSubPackageName(HollowObjectSchema schema) {
        String type = schema.getName();
        if (HollowCodeGenerationUtils.isPrimitiveType(type)) {
            return "core";
        }
        return SUB_PACKAGE_NAME;
    }

    @Override
    public String generate() {
        StringBuilder classBuilder = new StringBuilder();
        this.appendPackageAndCommonImports(classBuilder, this.apiClassname);
        boolean requiresHollowTypeName = !this.className.equals(this.schema.getName());
        classBuilder.append("import " + HollowConsumer.class.getName() + ";\n");
        if (this.schema.getPrimaryKey() != null && this.schema.getPrimaryKey().numFields() > 1) {
            classBuilder.append("import " + FieldPath.class.getName() + ";\n");
        }
        if (this.schema.getPrimaryKey() != null) {
            classBuilder.append("import " + UniqueKeyIndex.class.getName() + ";\n");
        }
        classBuilder.append("import " + HollowObject.class.getName() + ";\n");
        classBuilder.append("import " + HollowObjectSchema.class.getName() + ";\n");
        if (requiresHollowTypeName) {
            classBuilder.append("import " + HollowTypeName.class.getName() + ";\n");
        }
        if (this.config.isUseVerboseToString()) {
            classBuilder.append("import " + HollowRecordStringifier.class.getName() + ";\n");
        }
        classBuilder.append("\n");
        this.appendGeneratedAnnotation(classBuilder);
        classBuilder.append("\n@SuppressWarnings(\"all\")\n");
        if (requiresHollowTypeName) {
            classBuilder.append("@" + HollowTypeName.class.getSimpleName() + "(name=\"" + this.schema.getName() + "\")\n");
        }
        classBuilder.append("public class " + this.className + " extends HollowObject {\n\n");
        this.appendConstructor(classBuilder);
        this.appendAccessors(classBuilder);
        this.appendAPIAccessor(classBuilder);
        this.appendTypeAPIAccessor(classBuilder);
        this.appendDelegateAccessor(classBuilder);
        if (this.config.isUseVerboseToString()) {
            this.appendToString(classBuilder);
        }
        if (this.schema.getPrimaryKey() != null) {
            this.appendPrimaryKey(classBuilder, this.schema.getPrimaryKey());
        }
        classBuilder.append("}");
        return classBuilder.toString();
    }

    private void appendConstructor(StringBuilder classBuilder) {
        classBuilder.append("    public " + this.className + "(" + HollowCodeGenerationUtils.delegateInterfaceName(this.schema.getName()) + " delegate, int ordinal) {\n");
        classBuilder.append("        super(delegate, ordinal);\n");
        classBuilder.append("    }\n\n");
    }

    private void appendAccessors(StringBuilder classBuilder) {
        for (int i = 0; i < this.schema.numFields(); ++i) {
            switch (this.schema.getFieldType(i)) {
                case BOOLEAN: {
                    classBuilder.append(this.generateBooleanFieldAccessor(i));
                    break;
                }
                case BYTES: {
                    classBuilder.append(this.generateByteArrayFieldAccessor(i));
                    break;
                }
                case DOUBLE: {
                    classBuilder.append(this.generateDoubleFieldAccessor(i));
                    break;
                }
                case FLOAT: {
                    classBuilder.append(this.generateFloatFieldAccessor(i));
                    break;
                }
                case INT: {
                    classBuilder.append(this.generateIntFieldAccessor(i));
                    break;
                }
                case LONG: {
                    classBuilder.append(this.generateLongFieldAccessor(i));
                    break;
                }
                case REFERENCE: {
                    classBuilder.append(this.generateReferenceFieldAccessor(i));
                    break;
                }
                case STRING: {
                    classBuilder.append(this.generateStringFieldAccessors(i));
                }
            }
            classBuilder.append("\n\n");
        }
    }

    private String generateByteArrayFieldAccessor(int fieldNum) {
        StringBuilder builder = new StringBuilder();
        String fieldName = HollowCodeGenerationUtils.substituteInvalidChars(this.schema.getFieldName(fieldNum));
        builder.append("    public byte[] ").append(this.getterPrefix).append("get" + HollowCodeGenerationUtils.uppercase(fieldName) + "() {\n");
        builder.append("        return delegate().get" + HollowCodeGenerationUtils.uppercase(fieldName) + "(ordinal);\n");
        builder.append("    }");
        return builder.toString();
    }

    private String generateStringFieldAccessors(int fieldNum) {
        StringBuilder builder = new StringBuilder();
        String fieldName = HollowCodeGenerationUtils.substituteInvalidChars(this.schema.getFieldName(fieldNum));
        builder.append("    public String ").append(this.getterPrefix).append("get" + HollowCodeGenerationUtils.uppercase(fieldName) + "() {\n");
        builder.append("        return delegate().get" + HollowCodeGenerationUtils.uppercase(fieldName) + "(ordinal);\n");
        builder.append("    }\n\n");
        builder.append("    public boolean ").append(this.getterPrefix).append("is" + HollowCodeGenerationUtils.uppercase(fieldName) + "Equal(String testValue) {\n");
        builder.append("        return delegate().is" + HollowCodeGenerationUtils.uppercase(fieldName) + "Equal(ordinal, testValue);\n");
        builder.append("    }");
        return builder.toString();
    }

    private String generateReferenceFieldAccessor(int fieldNum) {
        HollowErgonomicAPIShortcuts.Shortcut shortcut = this.ergonomicShortcuts == null ? null : this.ergonomicShortcuts.getShortcut(this.schema.getName() + "." + this.schema.getFieldName(fieldNum));
        String fieldName = HollowCodeGenerationUtils.substituteInvalidChars(this.schema.getFieldName(fieldNum));
        StringBuilder builder = new StringBuilder();
        if (shortcut != null) {
            switch (shortcut.getType()) {
                case BOOLEAN: 
                case DOUBLE: 
                case FLOAT: 
                case INT: 
                case LONG: {
                    String methodName = shortcut.getType() == HollowObjectSchema.FieldType.BOOLEAN ? HollowCodeGenerationUtils.generateBooleanAccessorMethodName(fieldName, this.useBooleanFieldErgonomics) : "get" + HollowCodeGenerationUtils.uppercase(fieldName);
                    builder.append("    public ").append(HollowCodeGenerationUtils.getJavaBoxedType(shortcut.getType())).append(" ").append(this.getterPrefix).append(methodName);
                    if (!this.restrictApiToFieldType) {
                        builder.append("Boxed");
                    }
                    builder.append("() {\n");
                    builder.append("        return delegate().get" + HollowCodeGenerationUtils.uppercase(fieldName) + "Boxed(ordinal);\n");
                    builder.append("    }\n\n");
                    if (this.restrictApiToFieldType) break;
                    builder.append("    public ").append(HollowCodeGenerationUtils.getJavaScalarType(shortcut.getType())).append(" ").append(this.getterPrefix).append(methodName + "() {\n");
                    builder.append("        return delegate().get" + HollowCodeGenerationUtils.uppercase(fieldName) + "(ordinal);\n");
                    builder.append("    }\n\n");
                    break;
                }
                case BYTES: {
                    builder.append("    public byte[] ").append(this.getterPrefix).append("get" + HollowCodeGenerationUtils.uppercase(fieldName) + "() {\n");
                    builder.append("        return delegate().get" + HollowCodeGenerationUtils.uppercase(fieldName) + "(ordinal);\n");
                    builder.append("    }\n\n");
                    break;
                }
                case STRING: {
                    builder.append("    public String ").append(this.getterPrefix).append("get" + HollowCodeGenerationUtils.uppercase(fieldName) + "() {\n");
                    builder.append("        return delegate().get" + HollowCodeGenerationUtils.uppercase(fieldName) + "(ordinal);\n");
                    builder.append("    }\n\n");
                    builder.append("    public boolean ").append(this.getterPrefix).append("is" + HollowCodeGenerationUtils.uppercase(fieldName) + "Equal(String testValue) {\n");
                    builder.append("        return delegate().is" + HollowCodeGenerationUtils.uppercase(fieldName) + "Equal(ordinal, testValue);\n");
                    builder.append("    }\n\n");
                    break;
                }
            }
        }
        String referencedType = this.schema.getReferencedType(fieldNum);
        boolean parameterize = this.parameterizeClassNames || this.parameterizedTypes.contains(referencedType);
        String methodName = null;
        if (shortcut != null) {
            methodName = this.getterPrefix + "get" + HollowCodeGenerationUtils.uppercase(fieldName) + "HollowReference";
        } else {
            boolean isBooleanRefType = Boolean.class.getSimpleName().equals(referencedType);
            methodName = this.getterPrefix + (isBooleanRefType ? HollowCodeGenerationUtils.generateBooleanAccessorMethodName(fieldName, this.useBooleanFieldErgonomics) : "get" + HollowCodeGenerationUtils.uppercase(fieldName));
        }
        if (parameterize) {
            builder.append("    public <T> T ").append(methodName).append("() {\n");
        } else {
            builder.append("    public ").append(this.hollowImplClassname(referencedType)).append(" ").append(methodName).append("() {\n");
        }
        builder.append("        int refOrdinal = delegate().get" + HollowCodeGenerationUtils.uppercase(fieldName) + "Ordinal(ordinal);\n");
        builder.append("        if(refOrdinal == -1)\n");
        builder.append("            return null;\n");
        builder.append("        return ").append(parameterize ? "(T)" : SUB_PACKAGE_NAME).append(" api().get" + this.hollowImplClassname(referencedType) + "(refOrdinal);\n");
        builder.append("    }");
        return builder.toString();
    }

    private String generateFloatFieldAccessor(int fieldNum) {
        StringBuilder builder = new StringBuilder();
        String fieldName = HollowCodeGenerationUtils.substituteInvalidChars(this.schema.getFieldName(fieldNum));
        builder.append("    public float ").append(this.getterPrefix).append("get").append(HollowCodeGenerationUtils.uppercase(fieldName)).append("() {\n");
        builder.append("        return delegate().get" + HollowCodeGenerationUtils.uppercase(fieldName) + "(ordinal);\n");
        builder.append("    }\n\n");
        if (!this.restrictApiToFieldType) {
            builder.append("    public Float ").append(this.getterPrefix).append("get").append(HollowCodeGenerationUtils.uppercase(fieldName)).append("Boxed() {\n");
            builder.append("        return delegate().get" + HollowCodeGenerationUtils.uppercase(fieldName) + "Boxed(ordinal);\n");
            builder.append("    }");
        }
        return builder.toString();
    }

    private String generateDoubleFieldAccessor(int fieldNum) {
        StringBuilder builder = new StringBuilder();
        String fieldName = HollowCodeGenerationUtils.substituteInvalidChars(this.schema.getFieldName(fieldNum));
        builder.append("    public double ").append(this.getterPrefix).append("get").append(HollowCodeGenerationUtils.uppercase(fieldName)).append("() {\n");
        builder.append("        return delegate().get" + HollowCodeGenerationUtils.uppercase(fieldName) + "(ordinal);\n");
        builder.append("    }\n\n");
        if (!this.restrictApiToFieldType) {
            builder.append("    public Double ").append(this.getterPrefix).append("get").append(HollowCodeGenerationUtils.uppercase(fieldName)).append("Boxed() {\n");
            builder.append("        return delegate().get" + HollowCodeGenerationUtils.uppercase(fieldName) + "Boxed(ordinal);\n");
            builder.append("    }");
        }
        return builder.toString();
    }

    private String generateLongFieldAccessor(int fieldNum) {
        StringBuilder builder = new StringBuilder();
        String fieldName = HollowCodeGenerationUtils.substituteInvalidChars(this.schema.getFieldName(fieldNum));
        builder.append("    public long ").append(this.getterPrefix).append("get").append(HollowCodeGenerationUtils.uppercase(fieldName)).append("() {\n");
        builder.append("        return delegate().get" + HollowCodeGenerationUtils.uppercase(fieldName) + "(ordinal);\n");
        builder.append("    }\n\n");
        if (!this.restrictApiToFieldType) {
            builder.append("    public Long ").append(this.getterPrefix).append("get").append(HollowCodeGenerationUtils.uppercase(fieldName)).append("Boxed() {\n");
            builder.append("        return delegate().get" + HollowCodeGenerationUtils.uppercase(fieldName) + "Boxed(ordinal);\n");
            builder.append("    }");
        }
        return builder.toString();
    }

    private String generateIntFieldAccessor(int fieldNum) {
        StringBuilder builder = new StringBuilder();
        String fieldName = HollowCodeGenerationUtils.substituteInvalidChars(this.schema.getFieldName(fieldNum));
        builder.append("    public int ").append(this.getterPrefix).append("get").append(HollowCodeGenerationUtils.uppercase(fieldName)).append("() {\n");
        builder.append("        return delegate().get" + HollowCodeGenerationUtils.uppercase(fieldName) + "(ordinal);\n");
        builder.append("    }\n\n");
        if (!this.restrictApiToFieldType) {
            builder.append("    public Integer ").append(this.getterPrefix).append("get").append(HollowCodeGenerationUtils.uppercase(fieldName)).append("Boxed() {\n");
            builder.append("        return delegate().get" + HollowCodeGenerationUtils.uppercase(fieldName) + "Boxed(ordinal);\n");
            builder.append("    }");
        }
        return builder.toString();
    }

    private String generateBooleanFieldAccessor(int fieldNum) {
        StringBuilder builder = new StringBuilder();
        String fieldName = this.schema.getFieldName(fieldNum);
        String methodName = HollowCodeGenerationUtils.generateBooleanAccessorMethodName(fieldName, this.useBooleanFieldErgonomics);
        builder.append("    public boolean ").append(this.getterPrefix).append(methodName).append("() {\n");
        builder.append("        return delegate().get" + HollowCodeGenerationUtils.uppercase(fieldName) + "(ordinal);\n");
        builder.append("    }\n\n");
        if (!this.restrictApiToFieldType) {
            builder.append("    public Boolean ").append(this.getterPrefix).append(methodName).append("Boxed() {\n");
            builder.append("        return delegate().get" + HollowCodeGenerationUtils.uppercase(fieldName) + "Boxed(ordinal);\n");
            builder.append("    }");
        }
        return builder.toString();
    }

    private void appendAPIAccessor(StringBuilder classBuilder) {
        classBuilder.append("    public " + this.apiClassname + " api() {\n");
        classBuilder.append("        return typeApi().getAPI();\n");
        classBuilder.append("    }\n\n");
    }

    private void appendTypeAPIAccessor(StringBuilder classBuilder) {
        String typeAPIClassname = HollowCodeGenerationUtils.typeAPIClassname(this.schema.getName());
        classBuilder.append("    public " + typeAPIClassname + " typeApi() {\n");
        classBuilder.append("        return delegate().getTypeAPI();\n");
        classBuilder.append("    }\n\n");
    }

    private void appendDelegateAccessor(StringBuilder classBuilder) {
        classBuilder.append("    protected ").append(HollowCodeGenerationUtils.delegateInterfaceName(this.schema.getName())).append(" delegate() {\n");
        classBuilder.append("        return (").append(HollowCodeGenerationUtils.delegateInterfaceName(this.schema.getName())).append(")delegate;\n");
        classBuilder.append("    }\n\n");
    }

    private void appendToString(StringBuilder classBuilder) {
        classBuilder.append("    public String toString() {\n");
        classBuilder.append("        return new HollowRecordStringifier().stringify(this);\n");
        classBuilder.append("    }\n\n");
    }

    private void appendPrimaryKey(StringBuilder classBuilder, PrimaryKey pk) {
        if (pk.numFields() == 1) {
            String type;
            String boxedType;
            String fieldPath = pk.getFieldPath(0);
            HollowObjectSchema.FieldType fieldType = pk.getFieldType(this.dataset, 0);
            if (HollowObjectSchema.FieldType.REFERENCE.equals((Object)fieldType)) {
                HollowObjectSchema refSchema = pk.getFieldSchema(this.dataset, 0);
                type = boxedType = this.hollowImplClassname(refSchema.getName());
            } else {
                type = HollowCodeGenerationUtils.getJavaScalarType(fieldType);
                boxedType = HollowCodeGenerationUtils.getJavaBoxedType(fieldType);
            }
            this.appendPrimaryKeyDoc(classBuilder, fieldType, type);
            classBuilder.append("    public static UniqueKeyIndex<" + this.className + ", " + boxedType + "> uniqueIndex(HollowConsumer consumer) {\n");
            classBuilder.append("        return UniqueKeyIndex.from(consumer, " + this.className + ".class)\n");
            classBuilder.append("            .bindToPrimaryKey()\n");
            classBuilder.append("            .usingPath(\"" + fieldPath + "\", " + type + ".class);\n");
            classBuilder.append("    }\n\n");
        } else {
            this.appendPrimaryKeyDoc(classBuilder, HollowObjectSchema.FieldType.REFERENCE, this.className + ".Key");
            classBuilder.append("    public static UniqueKeyIndex<" + this.className + ", " + this.className + ".Key> uniqueIndex(HollowConsumer consumer) {\n");
            classBuilder.append("        return UniqueKeyIndex.from(consumer, " + this.className + ".class)\n");
            classBuilder.append("            .bindToPrimaryKey()\n");
            classBuilder.append("            .usingBean(" + this.className + ".Key.class);\n");
            classBuilder.append("    }\n\n");
            classBuilder.append("    public static class Key {\n");
            LinkedHashMap<String, String> parameterList = new LinkedHashMap<String, String>();
            for (int i = 0; i < pk.numFields(); ++i) {
                String type;
                if (i > 0) {
                    classBuilder.append("\n");
                }
                String fieldPath = pk.getFieldPath(i);
                String name = HollowCodeGenerationUtils.normalizeFieldPathToParamName(fieldPath);
                HollowObjectSchema.FieldType fieldType = pk.getFieldType(this.dataset, i);
                if (HollowObjectSchema.FieldType.REFERENCE.equals((Object)fieldType)) {
                    HollowObjectSchema refSchema = pk.getFieldSchema(this.dataset, i);
                    type = this.hollowImplClassname(refSchema.getName());
                } else {
                    type = HollowCodeGenerationUtils.getJavaScalarType(fieldType);
                }
                parameterList.put(name, type);
                classBuilder.append("        @FieldPath(\"" + fieldPath + "\")\n");
                classBuilder.append("        public final " + type + " " + name + ";\n");
            }
            classBuilder.append("\n");
            String parameters = parameterList.entrySet().stream().map(e -> (String)e.getValue() + " " + (String)e.getKey()).collect(Collectors.joining(", "));
            classBuilder.append("        public Key(" + parameters + ") {\n");
            parameterList.forEach((n, t) -> {
                if (t.equals("byte[]")) {
                    classBuilder.append("            this." + n + " = " + n + " == null ? null : " + n + ".clone();\n");
                } else {
                    classBuilder.append("            this." + n + " = " + n + ";\n");
                }
            });
            classBuilder.append("        }\n");
            classBuilder.append("    }\n\n");
        }
    }

    private void appendPrimaryKeyDoc(StringBuilder classBuilder, HollowObjectSchema.FieldType type, String keyTypeName) {
        String kindSnippet;
        switch (type) {
            case REFERENCE: 
            case STRING: {
                kindSnippet = String.format("class {@link %s}", keyTypeName);
                break;
            }
            default: {
                kindSnippet = String.format("type {@code %s}", keyTypeName);
            }
        }
        classBuilder.append("    /**\n");
        classBuilder.append(String.format("     * Creates a unique key index for {@code %s} that has a primary key.\n", this.className));
        classBuilder.append(String.format("     * The primary key is represented by the %s.\n", kindSnippet));
        classBuilder.append("     * <p>\n");
        classBuilder.append("     * By default the unique key index will not track updates to the {@code consumer} and thus\n");
        classBuilder.append("     * any changes will not be reflected in matched results.  To track updates the index must be\n");
        classBuilder.append("     * {@link HollowConsumer#addRefreshListener(HollowConsumer.RefreshListener) registered}\n");
        classBuilder.append("     * with the {@code consumer}\n");
        classBuilder.append("     *\n");
        classBuilder.append("     * @param consumer the consumer\n");
        classBuilder.append("     * @return the unique key index\n");
        classBuilder.append("     */\n");
    }
}

