/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.codegen.indexes;

import com.netflix.hollow.api.codegen.CodeGeneratorConfig;
import com.netflix.hollow.api.codegen.indexes.HollowIndexGenerator;
import com.netflix.hollow.api.consumer.HollowConsumer;
import com.netflix.hollow.api.consumer.index.AbstractHollowUniqueKeyIndex;
import com.netflix.hollow.api.consumer.index.HollowUniqueKeyIndex;
import com.netflix.hollow.core.HollowDataset;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import java.util.Arrays;

public class HollowUniqueKeyIndexGenerator
extends HollowIndexGenerator {
    protected final HollowObjectSchema schema;
    protected final String type;
    protected boolean isGenSimpleConstructor = false;
    protected boolean isParameterizedConstructorPublic = true;
    protected boolean isAutoListenToDataRefresh = false;
    protected boolean isImplementsUniqueKeyIndex = true;

    public HollowUniqueKeyIndexGenerator(String packageName, String apiClassname, HollowObjectSchema schema, HollowDataset dataset, CodeGeneratorConfig config) {
        super(packageName, apiClassname, dataset, config);
        this.type = schema.getName();
        this.className = this.getClassName(schema);
        this.schema = schema;
    }

    protected String getClassName(HollowObjectSchema schema) {
        return schema.getName() + "UniqueKeyIndex";
    }

    @Override
    public String generate() {
        StringBuilder builder = new StringBuilder();
        this.appendPackageAndCommonImports(builder, this.apiClassname, Arrays.asList(this.schema));
        builder.append("import " + HollowConsumer.class.getName() + ";\n");
        builder.append("import " + AbstractHollowUniqueKeyIndex.class.getName() + ";\n");
        builder.append("import " + HollowUniqueKeyIndex.class.getName() + ";\n");
        if (this.isGenSimpleConstructor) {
            builder.append("import " + HollowObjectSchema.class.getName() + ";\n");
        }
        this.appendGeneratedAnnotation(builder);
        builder.append("\n/**\n");
        this.genDeprecatedJavaDoc(builder);
        builder.append(" */\n");
        builder.append("@Deprecated\n");
        builder.append("\n@SuppressWarnings(\"all\")\n");
        builder.append("public class " + this.className + " extends " + AbstractHollowUniqueKeyIndex.class.getSimpleName() + "<" + this.apiClassname + ", " + this.hollowImplClassname(this.type) + "> ");
        if (this.isImplementsUniqueKeyIndex) {
            builder.append("implements " + HollowUniqueKeyIndex.class.getSimpleName() + "<" + this.hollowImplClassname(this.type) + "> ");
        }
        builder.append("{\n\n");
        this.genConstructors(builder);
        this.genPublicAPIs(builder);
        builder.append("}");
        return builder.toString();
    }

    protected void genConstructors(StringBuilder builder) {
        if (this.isGenSimpleConstructor) {
            this.genSimpleConstructor(builder);
        }
        this.genParameterizedConstructor(builder);
    }

    protected void genSimpleConstructor(StringBuilder builder) {
        builder.append("    public " + this.className + "(HollowConsumer consumer) {\n");
        builder.append("        this(consumer, " + this.isAutoListenToDataRefresh + ");\n");
        builder.append("    }\n\n");
        builder.append("    public " + this.className + "(HollowConsumer consumer, boolean isListenToDataRefresh) {\n");
        builder.append("        this(consumer, isListenToDataRefresh, ((HollowObjectSchema)consumer.getStateEngine().getNonNullSchema(\"" + this.type + "\")).getPrimaryKey().getFieldPaths());\n");
        builder.append("    }\n\n");
    }

    protected void genParameterizedConstructor(StringBuilder builder) {
        builder.append("    " + (this.isParameterizedConstructorPublic ? "public " : "private ") + this.className + "(HollowConsumer consumer, String... fieldPaths) {\n");
        builder.append("        this(consumer, " + this.isAutoListenToDataRefresh + ", fieldPaths);\n");
        builder.append("    }\n\n");
        builder.append("    " + (this.isParameterizedConstructorPublic ? "public " : "private ") + this.className + "(HollowConsumer consumer, boolean isListenToDataRefresh, String... fieldPaths) {\n");
        builder.append("        super(consumer, \"" + this.type + "\", isListenToDataRefresh, fieldPaths);\n");
        builder.append("    }\n\n");
    }

    protected void genPublicAPIs(StringBuilder builder) {
        this.genFindMatchAPI(builder);
    }

    protected void genFindMatchAPI(StringBuilder builder) {
        if (this.isImplementsUniqueKeyIndex) {
            builder.append("    @Override\n");
        }
        builder.append("    public " + this.hollowImplClassname(this.type) + " findMatch(Object... keys) {\n");
        builder.append("        int ordinal = idx.getMatchingOrdinal(keys);\n");
        builder.append("        if(ordinal == -1)\n");
        builder.append("            return null;\n");
        builder.append("        return api.get" + this.hollowImplClassname(this.type) + "(ordinal);\n");
        builder.append("    }\n\n");
    }

    protected void genDeprecatedJavaDoc(StringBuilder builder) {
        String typeName = this.hollowImplClassname(this.type);
        builder.append(" * @deprecated see {@link com.netflix.hollow.api.consumer.index.UniqueKeyIndex} which can be built as follows:\n");
        builder.append(" * <pre>{@code\n");
        builder.append(String.format(" *     UniqueKeyIndex<%s, K> uki = UniqueKeyIndex.from(consumer, %1$s.class)\n", typeName));
        builder.append(" *         .usingBean(k);\n");
        builder.append(String.format(" *     %s m = uki.findMatch(k);\n", typeName));
        builder.append(" * }</pre>\n");
        builder.append(" * where {@code K} is a class declaring key field paths members, annotated with\n");
        builder.append(" * {@link com.netflix.hollow.api.consumer.index.FieldPath}, and {@code k} is an instance of\n");
        builder.append(String.format(" * {@code K} that is the key to find the unique {@code %s} object.\n", typeName));
    }
}

