/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.codegen;

import com.netflix.hollow.api.codegen.ArgumentParser;
import com.netflix.hollow.api.codegen.HollowCodeGenerationUtils;
import com.netflix.hollow.api.codegen.HollowPOJOClassGenerator;
import com.netflix.hollow.core.HollowDataset;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.core.util.HollowWriteStateCreator;
import com.netflix.hollow.core.write.HollowWriteStateEngine;
import com.netflix.hollow.core.write.objectmapper.HollowObjectMapper;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;

public class HollowPOJOGenerator {
    private final String packageName;
    private final String pojoClassNameSuffix;
    private final HollowDataset dataset;

    public HollowPOJOGenerator(String packageName, String pojoClassNameSuffix, HollowDataset dataset) {
        this.packageName = packageName;
        this.pojoClassNameSuffix = pojoClassNameSuffix;
        this.dataset = dataset;
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        if (args.length == 0) {
            System.out.println("Usage:\njava " + HollowPOJOGenerator.class.getName() + " --arg1=value1 --arg2=value2\nsee " + GeneratorArguments.class.getName() + " for available arguments.");
            return;
        }
        HollowWriteStateEngine engine = new HollowWriteStateEngine();
        String packageName = null;
        String pojoClassNameSuffix = null;
        String pathToGeneratedFiles = null;
        HollowObjectMapper mapper = new HollowObjectMapper(engine);
        ArgumentParser<GeneratorArguments> argumentParser = new ArgumentParser<GeneratorArguments>(GeneratorArguments.class, args);
        block7: for (ArgumentParser.ParsedArgument arg : argumentParser.getParsedArguments()) {
            switch ((GeneratorArguments)((Object)arg.getKey())) {
                case addToDataModel: {
                    mapper.initializeTypeState(HollowPOJOGenerator.class.getClassLoader().loadClass(arg.getValue()));
                    continue block7;
                }
                case addSchemaFileToDataModel: {
                    HollowWriteStateCreator.readSchemaFileIntoWriteState(arg.getValue(), engine);
                    continue block7;
                }
                case pathToGeneratedFiles: {
                    pathToGeneratedFiles = arg.getValue();
                    continue block7;
                }
                case packageName: {
                    packageName = arg.getValue();
                    continue block7;
                }
                case pojoClassNameSuffix: {
                    pojoClassNameSuffix = arg.getValue();
                    continue block7;
                }
            }
            throw new IllegalArgumentException("Unhandled argument " + arg.getKey());
        }
        new HollowPOJOGenerator(packageName, pojoClassNameSuffix, engine).generateFiles(pathToGeneratedFiles);
    }

    public void generateFiles(String directory) throws IOException {
        this.generateFiles(new File(directory));
    }

    public void generateFiles(File directory) throws IOException {
        Path destinationPath = directory.toPath();
        Path packagePath = Paths.get(this.packageName.replace(".", File.separator), new String[0]);
        if (!destinationPath.toAbsolutePath().endsWith(packagePath)) {
            destinationPath = destinationPath.resolve(packagePath);
        }
        if (!(directory = destinationPath.toFile()).exists()) {
            directory.mkdirs();
        }
        for (HollowSchema schema : this.dataset.getSchemas()) {
            if (!(schema instanceof HollowObjectSchema) || HollowCodeGenerationUtils.isPrimitiveType(schema.getName())) continue;
            HollowPOJOClassGenerator generator = new HollowPOJOClassGenerator(this.dataset, (HollowObjectSchema)schema, this.packageName, this.pojoClassNameSuffix);
            FileWriter writer = new FileWriter(new File(directory, generator.getClassName() + ".java"));
            writer.write(generator.generate());
            writer.close();
        }
    }

    public static enum GeneratorArguments {
        addToDataModel,
        addSchemaFileToDataModel,
        pathToGeneratedFiles,
        packageName,
        pojoClassNameSuffix;

    }
}

