/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.codegen;

import com.netflix.hollow.api.codegen.HollowCodeGenerationUtils;
import com.netflix.hollow.api.codegen.HollowJavaFileGenerator;
import com.netflix.hollow.core.HollowDataset;
import com.netflix.hollow.core.index.key.PrimaryKey;
import com.netflix.hollow.core.schema.HollowListSchema;
import com.netflix.hollow.core.schema.HollowMapSchema;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.core.schema.HollowSetSchema;
import com.netflix.hollow.core.write.objectmapper.HollowInline;
import com.netflix.hollow.core.write.objectmapper.HollowPrimaryKey;
import com.netflix.hollow.core.write.objectmapper.HollowTypeName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class HollowPOJOClassGenerator
implements HollowJavaFileGenerator {
    private final HollowDataset dataset;
    private final HollowObjectSchema schema;
    private final String className;
    private final String classNameSuffix;
    private final String packageName;
    private final boolean memoizeOrdinal;
    private final Set<Class<?>> importClasses;

    public HollowPOJOClassGenerator(HollowDataset dataset, HollowObjectSchema schema, String packageName, String classNameSuffix) {
        this(dataset, schema, packageName, classNameSuffix, false);
    }

    public HollowPOJOClassGenerator(HollowDataset dataset, HollowObjectSchema schema, String packageName, String classNameSuffix, boolean memoizeOrdinal) {
        this.dataset = dataset;
        this.schema = schema;
        this.packageName = packageName;
        this.classNameSuffix = classNameSuffix;
        this.className = HollowPOJOClassGenerator.buildClassName(schema.getName(), classNameSuffix);
        this.importClasses = new HashSet();
        this.memoizeOrdinal = memoizeOrdinal;
    }

    private static String buildClassName(String name, String suffix) {
        if (suffix == null) {
            return name;
        }
        return name + suffix;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public String generate() {
        StringBuilder classBodyBuilder = new StringBuilder();
        this.importClasses.add(HollowTypeName.class);
        classBodyBuilder.append("@SuppressWarnings(\"all\")\n");
        classBodyBuilder.append("@HollowTypeName(name=\"").append(this.schema.getName()).append("\")\n");
        this.generateHollowPrimaryKeyAnnotation(classBodyBuilder);
        classBodyBuilder.append("public class ").append(this.getClassName()).append(" implements Cloneable {\n");
        this.generateInstanceVariables(classBodyBuilder);
        classBodyBuilder.append("\n");
        this.generateConstructorForPrimaryKey(classBodyBuilder);
        this.generateChainableSetters(classBodyBuilder);
        this.generateChainableAddForSetAndList(classBodyBuilder);
        this.generateEqualsMethod(classBodyBuilder);
        this.generateHashCodeMethod(classBodyBuilder);
        this.generateToStringMethod(classBodyBuilder);
        this.generateCloneMethod(classBodyBuilder);
        classBodyBuilder.append("    }\n\n");
        if (this.memoizeOrdinal) {
            classBodyBuilder.append("    private long __assigned_ordinal = -1;\n");
        }
        classBodyBuilder.append("}");
        StringBuilder builder = new StringBuilder();
        builder.append("package ").append(this.packageName).append(";\n\n");
        ArrayList<String> importClassNames = new ArrayList<String>();
        for (Class<?> c : this.importClasses) {
            importClassNames.add(c.getName());
        }
        Collections.sort(importClassNames);
        for (String className : importClassNames) {
            builder.append("import ").append(className).append(";\n");
        }
        builder.append("\n").append((CharSequence)classBodyBuilder);
        return builder.toString();
    }

    private void generateHollowPrimaryKeyAnnotation(StringBuilder classBodyBuilder) {
        PrimaryKey primaryKey = this.schema.getPrimaryKey();
        if (primaryKey == null) {
            return;
        }
        this.importClasses.add(HollowPrimaryKey.class);
        classBodyBuilder.append("@HollowPrimaryKey(fields={");
        for (int i = 0; i < primaryKey.numFields(); ++i) {
            if (i > 0) {
                classBodyBuilder.append(", ");
            }
            classBodyBuilder.append("\"").append(primaryKey.getFieldPath(i)).append("\"");
        }
        classBodyBuilder.append("})\n");
    }

    private void generateInstanceVariables(StringBuilder classBodyBuilder) {
        for (int i = 0; i < this.schema.numFields(); ++i) {
            if (this.fieldNeedsTypeNameAnnotation(i)) {
                classBodyBuilder.append("    @HollowTypeName(name=\"").append(this.schema.getReferencedType(i)).append("\")\n");
            }
            if (this.fieldNeedsInlineAnnotation(i)) {
                this.importClasses.add(HollowInline.class);
                classBodyBuilder.append("    @HollowInline\n");
            }
            classBodyBuilder.append("    public ");
            classBodyBuilder.append(this.fieldType(i));
            classBodyBuilder.append(" ").append(this.getFieldName(i)).append(" = ").append(this.defaultValue(i)).append(";\n");
        }
    }

    private void generateConstructorForPrimaryKey(StringBuilder classBodyBuilder) {
        int fieldIndex;
        int i;
        PrimaryKey primaryKey = this.schema.getPrimaryKey();
        if (primaryKey == null) {
            return;
        }
        classBodyBuilder.append("    private ").append(this.getClassName()).append("() {}\n\n");
        classBodyBuilder.append("    public ").append(this.getClassName()).append("(");
        for (i = 0; i < primaryKey.numFields(); ++i) {
            if (i > 0) {
                classBodyBuilder.append(", ");
            }
            fieldIndex = this.getIndexFromFieldName(primaryKey.getFieldPath(i));
            classBodyBuilder.append(this.fieldType(fieldIndex)).append(" ").append(this.getFieldName(fieldIndex));
        }
        classBodyBuilder.append(") {\n");
        for (i = 0; i < primaryKey.numFields(); ++i) {
            fieldIndex = this.getIndexFromFieldName(primaryKey.getFieldPath(i));
            classBodyBuilder.append("        this.").append(this.getFieldName(fieldIndex)).append(" = ").append(this.getFieldName(fieldIndex)).append(";\n");
        }
        classBodyBuilder.append("    }\n\n");
    }

    private void generateChainableSetters(StringBuilder classBodyBuilder) {
        for (int i = 0; i < this.schema.numFields(); ++i) {
            classBodyBuilder.append("    public ").append(this.getClassName()).append(" set").append(HollowCodeGenerationUtils.uppercase(this.getFieldName(i))).append("(").append(this.fieldType(i)).append(" ").append(this.getFieldName(i)).append(") {\n");
            classBodyBuilder.append("        this.").append(this.getFieldName(i)).append(" = ").append(this.getFieldName(i)).append(";\n");
            classBodyBuilder.append("        return this;\n");
            classBodyBuilder.append("    }\n");
        }
    }

    private void generateChainableAddForSetAndList(StringBuilder classBodyBuilder) {
        for (int i = 0; i < this.schema.numFields(); ++i) {
            HollowSchema referencedSchema;
            if (this.schema.getFieldType(i) != HollowObjectSchema.FieldType.REFERENCE || !((referencedSchema = this.dataset.getSchema(this.schema.getReferencedType(i))) instanceof HollowListSchema) && !(referencedSchema instanceof HollowSetSchema)) continue;
            HollowSchema elementSchema = this.dataset.getSchema(referencedSchema instanceof HollowListSchema ? ((HollowListSchema)referencedSchema).getElementType() : ((HollowSetSchema)referencedSchema).getElementType());
            String elementType = this.buildFieldType(elementSchema);
            Class fieldImplementationType = referencedSchema instanceof HollowListSchema ? ArrayList.class : HashSet.class;
            this.importClasses.add(fieldImplementationType);
            classBodyBuilder.append("    public ").append(this.getClassName()).append(" addTo").append(HollowCodeGenerationUtils.uppercase(this.getFieldName(i))).append("(").append(elementType).append(" ").append(HollowCodeGenerationUtils.lowercase(elementType)).append(") {\n");
            classBodyBuilder.append("        if (this.").append(this.getFieldName(i)).append(" == null) {\n");
            classBodyBuilder.append("            this.").append(this.getFieldName(i)).append(" = new ").append(fieldImplementationType.getSimpleName()).append("<").append(elementType).append(">();\n");
            classBodyBuilder.append("        }\n");
            classBodyBuilder.append("        this.").append(this.getFieldName(i)).append(".add(").append(HollowCodeGenerationUtils.lowercase(elementType)).append(");\n");
            classBodyBuilder.append("        return this;\n");
            classBodyBuilder.append("    }\n");
        }
    }

    private void generateEqualsMethod(StringBuilder classBodyBuilder) {
        classBodyBuilder.append("    public boolean equals(Object other) {\n");
        classBodyBuilder.append("        if (other == this)  return true;\n");
        classBodyBuilder.append("        if (!(other instanceof ").append(this.getClassName()).append("))\n");
        classBodyBuilder.append("            return false;\n\n");
        classBodyBuilder.append("        ").append(this.getClassName()).append(" o = (").append(this.getClassName()).append(") other;\n");
        block5: for (int i = 0; i < this.schema.numFields(); ++i) {
            switch (this.schema.getFieldType(i)) {
                case BOOLEAN: 
                case DOUBLE: 
                case FLOAT: 
                case INT: 
                case LONG: {
                    classBodyBuilder.append("        if (o.").append(this.getFieldName(i)).append(" != ").append(this.getFieldName(i)).append(") return false;\n");
                    continue block5;
                }
                case BYTES: 
                case STRING: {
                    this.importClasses.add(Objects.class);
                    classBodyBuilder.append("        if (!Objects.equals(o.").append(this.getFieldName(i)).append(", ").append(this.getFieldName(i)).append(")) return false;\n");
                    continue block5;
                }
                case REFERENCE: {
                    classBodyBuilder.append("        if (o.").append(this.getFieldName(i)).append(" == null) {\n");
                    classBodyBuilder.append("            if (").append(this.getFieldName(i)).append(" != null) return false;\n");
                    classBodyBuilder.append("        } else if (!o.").append(this.getFieldName(i)).append(".equals(").append(this.getFieldName(i)).append(")) return false;\n");
                }
            }
        }
        classBodyBuilder.append("        return true;\n");
        classBodyBuilder.append("    }\n\n");
    }

    private void generateHashCodeMethod(StringBuilder classBodyBuilder) {
        classBodyBuilder.append("    public int hashCode() {\n");
        classBodyBuilder.append("        int hashCode = 1;\n");
        boolean tempExists = false;
        block9: for (int i = 0; i < this.schema.numFields(); ++i) {
            String fieldName = this.getFieldName(i);
            switch (this.schema.getFieldType(i)) {
                case BOOLEAN: {
                    classBodyBuilder.append("        hashCode = hashCode * 31 + (" + fieldName + "? 1231 : 1237);\n");
                    continue block9;
                }
                case DOUBLE: {
                    if (!tempExists) {
                        classBodyBuilder.append("        long temp;\n");
                    }
                    classBodyBuilder.append("        temp = java.lang.Double.doubleToLongBits(" + fieldName + ")\n");
                    classBodyBuilder.append("        hashCode = hashCode * 31 + (int) (temp ^ (temp >>> 32));\n");
                    continue block9;
                }
                case FLOAT: {
                    classBodyBuilder.append("        hashCode = hashCode * 31 + java.lang.Float.floatToIntBits(" + fieldName + ");\n");
                    continue block9;
                }
                case INT: {
                    classBodyBuilder.append("        hashCode = hashCode * 31 + " + fieldName + ";\n");
                    continue block9;
                }
                case LONG: {
                    classBodyBuilder.append("        hashCode = hashCode * 31 + (int) (" + fieldName + " ^ (" + fieldName + " >>> 32));\n");
                    continue block9;
                }
                case BYTES: 
                case STRING: {
                    this.importClasses.add(Objects.class);
                    classBodyBuilder.append("        hashCode = hashCode * 31 + Objects.hash(" + fieldName + ");\n");
                    continue block9;
                }
                case REFERENCE: {
                    this.importClasses.add(Objects.class);
                    classBodyBuilder.append("        hashCode = hashCode * 31 + Objects.hash(" + fieldName + ");\n");
                }
            }
        }
        classBodyBuilder.append("        return hashCode;\n");
        classBodyBuilder.append("    }\n\n");
    }

    private void generateToStringMethod(StringBuilder classBodyBuilder) {
        classBodyBuilder.append("    public String toString() {\n");
        classBodyBuilder.append("        StringBuilder builder = new StringBuilder(\"").append(this.getClassName()).append("{\");\n");
        for (int i = 0; i < this.schema.numFields(); ++i) {
            classBodyBuilder.append("        builder.append(\"");
            if (i > 0) {
                classBodyBuilder.append(",");
            }
            classBodyBuilder.append(this.getFieldName(i)).append("=\").append(").append(this.getFieldName(i)).append(");\n");
        }
        classBodyBuilder.append("        builder.append(\"}\");\n");
        classBodyBuilder.append("        return builder.toString();\n");
        classBodyBuilder.append("    }\n\n");
    }

    private void generateCloneMethod(StringBuilder classBodyBuilder) {
        classBodyBuilder.append("    public ").append(this.getClassName()).append(" clone() {\n");
        classBodyBuilder.append("        try {\n");
        classBodyBuilder.append("            ").append(this.getClassName()).append(" clone = (" + this.getClassName() + ") super.clone();\n");
        if (this.memoizeOrdinal) {
            classBodyBuilder.append("            clone.__assigned_ordinal = -1;\n");
        }
        classBodyBuilder.append("            return clone;\n");
        classBodyBuilder.append("        } catch (CloneNotSupportedException cnse) { throw new RuntimeException(cnse); }\n");
    }

    private boolean fieldNeedsTypeNameAnnotation(int i) {
        if (this.schema.getFieldType(i) == HollowObjectSchema.FieldType.REFERENCE) {
            HollowSchema referencedSchema = this.dataset.getSchema(this.schema.getReferencedType(i));
            return !referencedSchema.getName().equals(this.expectedCollectionClassName(referencedSchema));
        }
        return false;
    }

    private boolean fieldNeedsInlineAnnotation(int i) {
        return this.schema.getFieldType(i) == HollowObjectSchema.FieldType.STRING;
    }

    private String fieldType(int i) {
        switch (this.schema.getFieldType(i)) {
            case BOOLEAN: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case BYTES: 
            case STRING: {
                return HollowCodeGenerationUtils.getJavaScalarType(this.schema.getFieldType(i));
            }
            case REFERENCE: {
                return this.buildFieldType(this.dataset.getSchema(this.schema.getReferencedType(i)));
            }
        }
        throw new IllegalArgumentException("Field type is unrecognized: " + (Object)((Object)this.schema.getFieldType(i)));
    }

    private String defaultValue(int i) {
        switch (this.schema.getFieldType(i)) {
            case BOOLEAN: {
                return "false";
            }
            case DOUBLE: {
                return "java.lang.Double.NaN";
            }
            case FLOAT: {
                return "java.lang.Float.NaN";
            }
            case INT: {
                return "java.lang.Integer.MIN_VALUE";
            }
            case LONG: {
                return "java.lang.Long.MIN_VALUE";
            }
            case BYTES: 
            case STRING: 
            case REFERENCE: {
                return "null";
            }
        }
        throw new IllegalArgumentException("Field type is unrecognized: " + (Object)((Object)this.schema.getFieldType(i)));
    }

    private String buildFieldType(HollowSchema referencedSchema) {
        if (referencedSchema instanceof HollowObjectSchema) {
            return HollowPOJOClassGenerator.buildClassName(referencedSchema.getName(), this.classNameSuffix);
        }
        if (referencedSchema instanceof HollowListSchema) {
            this.importClasses.add(List.class);
            HollowSchema elementSchema = this.dataset.getSchema(((HollowListSchema)referencedSchema).getElementType());
            return "List<" + this.buildFieldType(elementSchema) + ">";
        }
        if (referencedSchema instanceof HollowSetSchema) {
            this.importClasses.add(Set.class);
            HollowSchema elementSchema = this.dataset.getSchema(((HollowSetSchema)referencedSchema).getElementType());
            return "Set<" + this.buildFieldType(elementSchema) + ">";
        }
        if (referencedSchema instanceof HollowMapSchema) {
            this.importClasses.add(Map.class);
            HollowSchema keySchema = this.dataset.getSchema(((HollowMapSchema)referencedSchema).getKeyType());
            HollowSchema valueSchema = this.dataset.getSchema(((HollowMapSchema)referencedSchema).getValueType());
            return "Map<" + this.buildFieldType(keySchema) + ", " + this.buildFieldType(valueSchema) + ">";
        }
        throw new IllegalArgumentException("Schema is unrecognized type " + referencedSchema.getClass().getSimpleName());
    }

    private String expectedCollectionClassName(HollowSchema referencedSchema) {
        if (referencedSchema instanceof HollowObjectSchema) {
            return referencedSchema.getName();
        }
        if (referencedSchema instanceof HollowListSchema) {
            this.importClasses.add(List.class);
            HollowSchema elementSchema = this.dataset.getSchema(((HollowListSchema)referencedSchema).getElementType());
            return "ListOf" + this.expectedCollectionClassName(elementSchema);
        }
        if (referencedSchema instanceof HollowSetSchema) {
            this.importClasses.add(Set.class);
            HollowSchema elementSchema = this.dataset.getSchema(((HollowSetSchema)referencedSchema).getElementType());
            return "SetOf" + this.expectedCollectionClassName(elementSchema);
        }
        if (referencedSchema instanceof HollowMapSchema) {
            this.importClasses.add(Map.class);
            HollowSchema keySchema = this.dataset.getSchema(((HollowMapSchema)referencedSchema).getKeyType());
            HollowSchema valueSchema = this.dataset.getSchema(((HollowMapSchema)referencedSchema).getValueType());
            return "MapOf" + this.expectedCollectionClassName(keySchema) + "To" + this.expectedCollectionClassName(valueSchema);
        }
        throw new IllegalArgumentException("Expected HollowCollectionSchema or HollowMapSchema but got " + referencedSchema.getClass().getSimpleName());
    }

    private String getFieldName(int index) {
        return HollowCodeGenerationUtils.substituteInvalidChars(this.schema.getFieldName(index));
    }

    private int getIndexFromFieldName(String fieldName) {
        for (int i = 0; i < this.schema.numFields(); ++i) {
            if (!this.getFieldName(i).equals(fieldName)) continue;
            return i;
        }
        return -1;
    }
}

