/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.codegen;

import com.netflix.hollow.api.client.HollowAPIFactory;
import com.netflix.hollow.api.codegen.CodeGeneratorConfig;
import com.netflix.hollow.api.codegen.HollowConsumerJavaFileGenerator;
import com.netflix.hollow.api.custom.HollowAPI;
import com.netflix.hollow.api.objects.provider.HollowFactory;
import com.netflix.hollow.core.HollowDataset;
import com.netflix.hollow.core.read.dataaccess.HollowDataAccess;
import java.util.Collections;
import java.util.Set;

public class HollowAPIFactoryJavaGenerator
extends HollowConsumerJavaFileGenerator {
    public static final String SUB_PACKAGE_NAME = "core";
    private final String apiClassname;

    public HollowAPIFactoryJavaGenerator(String packageName, String apiClassname, HollowDataset dataset, CodeGeneratorConfig config) {
        super(packageName, SUB_PACKAGE_NAME, dataset, config);
        this.apiClassname = apiClassname;
        this.className = apiClassname + "Factory";
    }

    @Override
    public String generate() {
        StringBuilder builder = new StringBuilder();
        this.appendPackageAndCommonImports(builder, this.apiClassname);
        builder.append("import ").append(HollowAPIFactory.class.getName()).append(";\n");
        builder.append("import ").append(HollowAPI.class.getName()).append(";\n");
        builder.append("import ").append(HollowFactory.class.getName()).append(";\n");
        builder.append("import ").append(HollowDataAccess.class.getName()).append(";\n");
        builder.append("import ").append(Collections.class.getName()).append(";\n");
        builder.append("import ").append(Set.class.getName()).append(";\n");
        this.appendGeneratedAnnotation(builder);
        builder.append("\n@SuppressWarnings(\"all\")\n");
        builder.append("public class ").append(this.className).append(" implements HollowAPIFactory {\n\n");
        builder.append("    private final Set<String> cachedTypes;\n\n");
        builder.append("    public ").append(this.className).append("() {\n");
        builder.append("        this(Collections.<String>emptySet());\n");
        builder.append("    }\n\n");
        builder.append("    public ").append(this.className).append("(Set<String> cachedTypes) {\n");
        builder.append("        this.cachedTypes = cachedTypes;\n");
        builder.append("    }\n\n");
        builder.append("    @Override\n");
        builder.append("    public HollowAPI createAPI(HollowDataAccess dataAccess) {\n");
        builder.append("        return new ").append(this.apiClassname).append("(dataAccess, cachedTypes);\n");
        builder.append("    }\n\n");
        builder.append("    @Override\n");
        builder.append("    public HollowAPI createAPI(HollowDataAccess dataAccess, HollowAPI previousCycleAPI) {\n");
        builder.append("        if (!(previousCycleAPI instanceof ").append(this.apiClassname).append(")) {\n");
        builder.append("            throw new ClassCastException(previousCycleAPI.getClass() + \" not instance of ").append(this.apiClassname).append("\");");
        builder.append("        }\n");
        builder.append("        return new ").append(this.apiClassname).append("(dataAccess, cachedTypes, Collections.<String, HollowFactory<?>>emptyMap(), (").append(this.apiClassname).append(") previousCycleAPI);\n");
        builder.append("    }\n\n");
        builder.append("}");
        return builder.toString();
    }
}

