/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.client;

import com.netflix.hollow.api.client.HollowBlobRetriever;
import com.netflix.hollow.api.client.HollowClientConsumerBridge;
import com.netflix.hollow.api.client.HollowUpdatePlan;
import com.netflix.hollow.api.consumer.HollowConsumer;

public class HollowUpdatePlanner {
    private final HollowConsumer.BlobRetriever transitionCreator;
    private final HollowConsumer.DoubleSnapshotConfig doubleSnapshotConfig;

    @Deprecated
    public HollowUpdatePlanner(HollowBlobRetriever blobRetriever) {
        this(HollowClientConsumerBridge.consumerBlobRetrieverFor(blobRetriever));
    }

    public HollowUpdatePlanner(HollowConsumer.BlobRetriever blobRetriever) {
        this(blobRetriever, new HollowConsumer.DoubleSnapshotConfig(){

            @Override
            public int maxDeltasBeforeDoubleSnapshot() {
                return 32;
            }

            @Override
            public boolean allowDoubleSnapshot() {
                return true;
            }
        });
    }

    public HollowUpdatePlanner(HollowConsumer.BlobRetriever transitionCreator, HollowConsumer.DoubleSnapshotConfig doubleSnapshotConfig) {
        this.transitionCreator = transitionCreator;
        this.doubleSnapshotConfig = doubleSnapshotConfig;
    }

    public HollowUpdatePlan planInitializingUpdate(long desiredVersion) throws Exception {
        return this.planUpdate(Long.MIN_VALUE, desiredVersion, true);
    }

    public HollowUpdatePlan planUpdate(long currentVersion, long desiredVersion, boolean allowSnapshot) throws Exception {
        HollowUpdatePlan snapshotPlan;
        long snapshotDestinationVersion;
        if (desiredVersion == currentVersion) {
            return HollowUpdatePlan.DO_NOTHING;
        }
        if (currentVersion == Long.MIN_VALUE) {
            return this.snapshotPlan(desiredVersion);
        }
        HollowUpdatePlan deltaPlan = this.deltaPlan(currentVersion, desiredVersion, this.doubleSnapshotConfig.maxDeltasBeforeDoubleSnapshot());
        long deltaDestinationVersion = deltaPlan.destinationVersion(currentVersion);
        if (deltaDestinationVersion != desiredVersion && allowSnapshot && ((snapshotDestinationVersion = (snapshotPlan = this.snapshotPlan(desiredVersion)).destinationVersion(currentVersion)) == desiredVersion || deltaDestinationVersion > desiredVersion && snapshotDestinationVersion < desiredVersion || snapshotDestinationVersion < desiredVersion && snapshotDestinationVersion > deltaDestinationVersion)) {
            return snapshotPlan;
        }
        return deltaPlan;
    }

    private HollowUpdatePlan snapshotPlan(long desiredVersion) {
        HollowUpdatePlan plan = new HollowUpdatePlan();
        long nearestPreviousSnapshotVersion = this.includeNearestSnapshot(plan, desiredVersion);
        if (nearestPreviousSnapshotVersion > desiredVersion) {
            return HollowUpdatePlan.DO_NOTHING;
        }
        if (nearestPreviousSnapshotVersion == Long.MAX_VALUE) {
            return HollowUpdatePlan.DO_NOTHING;
        }
        plan.appendPlan(this.deltaPlan(nearestPreviousSnapshotVersion, desiredVersion, Integer.MAX_VALUE));
        return plan;
    }

    private HollowUpdatePlan deltaPlan(long currentVersion, long desiredVersion, int maxDeltas) {
        HollowUpdatePlan plan = new HollowUpdatePlan();
        if (currentVersion < desiredVersion) {
            this.applyForwardDeltasToPlan(currentVersion, desiredVersion, plan, maxDeltas);
        } else if (currentVersion > desiredVersion) {
            this.applyReverseDeltasToPlan(currentVersion, desiredVersion, plan, maxDeltas);
        }
        return plan;
    }

    private long applyForwardDeltasToPlan(long currentVersion, long desiredVersion, HollowUpdatePlan plan, int maxDeltas) {
        for (int transitionCounter = 0; currentVersion < desiredVersion && transitionCounter < maxDeltas; ++transitionCounter) {
            currentVersion = this.includeNextDelta(plan, currentVersion, desiredVersion);
        }
        return currentVersion;
    }

    private long applyReverseDeltasToPlan(long currentVersion, long desiredVersion, HollowUpdatePlan plan, int maxDeltas) {
        long achievedVersion = currentVersion;
        for (int transitionCounter = 0; currentVersion > desiredVersion && transitionCounter < maxDeltas; ++transitionCounter) {
            if ((currentVersion = this.includeNextReverseDelta(plan, currentVersion)) == Long.MIN_VALUE) continue;
            achievedVersion = currentVersion;
        }
        return achievedVersion;
    }

    private long includeNextDelta(HollowUpdatePlan plan, long currentVersion, long desiredVersion) {
        HollowConsumer.Blob transition = this.transitionCreator.retrieveDeltaBlob(currentVersion);
        if (transition != null) {
            if (transition.getToVersion() <= desiredVersion) {
                plan.add(transition);
            }
            return transition.getToVersion();
        }
        return Long.MAX_VALUE;
    }

    private long includeNextReverseDelta(HollowUpdatePlan plan, long currentVersion) {
        HollowConsumer.Blob transition = this.transitionCreator.retrieveReverseDeltaBlob(currentVersion);
        if (transition != null) {
            plan.add(transition);
            return transition.getToVersion();
        }
        return Long.MIN_VALUE;
    }

    private long includeNearestSnapshot(HollowUpdatePlan plan, long desiredVersion) {
        HollowConsumer.Blob transition = this.transitionCreator.retrieveSnapshotBlob(desiredVersion);
        if (transition != null) {
            plan.add(transition);
            return transition.getToVersion();
        }
        return Long.MAX_VALUE;
    }
}

