/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.eclipse.collections.api.map.primitive.MutableLongLongMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.Serializer;
import org.mapdb.Store;
import org.mapdb.Utils;
import org.mapdb.serializer.GroupSerializer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010)\n\u0002\b\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u0002B3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0017\u0010!\u001a\u00020\f2\b\u0010\"\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010#J\u001f\u0010!\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001a2\b\u0010\"\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010&J\u000e\u0010'\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001aJ\b\u0010(\u001a\u00020$H\u0016J\u0018\u0010)\u001a\u0004\u0018\u00018\u00002\u0006\u0010%\u001a\u00020\u001aH\u0096\u0002\u00a2\u0006\u0002\u0010*J\b\u0010+\u001a\u00020\fH\u0016J\u0011\u0010,\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000-H\u0096\u0002J\u0017\u0010.\u001a\u0004\u0018\u00018\u00002\u0006\u0010%\u001a\u00020\u001aH\u0016\u00a2\u0006\u0002\u0010*J\"\u0010/\u001a\u0004\u0018\u00018\u00002\u0006\u0010%\u001a\u00020\u001a2\b\u0010\"\u001a\u0004\u0018\u00018\u0000H\u0096\u0002\u00a2\u0006\u0002\u00100R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0010R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R$\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u001a8V@TX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u00061"}, d2={"Lorg/mapdb/IndexTreeList;", "E", "Ljava/util/AbstractList;", "store", "Lorg/mapdb/Store;", "serializer", "Lorg/mapdb/Serializer;", "map", "Lorg/eclipse/collections/api/map/primitive/MutableLongLongMap;", "counterRecid", "", "isThreadSafe", "", "(Lorg/mapdb/Store;Lorg/mapdb/Serializer;Lorg/eclipse/collections/api/map/primitive/MutableLongLongMap;JZ)V", "getCounterRecid", "()J", "()Z", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "getLock", "()Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "getMap", "()Lorg/eclipse/collections/api/map/primitive/MutableLongLongMap;", "getSerializer", "()Lorg/mapdb/Serializer;", "size", "", "getSize", "()I", "setSize", "(I)V", "getStore", "()Lorg/mapdb/Store;", "add", "element", "(Ljava/lang/Object;)Z", "", "index", "(ILjava/lang/Object;)V", "checkIndex", "clear", "get", "(I)Ljava/lang/Object;", "isEmpty", "iterator", "", "removeAt", "set", "(ILjava/lang/Object;)Ljava/lang/Object;", "mapdb"})
@SourceDebugExtension(value={"SMAP\nIndexTreeList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexTreeList.kt\norg/mapdb/IndexTreeList\n+ 2 Utils.kt\norg/mapdb/Utils\n*L\n1#1,164:1\n88#2,7:165\n88#2,7:172\n88#2,7:179\n88#2,7:186\n88#2,7:193\n99#2,7:200\n*S KotlinDebug\n*F\n+ 1 IndexTreeList.kt\norg/mapdb/IndexTreeList\n*L\n22#1:165,7\n31#1:172,7\n53#1:179,7\n62#1:186,7\n87#1:193,7\n107#1:200,7\n*E\n"})
public final class IndexTreeList<E>
extends AbstractList<E> {
    @NotNull
    private final Store store;
    @NotNull
    private final Serializer<E> serializer;
    @NotNull
    private final MutableLongLongMap map;
    private final long counterRecid;
    private final boolean isThreadSafe;
    @Nullable
    private final ReentrantReadWriteLock lock;

    public IndexTreeList(@NotNull Store store, @NotNull Serializer<E> serializer, @NotNull MutableLongLongMap map, long counterRecid, boolean isThreadSafe) {
        Intrinsics.checkNotNullParameter((Object)store, (String)"store");
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        this.store = store;
        this.serializer = serializer;
        this.map = map;
        this.counterRecid = counterRecid;
        this.isThreadSafe = isThreadSafe;
        this.lock = this.isThreadSafe ? new ReentrantReadWriteLock() : null;
    }

    @NotNull
    public final Store getStore() {
        return this.store;
    }

    @NotNull
    public final Serializer<E> getSerializer() {
        return this.serializer;
    }

    @NotNull
    public final MutableLongLongMap getMap() {
        return this.map;
    }

    public final long getCounterRecid() {
        return this.counterRecid;
    }

    public final boolean isThreadSafe() {
        return this.isThreadSafe;
    }

    @Nullable
    public final ReentrantReadWriteLock getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(@Nullable E element) {
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.lock;
        boolean $i$f$lockWrite = false;
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            boolean bl = false;
            int n = this.size();
            this.setSize(n + 1);
            int index = n;
            long recid2 = this.store.put(element, this.serializer);
            this.map.put(index, recid2);
            boolean bl2 = true;
            return bl2;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int index, @Nullable E element) {
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.lock;
        boolean $i$f$lockWrite = false;
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            boolean bl = false;
            this.checkIndex(index);
            int i = this.size() - 1;
            if (index <= i) {
                while (true) {
                    long recid2;
                    if ((recid2 = this.map.get(i)) != 0L) {
                        this.map.remove(i);
                        this.map.put(i + 1, recid2);
                    }
                    if (i == index) break;
                    --i;
                }
            }
            int n = this.size();
            this.setSize(n + 1);
            long recid3 = this.map.get(index);
            if (recid3 == 0L) {
                this.map.put(index, this.store.put(element, this.serializer));
            } else {
                this.store.update(recid3, element, this.serializer);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.lock;
        boolean $i$f$lockWrite = false;
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            boolean bl = false;
            this.setSize(0);
            this.map.forEachValue(arg_0 -> IndexTreeList.clear$lambda$3$lambda$2(this, arg_0));
            this.map.clear();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public E removeAt(int index) {
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.lock;
        boolean $i$f$lockWrite = false;
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            E e;
            boolean bl = false;
            this.checkIndex(index);
            long recid2 = this.map.get(index);
            if (recid2 == 0L) {
                e = null;
            } else {
                E ret = this.store.get(recid2, this.serializer);
                this.store.delete(recid2, this.serializer);
                this.map.remove(index);
                e = ret;
            }
            E ret = e;
            int n = this.size();
            for (int i = index + 1; i < n; ++i) {
                long recid3 = this.map.get(i);
                if (recid3 == 0L) continue;
                this.map.remove(i);
                this.map.put(i - 1, recid3);
            }
            int n2 = this.size();
            this.setSize(n2 + -1);
            E e2 = ret;
            return e2;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public E set(int index, @Nullable E element) {
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.lock;
        boolean $i$f$lockWrite = false;
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            boolean bl = false;
            this.checkIndex(index);
            long recid2 = this.map.get(index);
            if (recid2 == 0L) {
                this.map.put(index, this.store.put(element, this.serializer));
                E e = null;
                return e;
            }
            E ret = this.store.get(recid2, this.serializer);
            this.store.update(recid2, element, this.serializer);
            E e = ret;
            return e;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    public final void checkIndex(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public E get(int index) {
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.lock;
        boolean $i$f$lockRead = false;
        if (lock$iv != null) {
            lock$iv.readLock().lock();
        }
        try {
            boolean bl = false;
            this.checkIndex(index);
            long recid2 = this.map.get(index);
            if (recid2 == 0L) {
                E e = null;
                return e;
            }
            E e = this.store.get(recid2, this.serializer);
            return e;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.readLock().unlock();
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return new Iterator<E>(this){
            private volatile int index;
            @Nullable
            private volatile Integer indexToRemove;
            final /* synthetic */ IndexTreeList<E> this$0;
            {
                this.this$0 = $receiver;
            }

            public final int getIndex() {
                return this.index;
            }

            public final void setIndex(int n) {
                this.index = n;
            }

            @Nullable
            public final Integer getIndexToRemove() {
                return this.indexToRemove;
            }

            public final void setIndexToRemove(@Nullable Integer n) {
                this.indexToRemove = n;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public boolean hasNext() {
                void lock$iv;
                Utils utils = Utils.INSTANCE;
                ReadWriteLock readWriteLock = this.this$0.getLock();
                IndexTreeList<E> indexTreeList = this.this$0;
                boolean $i$f$lockRead = false;
                if (lock$iv != null) {
                    lock$iv.readLock().lock();
                }
                try {
                    boolean bl = false;
                    boolean bl2 = this.index < indexTreeList.size();
                    return bl2;
                }
                finally {
                    if (lock$iv != null) {
                        lock$iv.readLock().unlock();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @Nullable
            public E next() {
                void lock$iv;
                Utils utils = Utils.INSTANCE;
                ReadWriteLock readWriteLock = this.this$0.getLock();
                IndexTreeList<E> indexTreeList = this.this$0;
                boolean $i$f$lockRead = false;
                if (lock$iv != null) {
                    lock$iv.readLock().lock();
                }
                try {
                    boolean bl = false;
                    if (this.index >= indexTreeList.size()) {
                        throw new NoSuchElementException();
                    }
                    this.indexToRemove = this.index;
                    E ret = indexTreeList.get(this.index);
                    int n = this.index;
                    this.index = n + 1;
                    E e = ret;
                    return e;
                }
                finally {
                    if (lock$iv != null) {
                        lock$iv.readLock().unlock();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void remove() {
                void lock$iv;
                Utils utils = Utils.INSTANCE;
                ReadWriteLock readWriteLock = this.this$0.getLock();
                IndexTreeList<E> indexTreeList = this.this$0;
                boolean $i$f$lockWrite = false;
                if (lock$iv != null) {
                    lock$iv.writeLock().lock();
                }
                try {
                    boolean bl = false;
                    Integer n = this.indexToRemove;
                    if (n == null) {
                        throw new IllegalStateException();
                    }
                    indexTreeList.remove(n);
                    int n2 = this.index;
                    this.index = n2 + -1;
                    this.indexToRemove = null;
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    if (lock$iv != null) {
                        lock$iv.writeLock().unlock();
                    }
                }
            }
        };
    }

    public int getSize() {
        GroupSerializer<Long> groupSerializer = Serializer.LONG_PACKED;
        Intrinsics.checkNotNullExpressionValue(groupSerializer, (String)"LONG_PACKED");
        Object r = this.store.get(this.counterRecid, (Serializer)groupSerializer);
        Intrinsics.checkNotNull(r);
        return (int)((Number)r).longValue();
    }

    protected void setSize(int size) {
        Long l = size;
        GroupSerializer<Long> groupSerializer = Serializer.LONG_PACKED;
        Intrinsics.checkNotNullExpressionValue(groupSerializer, (String)"LONG_PACKED");
        this.store.update(this.counterRecid, l, (Serializer)groupSerializer);
    }

    private static final void clear$lambda$3$lambda$2(IndexTreeList this$0, long recid2) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.store.delete(recid2, this$0.serializer);
    }
}

