/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.utility.internal.primitive;

import java.util.Collection;
import org.eclipse.collections.api.block.function.primitive.CharToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.iterator.CharIterator;

public final class CharIteratorIterate {
    private CharIteratorIterate() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static void forEach(CharIterator iterator2, CharProcedure procedure) {
        while (iterator2.hasNext()) {
            procedure.value(iterator2.next());
        }
    }

    public static <R extends MutableCharCollection> R select(CharIterator iterator2, CharPredicate predicate, R targetCollection) {
        while (iterator2.hasNext()) {
            char item = iterator2.next();
            if (!predicate.accept(item)) continue;
            targetCollection.add(item);
        }
        return targetCollection;
    }

    public static <R extends MutableCharCollection> R reject(CharIterator iterator2, CharPredicate predicate, R targetCollection) {
        while (iterator2.hasNext()) {
            char item = iterator2.next();
            if (predicate.accept(item)) continue;
            targetCollection.add(item);
        }
        return targetCollection;
    }

    public static <V, R extends Collection<V>> R collect(CharIterator iterator2, CharToObjectFunction<? extends V> function, R targetCollection) {
        while (iterator2.hasNext()) {
            char item = iterator2.next();
            targetCollection.add(function.valueOf(item));
        }
        return targetCollection;
    }

    public static char detectIfNone(CharIterator iterator2, CharPredicate predicate, char ifNone) {
        while (iterator2.hasNext()) {
            char item = iterator2.next();
            if (!predicate.accept(item)) continue;
            return item;
        }
        return ifNone;
    }

    public static int count(CharIterator iterator2, CharPredicate predicate) {
        int count = 0;
        while (iterator2.hasNext()) {
            if (!predicate.accept(iterator2.next())) continue;
            ++count;
        }
        return count;
    }

    public static boolean anySatisfy(CharIterator iterator2, CharPredicate predicate) {
        while (iterator2.hasNext()) {
            if (!predicate.accept(iterator2.next())) continue;
            return true;
        }
        return false;
    }

    public static boolean allSatisfy(CharIterator iterator2, CharPredicate predicate) {
        while (iterator2.hasNext()) {
            if (predicate.accept(iterator2.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean noneSatisfy(CharIterator iterator2, CharPredicate predicate) {
        while (iterator2.hasNext()) {
            if (!predicate.accept(iterator2.next())) continue;
            return false;
        }
        return true;
    }

    public static <T> T injectInto(CharIterator iterator2, T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function) {
        T result = injectedValue;
        while (iterator2.hasNext()) {
            result = function.valueOf(result, iterator2.next());
        }
        return result;
    }

    public static long sum(CharIterator iterator2) {
        long sum = 0L;
        while (iterator2.hasNext()) {
            sum += (long)iterator2.next();
        }
        return sum;
    }

    public static char max(CharIterator iterator2) {
        char max = iterator2.next();
        while (iterator2.hasNext()) {
            char next = iterator2.next();
            if (max >= next) continue;
            max = next;
        }
        return max;
    }

    public static char min(CharIterator iterator2) {
        char min = iterator2.next();
        while (iterator2.hasNext()) {
            char next = iterator2.next();
            if (next >= min) continue;
            min = next;
        }
        return min;
    }
}

