/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.multimap;

import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.Bag;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.factory.Bags;
import org.eclipse.collections.api.map.MapIterable;
import org.eclipse.collections.api.multimap.Multimap;
import org.eclipse.collections.api.multimap.MutableMultimap;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.UnmodifiableRichIterable;
import org.eclipse.collections.impl.block.factory.Functions;
import org.eclipse.collections.impl.tuple.Tuples;
import org.eclipse.collections.impl.utility.Iterate;

public abstract class AbstractMultimap<K, V, C extends RichIterable<V>>
implements Multimap<K, V> {
    protected abstract MapIterable<K, C> getMap();

    protected abstract C createCollection();

    protected Function<AbstractMultimap<K, V, C>, C> createCollectionBlock() {
        return AbstractMultimap::createCollection;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getMap().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getMap().anySatisfy(collection -> collection.contains(value));
    }

    @Override
    public boolean containsKeyAndValue(Object key, Object value) {
        RichIterable collection = (RichIterable)this.getMap().get(key);
        return collection != null && collection.contains(value);
    }

    @Override
    public RichIterable<K> keysView() {
        return this.getMap().keysView();
    }

    @Override
    public RichIterable<RichIterable<V>> multiValuesView() {
        return this.getMap().valuesView().collect(UnmodifiableRichIterable::of);
    }

    @Override
    public Bag<K> keyBag() {
        MutableBag bag = Bags.mutable.empty();
        this.getMap().forEachKeyValue((key, value) -> bag.addOccurrences(key, value.size()));
        return bag;
    }

    @Override
    public RichIterable<V> valuesView() {
        return this.getMap().valuesView().flatCollect(Functions.identity());
    }

    @Override
    public RichIterable<Pair<K, RichIterable<V>>> keyMultiValuePairsView() {
        return this.getMap().keyValuesView().collect(pair -> Tuples.pair(pair.getOne(), UnmodifiableRichIterable.of((RichIterable)pair.getTwo())));
    }

    @Override
    public RichIterable<Pair<K, V>> keyValuePairsView() {
        return this.keyMultiValuePairsView().flatCollect(pair -> ((RichIterable)pair.getTwo()).collect(new KeyValuePairFunction(pair.getOne())));
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Multimap) {
            Multimap that = (Multimap)object;
            return this.getMap().equals(that.toMap());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getMap().hashCode();
    }

    public String toString() {
        return this.getMap().toString();
    }

    @Override
    public boolean notEmpty() {
        return !this.isEmpty();
    }

    @Override
    public void forEachValue(Procedure<? super V> procedure) {
        this.getMap().forEachValue(collection -> collection.forEach(procedure));
    }

    @Override
    public void forEachKey(Procedure<? super K> procedure) {
        this.getMap().forEachKey(procedure);
    }

    @Override
    public void forEachKeyValue(Procedure2<? super K, ? super V> procedure) {
        Procedure2<Object, Object> innerProcedure = (value, key) -> procedure.value((Object)key, (Object)value);
        this.getMap().forEachKeyValue((key, collection) -> collection.forEachWith(innerProcedure, key));
    }

    @Override
    public void forEachKeyMultiValues(Procedure2<? super K, ? super Iterable<V>> procedure) {
        this.getMap().forEachKeyValue(procedure);
    }

    @Override
    public <R extends MutableMultimap<K, V>> R selectKeysValues(Predicate2<? super K, ? super V> predicate, R target) {
        this.getMap().forEachKeyValue((key, collection) -> {
            RichIterable<Object> selectedValues = collection.select(value -> predicate.accept((Object)key, (Object)value));
            target.putAll(key, selectedValues);
        });
        return target;
    }

    @Override
    public <R extends MutableMultimap<K, V>> R rejectKeysValues(Predicate2<? super K, ? super V> predicate, R target) {
        this.getMap().forEachKeyValue((key, collection) -> {
            RichIterable<Object> selectedValues = collection.reject(value -> predicate.accept((Object)key, (Object)value));
            target.putAll(key, selectedValues);
        });
        return target;
    }

    @Override
    public <R extends MutableMultimap<K, V>> R selectKeysMultiValues(Predicate2<? super K, ? super Iterable<V>> predicate, R target) {
        this.forEachKeyMultiValues((key, collection) -> {
            if (predicate.accept((Object)key, (Object)collection)) {
                target.putAll(key, collection);
            }
        });
        return target;
    }

    @Override
    public <R extends MutableMultimap<K, V>> R rejectKeysMultiValues(Predicate2<? super K, ? super Iterable<V>> predicate, R target) {
        this.forEachKeyMultiValues((key, collection) -> {
            if (!predicate.accept((Object)key, (Object)collection)) {
                target.putAll(key, collection);
            }
        });
        return target;
    }

    @Override
    public <K2, V2, R extends MutableMultimap<K2, V2>> R collectKeysValues(Function2<? super K, ? super V, Pair<K2, V2>> function, R target) {
        this.getMap().forEachKeyValue((key, collection) -> collection.each(value -> target.add((Pair)function.value((Object)key, (Object)value))));
        return target;
    }

    @Override
    public <K2, V2, R extends MutableMultimap<K2, V2>> R collectKeyMultiValues(Function<? super K, ? extends K2> keyFunction, Function<? super V, ? extends V2> valueFunction, R target) {
        this.forEachKeyMultiValues((key, values2) -> target.putAll(keyFunction.valueOf((Object)key), Iterate.collect(values2, valueFunction)));
        return target;
    }

    @Override
    public <V2, R extends MutableMultimap<K, V2>> R collectValues(Function<? super V, ? extends V2> function, R target) {
        this.getMap().forEachKeyValue((key, collection) -> target.putAll(key, collection.collect(function)));
        return target;
    }

    private static final class KeyValuePairFunction<V, K>
    implements Function<V, Pair<K, V>> {
        private static final long serialVersionUID = 1L;
        private final K key;

        private KeyValuePairFunction(K key) {
            this.key = key;
        }

        @Override
        public Pair<K, V> valueOf(V value) {
            return Tuples.pair(this.key, value);
        }
    }
}

