/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.primitive;

import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.block.predicate.primitive.ShortPredicate;
import org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import org.eclipse.collections.api.iterator.ShortIterator;
import org.eclipse.collections.impl.lazy.primitive.AbstractLazyShortIterable;

public class TapShortIterable
extends AbstractLazyShortIterable {
    private final ShortIterable adapted;
    private final ShortProcedure procedure;

    public TapShortIterable(ShortIterable delegate, ShortProcedure procedure) {
        this.adapted = delegate;
        this.procedure = procedure;
    }

    @Override
    public void each(ShortProcedure procedure) {
        this.adapted.forEach(each -> {
            this.procedure.value(each);
            procedure.value(each);
        });
    }

    @Override
    public boolean anySatisfy(ShortPredicate predicate) {
        return this.adapted.anySatisfy(each -> {
            this.procedure.value(each);
            return predicate.accept(each);
        });
    }

    @Override
    public boolean allSatisfy(ShortPredicate predicate) {
        return this.adapted.allSatisfy(each -> {
            this.procedure.value(each);
            return predicate.accept(each);
        });
    }

    @Override
    public boolean noneSatisfy(ShortPredicate predicate) {
        return this.adapted.noneSatisfy(each -> {
            this.procedure.value(each);
            return predicate.accept(each);
        });
    }

    @Override
    public short detectIfNone(ShortPredicate predicate, short ifNone) {
        return this.adapted.detectIfNone(each -> {
            this.procedure.value(each);
            return predicate.accept(each);
        }, ifNone);
    }

    @Override
    public ShortIterator shortIterator() {
        return new TapShortIterator(this.adapted, this.procedure);
    }

    public static class TapShortIterator
    implements ShortIterator {
        private final ShortIterator iterator;
        private final ShortProcedure procedure;

        public TapShortIterator(ShortIterable iterable, ShortProcedure procedure) {
            this(iterable.shortIterator(), procedure);
        }

        public TapShortIterator(ShortIterator iterator2, ShortProcedure procedure) {
            this.iterator = iterator2;
            this.procedure = procedure;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public short next() {
            short next = this.iterator.next();
            this.procedure.value(next);
            return next;
        }
    }
}

