/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.eclipse.collections.api.LazyShortIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableShortBag;
import org.eclipse.collections.api.bag.primitive.MutableShortBag;
import org.eclipse.collections.api.bag.primitive.ShortBag;
import org.eclipse.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.predicate.primitive.ShortPredicate;
import org.eclipse.collections.api.block.procedure.primitive.ShortIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.iterator.ShortIterator;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.MutableShortList;
import org.eclipse.collections.api.set.primitive.ImmutableShortSet;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.api.tuple.primitive.ShortIntPair;
import org.eclipse.collections.impl.bag.mutable.primitive.ShortHashBag;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedShortIntProcedure;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.ShortBags;
import org.eclipse.collections.impl.factory.primitive.ShortSets;
import org.eclipse.collections.impl.iterator.UnmodifiableShortIterator;

final class ImmutableShortHashBag
implements ImmutableShortBag,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableShortBag delegate;

    private ImmutableShortHashBag(short[] newElements) {
        this.checkOptimizedSize(newElements.length);
        this.delegate = ShortHashBag.newBagWith(newElements);
    }

    private void checkOptimizedSize(int length) {
        if (length <= 1) {
            throw new IllegalArgumentException("Use ShortBags.immutable.with() to instantiate an optimized collection");
        }
    }

    public static ImmutableShortHashBag newBagWith(short ... elements) {
        return new ImmutableShortHashBag(elements);
    }

    @Override
    public ImmutableShortBag newWith(short element) {
        return ShortHashBag.newBag(this.delegate).with(element).toImmutable();
    }

    @Override
    public ImmutableShortBag newWithout(short element) {
        ShortHashBag hashBag = ShortHashBag.newBag(this.delegate);
        hashBag.remove(element);
        return hashBag.toImmutable();
    }

    @Override
    public ImmutableShortBag newWithAll(ShortIterable elements) {
        ShortHashBag bag = ShortHashBag.newBag(this.delegate);
        bag.addAll(elements);
        return bag.toImmutable();
    }

    @Override
    public ImmutableShortBag newWithoutAll(ShortIterable elements) {
        ShortHashBag bag = ShortHashBag.newBag(this.delegate);
        bag.removeAll(elements);
        return bag.toImmutable();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    @Override
    public boolean contains(short value) {
        return this.delegate.contains(value);
    }

    @Override
    public boolean containsAll(ShortIterable source) {
        return this.delegate.containsAll(source);
    }

    @Override
    public boolean containsAll(short ... elements) {
        return this.delegate.containsAll(elements);
    }

    @Override
    public void forEach(ShortProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(ShortProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    @Override
    public ImmutableShortBag select(ShortPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    @Override
    public ImmutableShortBag selectByOccurrences(IntPredicate predicate) {
        return this.delegate.selectByOccurrences(predicate).toImmutable();
    }

    @Override
    public ImmutableShortSet selectUnique() {
        MutableShortSet result = ShortSets.mutable.empty();
        this.forEachWithOccurrences((each, occurrences) -> {
            if (occurrences == 1) {
                result.add(each);
            }
        });
        return result.toImmutable();
    }

    @Override
    public ImmutableList<ShortIntPair> topOccurrences(int count) {
        return this.delegate.topOccurrences(count).toImmutable();
    }

    @Override
    public ImmutableList<ShortIntPair> bottomOccurrences(int count) {
        return this.delegate.bottomOccurrences(count).toImmutable();
    }

    @Override
    public ImmutableShortBag reject(ShortPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    @Override
    public <V> ImmutableBag<V> collect(ShortToObjectFunction<? extends V> function) {
        MutableCollection bag = this.delegate.collect((ShortToObjectFunction)function);
        return bag.toImmutable();
    }

    @Override
    public MutableShortList toList() {
        return this.delegate.toList();
    }

    @Override
    public int sizeDistinct() {
        return this.delegate.sizeDistinct();
    }

    @Override
    public int occurrencesOf(short item) {
        return this.delegate.occurrencesOf(item);
    }

    @Override
    public void forEachWithOccurrences(ShortIntProcedure shortIntProcedure) {
        this.delegate.forEachWithOccurrences(shortIntProcedure);
    }

    @Override
    public short detectIfNone(ShortPredicate predicate, short ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    @Override
    public int count(ShortPredicate predicate) {
        return this.delegate.count(predicate);
    }

    @Override
    public boolean anySatisfy(ShortPredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    @Override
    public long sum() {
        return this.delegate.sum();
    }

    @Override
    public short min() {
        return this.delegate.min();
    }

    @Override
    public short max() {
        return this.delegate.max();
    }

    @Override
    public short maxIfEmpty(short defaultValue) {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    @Override
    public short minIfEmpty(short defaultValue) {
        return this.delegate.minIfEmpty(defaultValue);
    }

    @Override
    public double average() {
        return this.delegate.average();
    }

    @Override
    public double median() {
        return this.delegate.median();
    }

    @Override
    public short[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    @Override
    public MutableShortList toSortedList() {
        return this.delegate.toSortedList();
    }

    @Override
    public boolean noneSatisfy(ShortPredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    @Override
    public boolean allSatisfy(ShortPredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function) {
        return this.delegate.injectInto(injectedValue, function);
    }

    @Override
    public RichIterable<ShortIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList result = Lists.mutable.empty();
        if (this.notEmpty()) {
            if (this.size() <= size) {
                result.add(this);
            } else {
                ShortIterator iterator2 = this.shortIterator();
                while (iterator2.hasNext()) {
                    MutableShortBag batch = ShortBags.mutable.empty();
                    for (int i = 0; i < size && iterator2.hasNext(); ++i) {
                        batch.add(iterator2.next());
                    }
                    result.add(batch.toImmutable());
                }
            }
        }
        return result.toImmutable();
    }

    @Override
    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public MutableShortSet toSet() {
        return this.delegate.toSet();
    }

    @Override
    public MutableShortBag toBag() {
        return this.delegate.toBag();
    }

    @Override
    public ImmutableShortBag toImmutable() {
        return this;
    }

    @Override
    public LazyShortIterable asLazy() {
        return this.delegate.asLazy();
    }

    @Override
    public short[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public short[] toArray(short[] target) {
        return this.delegate.toArray(target);
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public String makeString() {
        return this.delegate.makeString();
    }

    @Override
    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    @Override
    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    @Override
    public ShortIterator shortIterator() {
        return new UnmodifiableShortIterator(this.delegate.shortIterator());
    }

    private Object writeReplace() {
        return new ImmutableShortBagSerializationProxy(this);
    }

    protected static class ImmutableShortBagSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private ShortBag bag;

        public ImmutableShortBagSerializationProxy() {
        }

        protected ImmutableShortBagSerializationProxy(ShortBag bag) {
            this.bag = bag;
        }

        @Override
        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.bag.sizeDistinct());
            try {
                this.bag.forEachWithOccurrences(new CheckedShortIntProcedure(){

                    @Override
                    public void safeValue(short item, int count) throws IOException {
                        out.writeShort(item);
                        out.writeInt(count);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            ShortHashBag deserializedBag = new ShortHashBag();
            for (int i = 0; i < size; ++i) {
                deserializedBag.addOccurrences(in.readShort(), in.readInt());
            }
            this.bag = deserializedBag;
        }

        protected Object readResolve() {
            return this.bag.toImmutable();
        }
    }
}

