/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.httpproxy;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.httpproxy.ProxyInterceptor;
import io.vertx.httpproxy.ProxyOptions;
import io.vertx.httpproxy.impl.ReverseProxy;
import java.util.function.BiFunction;
import java.util.function.Function;

@VertxGen
public interface HttpProxy
extends Handler<HttpServerRequest> {
    public static HttpProxy reverseProxy(HttpClient client) {
        return new ReverseProxy(new ProxyOptions(), client);
    }

    public static HttpProxy reverseProxy(ProxyOptions options, HttpClient client) {
        return new ReverseProxy(options, client);
    }

    @Fluent
    default public HttpProxy origin(SocketAddress address) {
        return this.originSelector(req -> Future.succeededFuture((Object)address));
    }

    @Fluent
    default public HttpProxy origin(int port, String host) {
        return this.origin(SocketAddress.inetSocketAddress((int)port, (String)host));
    }

    @Fluent
    default public HttpProxy originSelector(Function<HttpServerRequest, Future<SocketAddress>> selector) {
        return this.originRequestProvider((req, client) -> ((Future)selector.apply((HttpServerRequest)req)).flatMap(server -> client.request(new RequestOptions().setServer(server))));
    }

    @GenIgnore
    @Fluent
    public HttpProxy originRequestProvider(BiFunction<HttpServerRequest, HttpClient, Future<HttpClientRequest>> var1);

    @Fluent
    public HttpProxy addInterceptor(ProxyInterceptor var1);

    public void handle(HttpServerRequest var1);
}

