/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.path.impl;

import com.itextpdf.kernel.geom.AffineTransform;
import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.styledxmlparser.css.util.CssDimensionParsingUtils;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.renderers.impl.PathSvgNodeRenderer;
import com.itextpdf.svg.renderers.path.IPathShape;
import com.itextpdf.svg.renderers.path.impl.DefaultOperatorConverter;
import com.itextpdf.svg.renderers.path.impl.IOperatorConverter;
import com.itextpdf.svg.utils.SvgCssUtils;
import java.util.Map;

public abstract class AbstractPathShape
implements IPathShape {
    private PathSvgNodeRenderer parent;
    private AffineTransform transform = null;
    protected Map<String, String> properties;
    protected boolean relative;
    protected final IOperatorConverter copier;
    protected String[] coordinates;
    protected SvgDrawContext context;

    public AbstractPathShape() {
        this(false);
    }

    public AbstractPathShape(boolean relative) {
        this(relative, new DefaultOperatorConverter());
    }

    public AbstractPathShape(boolean relative, IOperatorConverter copier) {
        this.relative = relative;
        this.copier = copier;
    }

    @Override
    public boolean isRelative() {
        return this.relative;
    }

    protected Point createPoint(String coordX, String coordY) {
        return new Point(CssDimensionParsingUtils.parseDouble(coordX), CssDimensionParsingUtils.parseDouble(coordY));
    }

    @Override
    public Point getEndingPoint() {
        return this.createPoint(this.coordinates[this.coordinates.length - 2], this.coordinates[this.coordinates.length - 1]);
    }

    @Override
    public Rectangle getPathShapeRectangle(Point lastPoint) {
        return new Rectangle((float)CssUtils.convertPxToPts(this.getEndingPoint().getX()), (float)CssUtils.convertPxToPts(this.getEndingPoint().getY()), 0.0f, 0.0f);
    }

    @Override
    public void draw(PdfCanvas canvas) {
        this.draw();
    }

    public abstract void draw();

    public void setParent(PathSvgNodeRenderer parent) {
        this.parent = parent;
    }

    public void setContext(SvgDrawContext context) {
        this.context = context;
    }

    public void setTransform(AffineTransform transform) {
        this.transform = transform;
    }

    protected float parseHorizontalLength(String length) {
        return SvgCssUtils.parseAbsoluteHorizontalLength(this.parent, length, 0.0f, this.context);
    }

    protected float parseVerticalLength(String length) {
        return SvgCssUtils.parseAbsoluteVerticalLength(this.parent, length, 0.0f, this.context);
    }

    void applyTransform(double[] points) {
        if (this.transform != null) {
            this.transform.transform(points, 0, points, 0, points.length / 2);
        }
    }
}

