/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.css;

import com.itextpdf.styledxmlparser.css.util.CssDimensionParsingUtils;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.utils.SvgCoordinateUtils;
import com.itextpdf.svg.utils.SvgCssUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class SvgStrokeParameterConverter {
    private SvgStrokeParameterConverter() {
    }

    public static PdfLineDashParameters convertStrokeDashParameters(String strokeDashArray, String strokeDashOffset, float fontSize, SvgDrawContext context) {
        if (strokeDashArray != null && !"none".equalsIgnoreCase(strokeDashArray)) {
            float rem = context.getCssContext().getRootFontSize();
            float percentBaseValue = SvgCoordinateUtils.calculateNormalizedDiagonalLength(context);
            List<String> dashArray = SvgCssUtils.splitValueList(strokeDashArray);
            if (dashArray.size() > 0) {
                if (dashArray.size() % 2 == 1) {
                    dashArray.addAll(new ArrayList<String>(dashArray));
                }
                float[] dashArrayFloat = new float[dashArray.size()];
                for (int i = 0; i < dashArray.size(); ++i) {
                    dashArrayFloat[i] = CssDimensionParsingUtils.parseLength(dashArray.get(i), percentBaseValue, 1.0f, fontSize, rem);
                }
                float dashPhase = 0.0f;
                if (strokeDashOffset != null && !strokeDashOffset.isEmpty() && !"none".equalsIgnoreCase(strokeDashOffset)) {
                    dashPhase = CssDimensionParsingUtils.parseLength(strokeDashOffset, percentBaseValue, 1.0f, fontSize, rem);
                }
                return new PdfLineDashParameters(dashArrayFloat, dashPhase);
            }
        }
        return null;
    }

    public static class PdfLineDashParameters {
        private final float[] dashArray;
        private final float dashPhase;

        public PdfLineDashParameters(float[] dashArray, float dashPhase) {
            this.dashArray = dashArray;
            this.dashPhase = dashPhase;
        }

        public float[] getDashArray() {
            return this.dashArray;
        }

        public float getDashPhase() {
            return this.dashPhase;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PdfLineDashParameters that = (PdfLineDashParameters)o;
            if (Float.compare(that.dashPhase, this.dashPhase) != 0) {
                return false;
            }
            return Arrays.equals(this.dashArray, that.dashArray);
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.dashArray);
            result = 31 * result + Float.floatToIntBits(this.dashPhase);
            return result;
        }
    }
}

