/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.css.resolve.shorthand.impl;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.styledxmlparser.css.CssDeclaration;
import com.itextpdf.styledxmlparser.css.resolve.CssDefaults;
import com.itextpdf.styledxmlparser.css.resolve.shorthand.IShorthandResolver;
import com.itextpdf.styledxmlparser.css.util.CssTypesValidationUtils;
import com.itextpdf.styledxmlparser.css.validate.CssDeclarationValidationMaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlexFlowShorthandResolver
implements IShorthandResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlexFlowShorthandResolver.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<CssDeclaration> resolveShorthand(String shorthandExpression) {
        if (CssTypesValidationUtils.isInitialOrInheritOrUnset(shorthandExpression = shorthandExpression.trim())) {
            return Arrays.asList(new CssDeclaration("flex-direction", shorthandExpression), new CssDeclaration("flex-wrap", shorthandExpression));
        }
        if (CssTypesValidationUtils.containsInitialOrInheritOrUnset(shorthandExpression)) {
            return FlexFlowShorthandResolver.handleExpressionError("Invalid css property declaration: {0}", "flex-flow", shorthandExpression);
        }
        if (shorthandExpression.isEmpty()) {
            return FlexFlowShorthandResolver.handleExpressionError("{0} shorthand property cannot be empty.", "flex-flow", shorthandExpression);
        }
        String[] flexFlowProps = shorthandExpression.split(" ");
        ArrayList<CssDeclaration> resolvedProperties = new ArrayList<CssDeclaration>();
        if (1 == flexFlowProps.length) {
            CssDeclaration flexDirectionDeclaration = new CssDeclaration("flex-direction", flexFlowProps[0]);
            if (CssDeclarationValidationMaster.checkDeclaration(flexDirectionDeclaration)) {
                resolvedProperties.add(flexDirectionDeclaration);
            } else {
                CssDeclaration flexWrapDeclaration = new CssDeclaration("flex-wrap", flexFlowProps[0]);
                if (!CssDeclarationValidationMaster.checkDeclaration(flexWrapDeclaration)) return FlexFlowShorthandResolver.handleExpressionError("Invalid css property declaration: {0}", "flex-flow", shorthandExpression);
                resolvedProperties.add(flexWrapDeclaration);
            }
        } else {
            if (2 != flexFlowProps.length) return FlexFlowShorthandResolver.handleExpressionError("Invalid css property declaration: {0}", "flex-flow", shorthandExpression);
            CssDeclaration flexDirectionDeclaration = new CssDeclaration("flex-direction", flexFlowProps[0]);
            CssDeclaration flexWrapDeclaration = new CssDeclaration("flex-wrap", flexFlowProps[1]);
            if (CssDeclarationValidationMaster.checkDeclaration(flexDirectionDeclaration)) {
                resolvedProperties.add(flexDirectionDeclaration);
            } else {
                flexDirectionDeclaration = new CssDeclaration("flex-direction", flexFlowProps[1]);
                flexWrapDeclaration = new CssDeclaration("flex-wrap", flexFlowProps[0]);
                if (!CssDeclarationValidationMaster.checkDeclaration(flexDirectionDeclaration)) return FlexFlowShorthandResolver.handleExpressionError("Invalid css property declaration: {0}", "flex-direction", shorthandExpression);
                resolvedProperties.add(flexDirectionDeclaration);
            }
            if (!CssDeclarationValidationMaster.checkDeclaration(flexWrapDeclaration)) return FlexFlowShorthandResolver.handleExpressionError("Invalid css property declaration: {0}", "flex-wrap", shorthandExpression);
            resolvedProperties.add(flexWrapDeclaration);
        }
        this.fillUnresolvedPropertiesWithDefaultValues(resolvedProperties);
        return resolvedProperties;
    }

    private static List<CssDeclaration> handleExpressionError(String logMessage, String attribute, String shorthandExpression) {
        LOGGER.warn(MessageFormatUtil.format(logMessage, attribute, shorthandExpression));
        return Collections.emptyList();
    }

    private void fillUnresolvedPropertiesWithDefaultValues(List<CssDeclaration> resolvedProperties) {
        if (!resolvedProperties.stream().anyMatch(property -> property.getProperty().equals("flex-direction"))) {
            resolvedProperties.add(new CssDeclaration("flex-direction", CssDefaults.getDefaultValue("flex-direction")));
        }
        if (!resolvedProperties.stream().anyMatch(property -> property.getProperty().equals("flex-wrap"))) {
            resolvedProperties.add(new CssDeclaration("flex-wrap", CssDefaults.getDefaultValue("flex-wrap")));
        }
    }
}

