/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.css.resolve.shorthand.impl;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.styledxmlparser.css.CssDeclaration;
import com.itextpdf.styledxmlparser.css.resolve.shorthand.IShorthandResolver;
import com.itextpdf.styledxmlparser.css.util.CssTypesValidationUtils;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnsShorthandResolver
implements IShorthandResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ColumnsShorthandResolver.class);

    @Override
    public List<CssDeclaration> resolveShorthand(String shorthandExpression) {
        if (CssTypesValidationUtils.isInitialOrInheritOrUnset(shorthandExpression = shorthandExpression.trim())) {
            return Arrays.asList(new CssDeclaration("column-count", shorthandExpression), new CssDeclaration("column-width", shorthandExpression));
        }
        if (CssTypesValidationUtils.containsInitialOrInheritOrUnset(shorthandExpression)) {
            return ColumnsShorthandResolver.handleExpressionError("Invalid css property declaration: {0}", "columns", shorthandExpression);
        }
        if (shorthandExpression.isEmpty()) {
            return ColumnsShorthandResolver.handleExpressionError("{0} shorthand property cannot be empty.", "columns", shorthandExpression);
        }
        List<String> properties = CssUtils.extractShorthandProperties(shorthandExpression).get(0);
        if (properties.size() > 2) {
            return ColumnsShorthandResolver.handleExpressionError("Invalid css property declaration: {0}", "columns", shorthandExpression);
        }
        ArrayList<CssDeclaration> result = new ArrayList<CssDeclaration>(2);
        for (String property : properties) {
            CssDeclaration declaration = ColumnsShorthandResolver.processProperty(property);
            if (declaration != null) {
                result.add(declaration);
            }
            if (declaration != null || "auto".equals(property)) continue;
            return ColumnsShorthandResolver.handleExpressionError("Invalid css property declaration: {0}", "columns", shorthandExpression);
        }
        if (result.size() == 2 && ((CssDeclaration)result.get(0)).getProperty().equals(((CssDeclaration)result.get(1)).getProperty())) {
            return ColumnsShorthandResolver.handleExpressionError("Invalid css property declaration: {0}", "columns", shorthandExpression);
        }
        return result;
    }

    private static CssDeclaration processProperty(String value) {
        if (CssTypesValidationUtils.isMetricValue(value) || CssTypesValidationUtils.isRelativeValue(value)) {
            return new CssDeclaration("column-width", value);
        }
        if (CssTypesValidationUtils.isNumber(value)) {
            return new CssDeclaration("column-count", value);
        }
        return null;
    }

    private static List<CssDeclaration> handleExpressionError(String logMessage, String attribute, String shorthandExpression) {
        LOGGER.warn(MessageFormatUtil.format(logMessage, attribute, shorthandExpression));
        return Collections.emptyList();
    }
}

