/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.extensions;

import com.itextpdf.bouncycastleconnector.BouncyCastleFactoryCreator;
import com.itextpdf.commons.bouncycastle.IBouncyCastleFactory;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.io.util.EnumUtil;
import com.itextpdf.signatures.validation.extensions.CertificateExtension;
import com.itextpdf.signatures.validation.extensions.KeyUsage;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;

public class KeyUsageExtension
extends CertificateExtension {
    private static final IBouncyCastleFactory FACTORY = BouncyCastleFactoryCreator.getFactory();
    public static final String EXPECTED_VALUE = "Key usage expected: ({0})";
    public static final String ACTUAL_VALUE = "\nbut found {0}";
    public static final String MISSING_VALUE = "\nbut nothing found.";
    private final int keyUsage;
    private final boolean resultOnMissingExtension;
    private String messagePreAmble;
    private String message;

    public KeyUsageExtension(int keyUsage) {
        this(keyUsage, false);
    }

    public KeyUsageExtension(int keyUsage, boolean resultOnMissingExtension) {
        super("2.5.29.15", FACTORY.createKeyUsage(keyUsage).toASN1Primitive());
        this.keyUsage = keyUsage;
        this.resultOnMissingExtension = resultOnMissingExtension;
        this.message = this.messagePreAmble = MessageFormatUtil.format(EXPECTED_VALUE, KeyUsageExtension.convertKeyUsageMaskToString(keyUsage));
    }

    public KeyUsageExtension(List<KeyUsage> keyUsages) {
        this(keyUsages, false);
    }

    public KeyUsageExtension(List<KeyUsage> keyUsages, boolean resultOnMissingExtension) {
        this(KeyUsageExtension.convertKeyUsageSetToInt(keyUsages), resultOnMissingExtension);
    }

    public KeyUsageExtension(KeyUsage keyUsageValue) {
        this(Collections.singletonList(keyUsageValue), false);
    }

    public KeyUsageExtension(KeyUsage keyUsageValue, boolean resultOnMissingExtension) {
        this(Collections.singletonList(keyUsageValue), resultOnMissingExtension);
    }

    @Override
    public boolean existsInCertificate(X509Certificate certificate) {
        boolean[] providedKeyUsageFlags = certificate.getKeyUsage();
        if (providedKeyUsageFlags == null) {
            this.message = this.messagePreAmble + MISSING_VALUE;
            return this.resultOnMissingExtension;
        }
        int bitmap = 0;
        for (int i = 0; i < providedKeyUsageFlags.length - 1; ++i) {
            if (!providedKeyUsageFlags[i]) continue;
            bitmap += 1 << 8 - i - 1;
        }
        if (providedKeyUsageFlags[8]) {
            bitmap += 32768;
        }
        if ((bitmap & this.keyUsage) != this.keyUsage) {
            this.message = this.messagePreAmble + MessageFormatUtil.format(ACTUAL_VALUE, KeyUsageExtension.convertKeyUsageMaskToString(bitmap));
            return false;
        }
        return true;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    private static String convertKeyUsageMaskToString(int keyUsageMask) {
        StringBuilder result = new StringBuilder();
        String separator = "";
        for (KeyUsage usage : EnumUtil.getAllValuesOfEnum(KeyUsage.class)) {
            if ((1 << 8 - usage.ordinal() - 1 & keyUsageMask) <= 0 && (usage != KeyUsage.DECIPHER_ONLY || (keyUsageMask & 0x8000) != 32768)) continue;
            result.append(separator).append((Object)usage);
            separator = ", ";
        }
        return result.toString();
    }

    private static int convertKeyUsageSetToInt(Iterable<KeyUsage> keyUsages) {
        int keyUsageMask = 0;
        for (KeyUsage usage : keyUsages) {
            if (usage == KeyUsage.DECIPHER_ONLY) {
                keyUsageMask += 32768;
                continue;
            }
            keyUsageMask += 1 << 8 - usage.ordinal() - 1;
        }
        return keyUsageMask;
    }
}

