/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures;

import com.itextpdf.bouncycastleconnector.BouncyCastleFactoryCreator;
import com.itextpdf.kernel.crypto.DigestAlgorithms;
import com.itextpdf.signatures.IExternalDigest;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;

public class BouncyCastleDigest
implements IExternalDigest {
    @Override
    public MessageDigest getMessageDigest(String hashAlgorithm) throws GeneralSecurityException {
        String oid = DigestAlgorithms.getAllowedDigest(hashAlgorithm);
        if (oid == null) {
            throw new NoSuchAlgorithmException(hashAlgorithm);
        }
        Provider provider = BouncyCastleFactoryCreator.getFactory().getProvider();
        switch (oid) {
            case "1.3.14.3.2.26": {
                return MessageDigest.getInstance("SHA1", provider);
            }
            case "2.16.840.1.101.3.4.2.4": {
                return MessageDigest.getInstance("SHA224", provider);
            }
            case "2.16.840.1.101.3.4.2.1": {
                return MessageDigest.getInstance("SHA256", provider);
            }
            case "2.16.840.1.101.3.4.2.2": {
                return MessageDigest.getInstance("SHA384", provider);
            }
            case "2.16.840.1.101.3.4.2.3": {
                return MessageDigest.getInstance("SHA512", provider);
            }
            case "2.16.840.1.101.3.4.2.7": {
                return MessageDigest.getInstance("SHA3-224", provider);
            }
            case "2.16.840.1.101.3.4.2.8": {
                return MessageDigest.getInstance("SHA3-256", provider);
            }
            case "2.16.840.1.101.3.4.2.9": {
                return MessageDigest.getInstance("SHA3-384", provider);
            }
            case "2.16.840.1.101.3.4.2.10": {
                return MessageDigest.getInstance("SHA3-512", provider);
            }
            case "2.16.840.1.101.3.4.2.12": {
                return MessageDigest.getInstance("SHAKE256", provider);
            }
            case "1.3.36.3.2.2": {
                return MessageDigest.getInstance("RIPEMD128", provider);
            }
            case "1.3.36.3.2.1": {
                return MessageDigest.getInstance("RIPEMD160", provider);
            }
            case "1.3.36.3.2.3": {
                return MessageDigest.getInstance("RIPEMD256", provider);
            }
            case "1.2.643.2.2.9": {
                return MessageDigest.getInstance("GOST3411", provider);
            }
        }
        throw new NoSuchAlgorithmException(hashAlgorithm);
    }
}

