/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfua.checkers.utils.tables;

import com.itextpdf.commons.datastructures.Tuple2;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.tagging.IStructureNode;
import com.itextpdf.kernel.pdf.tagging.PdfStructElem;
import com.itextpdf.pdfua.checkers.utils.PdfUAValidationContext;
import com.itextpdf.pdfua.checkers.utils.tables.ITableIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class TableStructElementIterator
implements ITableIterator<PdfStructElem> {
    final PdfUAValidationContext context;
    private final List<PdfStructElem> all = new ArrayList<PdfStructElem>();
    private final HashMap<PdfStructElem, Tuple2<Integer, Integer>> locationCache = new HashMap();
    private int amountOfCols = 0;
    private int amountOfRowsHeader = 0;
    private int amountOfRowsBody = 0;
    private int amountOfRowsFooter = 0;
    private int iterIndex = 0;
    private PdfStructElem currentValue;

    public TableStructElementIterator(PdfStructElem tableStructElem, PdfUAValidationContext context) {
        this.context = context;
        this.flattenElements(tableStructElem);
    }

    @Override
    public boolean hasNext() {
        return this.iterIndex < this.all.size();
    }

    @Override
    public PdfStructElem next() {
        this.currentValue = this.all.get(this.iterIndex++);
        return this.currentValue;
    }

    @Override
    public int getAmountOfRowsBody() {
        return this.amountOfRowsBody;
    }

    @Override
    public int getAmountOfRowsHeader() {
        return this.amountOfRowsHeader;
    }

    @Override
    public int getAmountOfRowsFooter() {
        return this.amountOfRowsFooter;
    }

    @Override
    public int getNumberOfColumns() {
        return this.amountOfCols;
    }

    @Override
    public int getRow() {
        return this.locationCache.get(this.currentValue).getFirst();
    }

    @Override
    public int getCol() {
        return this.locationCache.get(this.currentValue).getSecond();
    }

    @Override
    public int getRowspan() {
        return TableStructElementIterator.getRowspan(this.currentValue);
    }

    @Override
    public int getColspan() {
        return TableStructElementIterator.getColspan(this.currentValue);
    }

    private void flattenElements(PdfStructElem table) {
        List<PdfStructElem> rows = this.extractTableRows(table);
        this.setAmountOfCols(rows);
        this.build2DRepresentationOfTagTreeStructures(rows);
    }

    private PdfName getRole(IStructureNode node) {
        String roleStr = this.context.resolveToStandardRole(node);
        if (roleStr == null) {
            return null;
        }
        return new PdfName(roleStr);
    }

    private List<PdfStructElem> extractTableRows(PdfStructElem table) {
        List<IStructureNode> kids = table.getKids();
        ArrayList<PdfStructElem> rows = new ArrayList<PdfStructElem>();
        for (IStructureNode kid : kids) {
            List<PdfStructElem> bodyRows;
            if (kid == null) continue;
            PdfName kidRole = this.getRole(kid);
            if (PdfName.THead.equals(kidRole)) {
                List<PdfStructElem> headerRows = this.extractAllTrTags(kid.getKids());
                this.amountOfRowsHeader = headerRows.size();
                rows.addAll(headerRows);
                continue;
            }
            if (PdfName.TBody.equals(kidRole)) {
                bodyRows = this.extractAllTrTags(kid.getKids());
                this.amountOfRowsBody += bodyRows.size();
                rows.addAll(bodyRows);
                continue;
            }
            if (PdfName.TFoot.equals(kidRole)) {
                List<PdfStructElem> footerRows = this.extractAllTrTags(kid.getKids());
                this.amountOfRowsFooter = footerRows.size();
                rows.addAll(footerRows);
                continue;
            }
            if (!PdfName.TR.equals(kidRole)) continue;
            bodyRows = this.extractAllTrTags(Collections.singletonList(kid));
            this.amountOfRowsBody += bodyRows.size();
            rows.addAll(bodyRows);
        }
        return rows;
    }

    private void build2DRepresentationOfTagTreeStructures(List<PdfStructElem> rows) {
        int rowIdx;
        boolean[][] arr = new boolean[rows.size()][];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = new boolean[this.amountOfCols];
        }
        for (rowIdx = 0; rowIdx < rows.size(); ++rowIdx) {
            List<PdfStructElem> cells = this.extractCells(rows.get(rowIdx));
            for (PdfStructElem cell : cells) {
                int i;
                int colSpan = TableStructElementIterator.getColspan(cell);
                int rowSpan = TableStructElementIterator.getRowspan(cell);
                int firstOpenColIndex = -1;
                for (i = 0; i < this.amountOfCols; ++i) {
                    if (arr[rowIdx][i]) continue;
                    firstOpenColIndex = i;
                    break;
                }
                for (i = rowIdx; i < rowIdx + rowSpan; ++i) {
                    for (int j = firstOpenColIndex; j < firstOpenColIndex + colSpan; ++j) {
                        arr[i][j] = true;
                    }
                }
                this.locationCache.put(cell, new Tuple2<Integer, Integer>(rowIdx, firstOpenColIndex));
                this.all.add(cell);
            }
        }
        for (rowIdx = 0; rowIdx < arr.length; ++rowIdx) {
            for (int colIdx = 0; colIdx < arr[rowIdx].length; ++colIdx) {
                if (arr[rowIdx][colIdx]) continue;
                PdfStructElem pdfStructElem = new PdfStructElem(new PdfDictionary());
                this.locationCache.put(pdfStructElem, new Tuple2<Integer, Integer>(rowIdx, colIdx));
                this.all.add(pdfStructElem);
            }
        }
    }

    private void setAmountOfCols(List<PdfStructElem> rows) {
        for (PdfStructElem row : rows) {
            int amt = 0;
            for (PdfStructElem kid : this.extractCells(row)) {
                amt += TableStructElementIterator.getColspan(kid);
            }
            this.amountOfCols = Math.max(amt, this.amountOfCols);
        }
    }

    private List<PdfStructElem> extractCells(PdfStructElem row) {
        ArrayList<PdfStructElem> elems = new ArrayList<PdfStructElem>();
        for (IStructureNode kid : row.getKids()) {
            PdfName kidRole;
            if (!(kid instanceof PdfStructElem) || !PdfName.TH.equals(kidRole = this.getRole(kid)) && !PdfName.TD.equals(kidRole)) continue;
            elems.add((PdfStructElem)kid);
        }
        return elems;
    }

    private static int getColspan(PdfStructElem structElem) {
        return TableStructElementIterator.getIntValueFromAttributes(structElem, PdfName.ColSpan);
    }

    private static int getRowspan(PdfStructElem structElem) {
        return TableStructElementIterator.getIntValueFromAttributes(structElem, PdfName.RowSpan);
    }

    private static int getIntValueFromAttributes(PdfStructElem elem, PdfName name) {
        PdfNumber f;
        PdfObject object = elem.getAttributes(false);
        if (object instanceof PdfArray) {
            PdfArray array = (PdfArray)object;
            for (PdfObject pdfObject : array) {
                PdfNumber f2;
                if (!(pdfObject instanceof PdfDictionary) || (f2 = ((PdfDictionary)pdfObject).getAsNumber(name)) == null) continue;
                return f2.intValue();
            }
        } else if (object instanceof PdfDictionary && (f = ((PdfDictionary)object).getAsNumber(name)) != null) {
            return f.intValue();
        }
        return 1;
    }

    private List<PdfStructElem> extractAllTrTags(List<IStructureNode> possibleTrs) {
        ArrayList<PdfStructElem> elems = new ArrayList<PdfStructElem>();
        for (IStructureNode possibleTr : possibleTrs) {
            String resolvedRole = this.context.resolveToStandardRole(possibleTr);
            if (!(possibleTr instanceof PdfStructElem) || !PdfName.TR.getValue().equals(resolvedRole)) continue;
            elems.add((PdfStructElem)possibleTr);
        }
        return elems;
    }
}

