/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfua.checkers.utils;

import com.itextpdf.forms.xfa.XfaForm;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.pdfua.exceptions.PdfUAConformanceException;

public final class XfaCheckUtil {
    private static final String PATH_TO_DYNAMIC_RENDER = "xdp.config.acrobat.acrobat7.dynamicRender";
    private static final String REQUIRED_VALUE = "required";

    private XfaCheckUtil() {
    }

    public static void check(PdfDocument pdfDocument) {
        XfaForm xfaForm = new XfaForm(pdfDocument);
        String dynamicValue = xfaForm.getNodeTextByPath(PATH_TO_DYNAMIC_RENDER);
        if (REQUIRED_VALUE.equals(dynamicValue)) {
            throw new PdfUAConformanceException("Dynamic XFA forms shall not be used.");
        }
    }
}

