/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.geom.AffineTransform;
import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.tagutils.TagTreePointer;
import com.itextpdf.layout.borders.Border;
import com.itextpdf.layout.element.IElement;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.layout.MinMaxWidthLayoutResult;
import com.itextpdf.layout.layout.PositionedLayoutContext;
import com.itextpdf.layout.margincollapse.MarginsCollapseHandler;
import com.itextpdf.layout.margincollapse.MarginsCollapseInfo;
import com.itextpdf.layout.minmaxwidth.MinMaxWidth;
import com.itextpdf.layout.minmaxwidth.MinMaxWidthUtils;
import com.itextpdf.layout.properties.AreaBreakType;
import com.itextpdf.layout.properties.ClearPropertyValue;
import com.itextpdf.layout.properties.ContinuousContainer;
import com.itextpdf.layout.properties.FloatPropertyValue;
import com.itextpdf.layout.properties.OverflowPropertyValue;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.layout.properties.VerticalAlignment;
import com.itextpdf.layout.renderer.AbstractRenderer;
import com.itextpdf.layout.renderer.AbstractWidthHandler;
import com.itextpdf.layout.renderer.AccessibleAttributesApplier;
import com.itextpdf.layout.renderer.BlockFormattingContextUtil;
import com.itextpdf.layout.renderer.CellRenderer;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.FlexContainerRenderer;
import com.itextpdf.layout.renderer.FloatingHelper;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.MaxMaxWidthHandler;
import com.itextpdf.layout.renderer.RotationUtils;
import com.itextpdf.layout.renderer.TargetCounterHandler;
import com.itextpdf.layout.tagging.LayoutTaggingHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BlockRenderer
extends AbstractRenderer {
    protected BlockRenderer(IElement modelElement) {
        super(modelElement);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public LayoutResult layout(LayoutContext layoutContext) {
        this.isLastRendererForModelElement = true;
        waitingFloatsSplitRenderers = new LinkedHashMap<Integer, IRenderer>();
        waitingOverflowFloatRenderers = new ArrayList<IRenderer>();
        floatOverflowedCompletely = false;
        wasHeightClipped = false;
        wasParentsHeightClipped = layoutContext.isClippedHeight();
        pageNumber = layoutContext.getArea().getPageNumber();
        isPositioned = this.isPositioned();
        parentBBox = layoutContext.getArea().getBBox().clone();
        floatRendererAreas = layoutContext.getFloatRendererAreas();
        floatPropertyValue = (FloatPropertyValue)this.getProperty(99);
        rotation = this.getPropertyAsFloat(55);
        overflowX = (OverflowPropertyValue)this.getProperty(103);
        marginsCollapseHandler = null;
        marginsCollapsingEnabled = Boolean.TRUE.equals(this.getPropertyAsBoolean(89));
        if (marginsCollapsingEnabled) {
            marginsCollapseHandler = new MarginsCollapseHandler(this, layoutContext.getMarginsCollapseInfo());
        }
        blockWidth = this.retrieveWidth(parentBBox.getWidth());
        if (rotation != null || this.isFixedLayout()) {
            parentBBox.moveDown(1000000.0f - parentBBox.getHeight()).setHeight(1000000.0f);
        }
        if (rotation != null && !FloatingHelper.isRendererFloating(this, floatPropertyValue) && !(this instanceof FlexContainerRenderer)) {
            blockWidth = RotationUtils.retrieveRotatedLayoutWidth(parentBBox.getWidth(), this);
        }
        includeFloatsInOccupiedArea = BlockFormattingContextUtil.isRendererCreateBfc(this);
        clearHeightCorrection = FloatingHelper.calculateClearHeightCorrection(this, floatRendererAreas, parentBBox);
        FloatingHelper.applyClearance(parentBBox, marginsCollapseHandler, clearHeightCorrection, FloatingHelper.isRendererFloating(this));
        if (FloatingHelper.isRendererFloating(this, floatPropertyValue)) {
            blockWidth = FloatingHelper.adjustFloatedBlockLayoutBox(this, parentBBox, blockWidth, floatRendererAreas, floatPropertyValue, overflowX);
            floatRendererAreas = new ArrayList<Rectangle>();
        }
        wasHeightDecreased = clearHeightCorrection > 0.0f && (marginsCollapseHandler == null || FloatingHelper.isRendererFloating(this) != false);
        bfcHeightCorrection = FloatingHelper.adjustBlockFormattingContextLayoutBox(this, floatRendererAreas, parentBBox, blockWidth == null ? 0.0f : blockWidth.floatValue(), wasHeightDecreased != false ? 0.0f : clearHeightCorrection);
        isCellRenderer = this instanceof CellRenderer;
        if (marginsCollapsingEnabled) {
            marginsCollapseHandler.startMarginsCollapse(parentBBox);
        }
        ContinuousContainer.setupContinuousContainerIfNeeded(this);
        borders = this.getBorders();
        paddings = this.getPaddings();
        this.applyMargins(parentBBox, false);
        this.applyBorderBox(parentBBox, borders, false);
        if (this.isFixedLayout()) {
            parentBBox.setX(this.getPropertyAsFloat(34).floatValue());
        }
        this.applyPaddings(parentBBox, paddings, false);
        blockMaxHeight = this.retrieveMaxHeight();
        overflowY = (null == blockMaxHeight || blockMaxHeight.floatValue() > parentBBox.getHeight()) && wasParentsHeightClipped == false ? OverflowPropertyValue.FIT : (OverflowPropertyValue)this.getProperty(104);
        this.applyWidth(parentBBox, blockWidth, overflowX);
        wasHeightClipped = this.applyMaxHeight(parentBBox, blockMaxHeight, marginsCollapseHandler, isCellRenderer, wasParentsHeightClipped, overflowY);
        areas = isPositioned != false ? Collections.singletonList(parentBBox) : this.initElementAreas(new LayoutArea(pageNumber, parentBBox));
        this.occupiedArea = new LayoutArea(pageNumber, new Rectangle(parentBBox.getX(), parentBBox.getY() + parentBBox.getHeight(), parentBBox.getWidth(), 0.0f));
        this.shrinkOccupiedAreaForAbsolutePosition();
        TargetCounterHandler.addPageByID(this);
        currentAreaPos = 0;
        layoutBox = areas.get(0).clone();
        nonChildFloatingRendererAreas = new HashSet<Rectangle>(floatRendererAreas);
        causeOfNothing = null;
        anythingPlaced = false;
        initialForcePlacementForRotationAdjustments = Boolean.TRUE.equals(this.getPropertyAsBoolean(26));
        for (childPos = 0; childPos < this.childRenderers.size(); ++childPos) {
            block60: {
                childRenderer = (IRenderer)this.childRenderers.get(childPos);
                childRenderer.setParent(this);
                childMarginsInfo = null;
                if (floatOverflowedCompletely && FloatingHelper.isRendererFloating(childRenderer)) {
                    waitingFloatsSplitRenderers.put(childPos, null);
                    waitingOverflowFloatRenderers.add(childRenderer);
                    continue;
                }
                if (!waitingOverflowFloatRenderers.isEmpty() && FloatingHelper.isClearanceApplied(waitingOverflowFloatRenderers, (ClearPropertyValue)childRenderer.getProperty(100))) {
                    if (FloatingHelper.isRendererFloating(childRenderer)) {
                        waitingFloatsSplitRenderers.put(childPos, null);
                        waitingOverflowFloatRenderers.add(childRenderer);
                        floatOverflowedCompletely = true;
                        continue;
                    }
                    if (marginsCollapsingEnabled && !isCellRenderer) {
                        marginsCollapseHandler.endMarginsCollapse(layoutBox);
                    }
                    FloatingHelper.includeChildFloatsInOccupiedArea(floatRendererAreas, this, nonChildFloatingRendererAreas);
                    this.fixOccupiedAreaIfOverflowedX(overflowX, layoutBox);
                    result = new LayoutResult(3, null, null, childRenderer);
                    isKeepTogether = this.isKeepTogether(childRenderer);
                    layoutResult = anythingPlaced != false && isKeepTogether == false ? 2 : 3;
                    splitAndOverflowRenderers = this.createSplitAndOverflowRenderers(childPos, layoutResult, result, waitingFloatsSplitRenderers, waitingOverflowFloatRenderers);
                    splitRenderer = splitAndOverflowRenderers[0];
                    overflowRenderer = splitAndOverflowRenderers[1];
                    if (isKeepTogether) {
                        splitRenderer = null;
                        overflowRenderer.childRenderers.clear();
                        overflowRenderer.childRenderers = new ArrayList<IRenderer>(this.childRenderers);
                    }
                    this.updateHeightsOnSplit(wasHeightClipped, splitRenderer, overflowRenderer);
                    this.applyPaddings(this.occupiedArea.getBBox(), paddings, true);
                    this.applyBorderBox(this.occupiedArea.getBBox(), borders, true);
                    this.applyMargins(this.occupiedArea.getBBox(), true);
                    if (Boolean.TRUE.equals(this.getPropertyAsBoolean(26)) || wasHeightClipped) {
                        editedArea = FloatingHelper.adjustResultOccupiedAreaForFloatAndClear(this, layoutContext.getFloatRendererAreas(), layoutContext.getArea().getBBox(), clearHeightCorrection, bfcHeightCorrection, marginsCollapsingEnabled);
                        return new LayoutResult(1, editedArea, splitRenderer, null, null);
                    }
                    if (layoutResult != 3) {
                        editedArea = FloatingHelper.adjustResultOccupiedAreaForFloatAndClear(this, layoutContext.getFloatRendererAreas(), layoutContext.getArea().getBBox(), clearHeightCorrection, bfcHeightCorrection, marginsCollapsingEnabled);
                        return new LayoutResult(layoutResult, editedArea, splitRenderer, overflowRenderer, null).setAreaBreak(result.getAreaBreak());
                    }
                    floatRendererAreas.retainAll(nonChildFloatingRendererAreas);
                    return new LayoutResult(layoutResult, null, null, overflowRenderer, result.getCauseOfNothing()).setAreaBreak(result.getAreaBreak());
                }
                if (marginsCollapsingEnabled) {
                    childMarginsInfo = this.startChildMarginsHandling(childRenderer, layoutBox, marginsCollapseHandler);
                }
                changedLayoutBox = this.recalculateLayoutBoxBeforeChildLayout(layoutBox, childRenderer, areas.get(0).clone());
                result = childRenderer.setParent(this).layout(new LayoutContext(new LayoutArea(pageNumber, changedLayoutBox), childMarginsInfo, floatRendererAreas, wasHeightClipped != false || wasParentsHeightClipped != false));
                if (result.getStatus() == 1) break block60;
                if (Boolean.TRUE.equals(this.getPropertyAsBoolean(87)) || Boolean.TRUE.equals(this.getPropertyAsBoolean(86))) {
                    this.occupiedArea.setBBox(Rectangle.getCommonRectangle(new Rectangle[]{this.occupiedArea.getBBox(), layoutBox}));
                } else if (result.getOccupiedArea() != null && result.getStatus() != 3) {
                    this.recalculateOccupiedAreaAfterChildLayout(result.getOccupiedArea().getBBox(), blockMaxHeight);
                    this.fixOccupiedAreaIfOverflowedX(overflowX, layoutBox);
                }
                if (marginsCollapsingEnabled && result.getStatus() != 3) {
                    marginsCollapseHandler.endChildMarginsHandling(layoutBox);
                }
                if (!FloatingHelper.isRendererFloating(childRenderer)) ** GOTO lbl-1000
                v0 = immediatelyReturnNothing = result.getStatus() == 3 && anythingPlaced == false && floatRendererAreas.isEmpty() != false && this.isFirstOnRootArea() != false;
                if (!immediatelyReturnNothing) {
                    waitingFloatsSplitRenderers.put(childPos, result.getStatus() == 2 ? result.getSplitRenderer() : null);
                    waitingOverflowFloatRenderers.add(result.getOverflowRenderer());
                    floatOverflowedCompletely = result.getStatus() == 3;
                } else lbl-1000:
                // 2 sources

                {
                    if (marginsCollapsingEnabled) {
                        marginsCollapseHandler.endMarginsCollapse(layoutBox);
                    }
                    FloatingHelper.includeChildFloatsInOccupiedArea(floatRendererAreas, this, nonChildFloatingRendererAreas);
                    this.fixOccupiedAreaIfOverflowedX(overflowX, layoutBox);
                    if (result.getSplitRenderer() != null) {
                        this.alignChildHorizontally(result.getSplitRenderer(), this.occupiedArea.getBBox());
                    }
                    if (null == causeOfNothing && null != result.getCauseOfNothing()) {
                        causeOfNothing = result.getCauseOfNothing();
                    }
                    if (currentAreaPos + 1 < areas.size() && (result.getAreaBreak() == null || result.getAreaBreak().getType() != AreaBreakType.NEXT_PAGE)) {
                        if (result.getStatus() == 2) {
                            this.childRenderers.set(childPos, result.getSplitRenderer());
                            this.childRenderers.add(childPos + 1, result.getOverflowRenderer());
                        } else {
                            if (result.getOverflowRenderer() != null) {
                                this.childRenderers.set(childPos, result.getOverflowRenderer());
                            } else {
                                this.childRenderers.remove(childPos);
                            }
                            --childPos;
                        }
                        layoutBox = areas.get(++currentAreaPos).clone();
                    } else {
                        layoutResult = this.processNotFullChildResult(layoutContext, waitingFloatsSplitRenderers, waitingOverflowFloatRenderers, wasHeightClipped, floatRendererAreas, marginsCollapsingEnabled, clearHeightCorrection, borders, paddings, areas, currentAreaPos, layoutBox, nonChildFloatingRendererAreas, causeOfNothing, anythingPlaced, childPos, result);
                        if (layoutResult == null) {
                            layoutBox = areas.get(++currentAreaPos).clone();
                        } else {
                            if (this.stopLayoutingChildrenIfChildResultNotFull(layoutResult)) {
                                return layoutResult;
                            }
                            result = layoutResult;
                        }
                    }
                }
            }
            anythingPlaced = anythingPlaced != false || result.getStatus() != 3;
            this.handleForcedPlacement(anythingPlaced);
            if (result.getOccupiedArea() != null && (!FloatingHelper.isRendererFloating(childRenderer) || includeFloatsInOccupiedArea)) {
                this.recalculateOccupiedAreaAfterChildLayout(result.getOccupiedArea().getBBox(), blockMaxHeight);
                this.fixOccupiedAreaIfOverflowedX(overflowX, layoutBox);
            }
            if (marginsCollapsingEnabled) {
                marginsCollapseHandler.endChildMarginsHandling(layoutBox);
            }
            if (result.getStatus() == 1) {
                this.decreaseLayoutBoxAfterChildPlacement(layoutBox, result, childRenderer);
                if (childRenderer.getOccupiedArea() != null) {
                    this.alignChildHorizontally(childRenderer, this.occupiedArea.getBBox());
                }
            }
            if (null != causeOfNothing || null == result.getCauseOfNothing()) continue;
            causeOfNothing = result.getCauseOfNothing();
        }
        if (includeFloatsInOccupiedArea) {
            FloatingHelper.includeChildFloatsInOccupiedArea(floatRendererAreas, this, nonChildFloatingRendererAreas);
            this.fixOccupiedAreaIfOverflowedX(overflowX, layoutBox);
        }
        if (wasHeightClipped) {
            this.fixOccupiedAreaIfOverflowedY(overflowY, layoutBox);
        }
        if (marginsCollapsingEnabled) {
            marginsCollapseHandler.endMarginsCollapse(layoutBox);
        }
        if (Boolean.TRUE.equals(this.getPropertyAsBoolean(86))) {
            this.occupiedArea.setBBox(Rectangle.getCommonRectangle(new Rectangle[]{this.occupiedArea.getBBox(), layoutBox}));
        }
        layoutResult = 1;
        processOverflowedFloats = waitingOverflowFloatRenderers.isEmpty() == false && wasHeightClipped == false && Boolean.TRUE.equals(this.getPropertyAsBoolean(26)) == false;
        overflowRenderer = null;
        if (!includeFloatsInOccupiedArea || !processOverflowedFloats) {
            overflowRenderer = this.applyMinHeight(overflowY, layoutBox);
        }
        v1 = minHeightOverflow = overflowRenderer != null;
        if (minHeightOverflow && this.isKeepTogether()) {
            floatRendererAreas.retainAll(nonChildFloatingRendererAreas);
            return new LayoutResult(3, null, null, this, this);
        }
        if (overflowRenderer != null || processOverflowedFloats) {
            v2 = layoutResult = anythingPlaced == false && (waitingOverflowFloatRenderers.isEmpty() == false || this.isAnythingOccupied() == false) ? 3 : 2;
        }
        if (processOverflowedFloats) {
            if (overflowRenderer == null || layoutResult == 3) {
                overflowRenderer = this.createOverflowRenderer(layoutResult);
            }
            overflowRenderer.getChildRenderers().addAll(waitingOverflowFloatRenderers);
            if (layoutResult == 2 && !minHeightOverflow && !includeFloatsInOccupiedArea) {
                FloatingHelper.removeParentArtifactsOnPageSplitIfOnlyFloatsOverflow(overflowRenderer);
            }
        }
        splitRenderer /* !! */  = this;
        if (waitingFloatsSplitRenderers.size() > 0 && layoutResult != 3) {
            splitRenderer /* !! */  = this.createSplitRenderer(layoutResult);
            splitRenderer /* !! */ .childRenderers = new ArrayList<IRenderer>(this.childRenderers);
            this.replaceSplitRendererKidFloats(waitingFloatsSplitRenderers, splitRenderer /* !! */ );
            usedHeight = this.occupiedArea.getBBox().getHeight();
            if (!includeFloatsInOccupiedArea) {
                commonRectangle = Rectangle.getCommonRectangle(new Rectangle[]{layoutBox, this.occupiedArea.getBBox()});
                usedHeight = commonRectangle.getHeight();
            }
            this.updateHeightsOnSplit(usedHeight, wasHeightClipped, splitRenderer /* !! */ , overflowRenderer, includeFloatsInOccupiedArea);
        }
        if (this.positionedRenderers.size() > 0) {
            for (IRenderer childPositionedRenderer : this.positionedRenderers) {
                fullBbox = this.occupiedArea.getBBox().clone();
                layoutMinHeight = 1000.0f;
                fullBbox.moveDown(layoutMinHeight).setHeight(layoutMinHeight + fullBbox.getHeight());
                parentArea = new LayoutArea(this.occupiedArea.getPageNumber(), this.occupiedArea.getBBox().clone());
                this.applyPaddings(parentArea.getBBox(), paddings, true);
                this.preparePositionedRendererAndAreaForLayout(childPositionedRenderer, fullBbox, parentArea.getBBox());
                childPositionedRenderer.layout(new PositionedLayoutContext(new LayoutArea(this.occupiedArea.getPageNumber(), fullBbox), parentArea));
            }
        }
        if (isPositioned) {
            this.correctFixedLayout(layoutBox);
        }
        if ((continuousContainer = (ContinuousContainer)this.getProperty(141)) != null && overflowRenderer == null) {
            continuousContainer.reApplyProperties(this);
            paddings = this.getPaddings();
            borders = this.getBorders();
        }
        this.applyPaddings(this.occupiedArea.getBBox(), paddings, true);
        this.applyBorderBox(this.occupiedArea.getBBox(), borders, true);
        this.applyMargins(this.occupiedArea.getBBox(), true);
        this.applyAbsolutePositionIfNeeded(layoutContext);
        if (rotation != null) {
            this.applyRotationLayout(layoutContext.getArea().getBBox().clone());
            if (this.isNotFittingLayoutArea(layoutContext.getArea())) {
                if (this.isNotFittingWidth(layoutContext.getArea()) && !this.isNotFittingHeight(layoutContext.getArea())) {
                    LoggerFactory.getLogger(this.getClass()).warn(MessageFormatUtil.format("Element does not fit current area. {0}", new Object[]{"It fits by height so it will be forced placed"}));
                } else if (!initialForcePlacementForRotationAdjustments) {
                    floatRendererAreas.retainAll(nonChildFloatingRendererAreas);
                    return new MinMaxWidthLayoutResult(3, null, null, this, this);
                }
            }
        }
        this.applyVerticalAlignment();
        FloatingHelper.removeFloatsAboveRendererBottom(floatRendererAreas, this);
        if (layoutResult != 3) {
            ContinuousContainer.clearPropertiesFromOverFlowRenderer(overflowRenderer);
            editedArea = FloatingHelper.adjustResultOccupiedAreaForFloatAndClear(this, layoutContext.getFloatRendererAreas(), layoutContext.getArea().getBBox(), clearHeightCorrection, bfcHeightCorrection, marginsCollapsingEnabled);
            return new LayoutResult(layoutResult, editedArea, splitRenderer /* !! */ , overflowRenderer, causeOfNothing);
        }
        if (this.positionedRenderers.size() > 0) {
            overflowRenderer.positionedRenderers = new ArrayList<IRenderer>(this.positionedRenderers);
        }
        floatRendererAreas.retainAll(nonChildFloatingRendererAreas);
        return new LayoutResult(3, null, null, overflowRenderer, causeOfNothing);
    }

    @Override
    public void draw(DrawContext drawContext) {
        Logger logger = LoggerFactory.getLogger(BlockRenderer.class);
        if (this.occupiedArea == null) {
            logger.error(MessageFormatUtil.format("Occupied area has not been initialized. {0}", "Drawing won't be performed."));
            return;
        }
        boolean isTagged = drawContext.isTaggingEnabled();
        LayoutTaggingHelper taggingHelper = null;
        if (isTagged) {
            taggingHelper = (LayoutTaggingHelper)this.getProperty(108);
            if (taggingHelper == null) {
                isTagged = false;
            } else {
                TagTreePointer tagPointer = taggingHelper.useAutoTaggingPointerAndRememberItsPosition(this);
                if (taggingHelper.createTag(this, tagPointer)) {
                    tagPointer.getProperties().addAttributes(0, AccessibleAttributesApplier.getListAttributes(this, tagPointer)).addAttributes(0, AccessibleAttributesApplier.getTableAttributes(this, tagPointer)).addAttributes(0, AccessibleAttributesApplier.getLayoutAttributes(this, tagPointer));
                }
            }
        }
        this.beginTransformationIfApplied(drawContext.getCanvas());
        this.applyDestinationsAndAnnotation(drawContext);
        boolean isRelativePosition = this.isRelativePosition();
        if (isRelativePosition) {
            this.applyRelativePositioningTranslation(false);
        }
        this.beginElementOpacityApplying(drawContext);
        this.beginRotationIfApplied(drawContext.getCanvas());
        boolean overflowXHidden = this.isOverflowProperty(OverflowPropertyValue.HIDDEN, 103);
        boolean overflowYHidden = this.isOverflowProperty(OverflowPropertyValue.HIDDEN, 104);
        boolean processOverflow = overflowXHidden || overflowYHidden;
        this.drawBackground(drawContext);
        this.drawBorder(drawContext);
        this.addMarkedContent(drawContext, true);
        if (processOverflow) {
            Rectangle clippedArea;
            drawContext.getCanvas().saveState();
            int pageNumber = this.occupiedArea.getPageNumber();
            if (pageNumber < 1 || pageNumber > drawContext.getDocument().getNumberOfPages()) {
                clippedArea = new Rectangle(-500000.0f, -500000.0f, 1000000.0f, 1000000.0f);
            } else {
                PdfPage page = drawContext.getDocument().getPage(pageNumber);
                if (page.isFlushed()) {
                    logger.error(MessageFormatUtil.format("Page was flushed. {0} will not be performed.", "area clipping"));
                    clippedArea = new Rectangle(-500000.0f, -500000.0f, 1000000.0f, 1000000.0f);
                } else {
                    clippedArea = page.getPageSize();
                }
            }
            Rectangle area = this.getBorderAreaBBox();
            if (overflowXHidden) {
                clippedArea.setX(area.getX()).setWidth(area.getWidth());
            }
            if (overflowYHidden) {
                clippedArea.setY(area.getY()).setHeight(area.getHeight());
            }
            drawContext.getCanvas().rectangle(clippedArea).clip().endPath();
        }
        this.drawChildren(drawContext);
        this.addMarkedContent(drawContext, false);
        this.drawPositionedChildren(drawContext);
        if (processOverflow) {
            drawContext.getCanvas().restoreState();
        }
        this.endRotationIfApplied(drawContext.getCanvas());
        this.endElementOpacityApplying(drawContext);
        if (isRelativePosition) {
            this.applyRelativePositioningTranslation(true);
        }
        if (isTagged) {
            if (this.isLastRendererForModelElement) {
                taggingHelper.finishTaggingHint(this);
            }
            taggingHelper.restoreAutoTaggingPointerPosition(this);
        }
        this.flushed = true;
        this.endTransformationIfApplied(drawContext.getCanvas());
    }

    @Override
    public Rectangle getOccupiedAreaBBox() {
        Rectangle bBox = this.occupiedArea.getBBox().clone();
        Float rotationAngle = (Float)this.getProperty(55);
        if (rotationAngle != null) {
            if (!this.hasOwnProperty(57) || !this.hasOwnProperty(56)) {
                Logger logger = LoggerFactory.getLogger(BlockRenderer.class);
                logger.error(MessageFormatUtil.format("Rotation was not correctly processed for {0}", this.getClass().getSimpleName()));
            } else {
                bBox.setWidth(this.getPropertyAsFloat(57).floatValue());
                bBox.setHeight(this.getPropertyAsFloat(56).floatValue());
            }
        }
        return bBox;
    }

    protected AbstractRenderer createSplitRenderer(int layoutResult) {
        AbstractRenderer splitRenderer = (AbstractRenderer)this.getNextRenderer();
        splitRenderer.parent = this.parent;
        splitRenderer.modelElement = this.modelElement;
        splitRenderer.occupiedArea = this.occupiedArea;
        splitRenderer.isLastRendererForModelElement = false;
        splitRenderer.addAllProperties(this.getOwnProperties());
        return splitRenderer;
    }

    protected AbstractRenderer createOverflowRenderer(int layoutResult) {
        AbstractRenderer overflowRenderer = (AbstractRenderer)this.getNextRenderer();
        overflowRenderer.parent = this.parent;
        overflowRenderer.modelElement = this.modelElement;
        overflowRenderer.addAllProperties(this.getOwnProperties());
        return overflowRenderer;
    }

    void recalculateOccupiedAreaAfterChildLayout(Rectangle resultBBox, Float blockMaxHeight) {
        this.occupiedArea.setBBox(Rectangle.getCommonRectangle(this.occupiedArea.getBBox(), resultBBox));
    }

    MarginsCollapseInfo startChildMarginsHandling(IRenderer childRenderer, Rectangle layoutBox, MarginsCollapseHandler marginsCollapseHandler) {
        return marginsCollapseHandler.startChildMarginsHandling(childRenderer, layoutBox);
    }

    Rectangle recalculateLayoutBoxBeforeChildLayout(Rectangle layoutBox, IRenderer childRenderer, Rectangle initialLayoutBox) {
        return layoutBox;
    }

    AbstractRenderer[] createSplitAndOverflowRenderers(int childPos, int layoutStatus, LayoutResult childResult, Map<Integer, IRenderer> waitingFloatsSplitRenderers, List<IRenderer> waitingOverflowFloatRenderers) {
        AbstractRenderer splitRenderer = this.createSplitRenderer(layoutStatus);
        splitRenderer.childRenderers = new ArrayList<IRenderer>(this.childRenderers.subList(0, childPos));
        if (childResult.getStatus() == 2 && childResult.getSplitRenderer() != null) {
            splitRenderer.childRenderers.add(childResult.getSplitRenderer());
        }
        this.replaceSplitRendererKidFloats(waitingFloatsSplitRenderers, splitRenderer);
        for (IRenderer renderer : splitRenderer.childRenderers) {
            renderer.setParent(splitRenderer);
        }
        AbstractRenderer overflowRenderer = this.createOverflowRenderer(layoutStatus);
        overflowRenderer.childRenderers.addAll(waitingOverflowFloatRenderers);
        if (childResult.getOverflowRenderer() != null) {
            overflowRenderer.addChildRenderer(childResult.getOverflowRenderer());
        }
        overflowRenderer.childRenderers.addAll(this.childRenderers.subList(childPos + 1, this.childRenderers.size()));
        if (layoutStatus != 3) {
            ContinuousContainer.clearPropertiesFromOverFlowRenderer(overflowRenderer);
        }
        if (childResult.getStatus() == 2) {
            overflowRenderer.deleteOwnProperty(26);
        }
        return new AbstractRenderer[]{splitRenderer, overflowRenderer};
    }

    protected void applyVerticalAlignment() {
        VerticalAlignment verticalAlignment = (VerticalAlignment)((Object)this.getProperty(75));
        if (verticalAlignment == null || verticalAlignment == VerticalAlignment.TOP || this.childRenderers.isEmpty()) {
            return;
        }
        float lowestChildBottom = Float.MAX_VALUE;
        if (FloatingHelper.isRendererFloating(this) || this instanceof CellRenderer) {
            for (IRenderer child : this.childRenderers) {
                if (child.getOccupiedArea() == null || !(child.getOccupiedArea().getBBox().getBottom() < lowestChildBottom)) continue;
                lowestChildBottom = child.getOccupiedArea().getBBox().getBottom();
            }
        } else {
            int lastChildIndex = this.childRenderers.size() - 1;
            while (lastChildIndex >= 0) {
                IRenderer child;
                if (FloatingHelper.isRendererFloating(child = (IRenderer)this.childRenderers.get(lastChildIndex--)) || child.getOccupiedArea() == null) continue;
                lowestChildBottom = child.getOccupiedArea().getBBox().getBottom();
                break;
            }
        }
        if (lowestChildBottom == Float.MAX_VALUE) {
            return;
        }
        float deltaY = lowestChildBottom - this.getInnerAreaBBox().getY();
        if (deltaY < 0.0f) {
            return;
        }
        switch (verticalAlignment) {
            case BOTTOM: {
                for (IRenderer child : this.childRenderers) {
                    child.move(0.0f, -deltaY);
                }
                break;
            }
            case MIDDLE: {
                for (IRenderer child : this.childRenderers) {
                    child.move(0.0f, -deltaY / 2.0f);
                }
                break;
            }
        }
    }

    protected void applyRotationLayout(Rectangle layoutBox) {
        float angle = this.getPropertyAsFloat(55).floatValue();
        float x = this.occupiedArea.getBBox().getX();
        float y = this.occupiedArea.getBBox().getY();
        float height = this.occupiedArea.getBBox().getHeight();
        float width = this.occupiedArea.getBBox().getWidth();
        this.setProperty(57, Float.valueOf(width));
        this.setProperty(56, Float.valueOf(height));
        AffineTransform rotationTransform = new AffineTransform();
        if (this.isPositioned()) {
            Float rotationPointX = this.getPropertyAsFloat(58);
            Float rotationPointY = this.getPropertyAsFloat(59);
            if (rotationPointX == null || rotationPointY == null) {
                rotationPointX = Float.valueOf(x);
                rotationPointY = Float.valueOf(y);
            }
            rotationTransform.translate(rotationPointX.floatValue(), rotationPointY.floatValue());
            rotationTransform.rotate(angle);
            rotationTransform.translate(-rotationPointX.floatValue(), -rotationPointY.floatValue());
            List<Point> rotatedPoints = this.transformPoints(this.rectangleToPointsList(this.occupiedArea.getBBox()), rotationTransform);
            Rectangle newBBox = this.calculateBBox(rotatedPoints);
            this.occupiedArea.getBBox().setWidth(newBBox.getWidth());
            this.occupiedArea.getBBox().setHeight(newBBox.getHeight());
            float occupiedAreaShiftX = newBBox.getX() - x;
            float occupiedAreaShiftY = newBBox.getY() - y;
            this.move(occupiedAreaShiftX, occupiedAreaShiftY);
        } else {
            rotationTransform = AffineTransform.getRotateInstance(angle);
            List<Point> rotatedPoints = this.transformPoints(this.rectangleToPointsList(this.occupiedArea.getBBox()), rotationTransform);
            float[] shift = this.calculateShiftToPositionBBoxOfPointsAt(x, y + height, rotatedPoints);
            for (Point point : rotatedPoints) {
                point.setLocation(point.getX() + (double)shift[0], point.getY() + (double)shift[1]);
            }
            Rectangle newBBox = this.calculateBBox(rotatedPoints);
            this.occupiedArea.getBBox().setWidth(newBBox.getWidth());
            this.occupiedArea.getBBox().setHeight(newBBox.getHeight());
            float heightDiff = height - newBBox.getHeight();
            this.move(0.0f, heightDiff);
        }
    }

    protected AffineTransform createRotationTransformInsideOccupiedArea() {
        Float angle = (Float)this.getProperty(55);
        AffineTransform rotationTransform = AffineTransform.getRotateInstance(angle.floatValue());
        Rectangle contentBox = this.getOccupiedAreaBBox();
        List<Point> rotatedContentBoxPoints = this.transformPoints(this.rectangleToPointsList(contentBox), rotationTransform);
        float[] shift = this.calculateShiftToPositionBBoxOfPointsAt(this.occupiedArea.getBBox().getLeft(), this.occupiedArea.getBBox().getTop(), rotatedContentBoxPoints);
        rotationTransform.preConcatenate(AffineTransform.getTranslateInstance(shift[0], shift[1]));
        return rotationTransform;
    }

    protected void beginRotationIfApplied(PdfCanvas canvas) {
        Float angle = this.getPropertyAsFloat(55);
        if (angle != null) {
            if (!this.hasOwnProperty(56)) {
                Logger logger = LoggerFactory.getLogger(BlockRenderer.class);
                logger.error(MessageFormatUtil.format("Rotation was not correctly processed for {0}", this.getClass().getSimpleName()));
            } else {
                AffineTransform transform = this.createRotationTransformInsideOccupiedArea();
                canvas.saveState().concatMatrix(transform);
            }
        }
    }

    protected void endRotationIfApplied(PdfCanvas canvas) {
        Float angle = this.getPropertyAsFloat(55);
        if (angle != null && this.hasOwnProperty(56)) {
            canvas.restoreState();
        }
    }

    protected PdfFont getResolvedFont(PdfDocument pdfDocument) {
        Object retrievedFont = this.getProperty(20);
        if (retrievedFont instanceof PdfFont) {
            return (PdfFont)retrievedFont;
        }
        if (this.getProperty(91) != null && retrievedFont != null) {
            return this.resolveFirstPdfFont();
        }
        if (pdfDocument != null) {
            return pdfDocument.getDefaultFont();
        }
        return null;
    }

    boolean stopLayoutingChildrenIfChildResultNotFull(LayoutResult returnResult) {
        return true;
    }

    LayoutResult processNotFullChildResult(LayoutContext layoutContext, Map<Integer, IRenderer> waitingFloatsSplitRenderers, List<IRenderer> waitingOverflowFloatRenderers, boolean wasHeightClipped, List<Rectangle> floatRendererAreas, boolean marginsCollapsingEnabled, float clearHeightCorrection, Border[] borders, UnitValue[] paddings, List<Rectangle> areas, int currentAreaPos, Rectangle layoutBox, Set<Rectangle> nonChildFloatingRendererAreas, IRenderer causeOfNothing, boolean anythingPlaced, int childPos, LayoutResult result) {
        if (result.getStatus() == 2) {
            if (currentAreaPos + 1 == areas.size()) {
                AbstractRenderer[] splitAndOverflowRenderers = this.createSplitAndOverflowRenderers(childPos, 2, result, waitingFloatsSplitRenderers, waitingOverflowFloatRenderers);
                AbstractRenderer splitRenderer = splitAndOverflowRenderers[0];
                AbstractRenderer overflowRenderer = splitAndOverflowRenderers[1];
                overflowRenderer.deleteOwnProperty(26);
                this.updateHeightsOnSplit(wasHeightClipped, splitRenderer, overflowRenderer);
                this.applyPaddings(this.occupiedArea.getBBox(), paddings, true);
                this.applyBorderBox(this.occupiedArea.getBBox(), borders, true);
                this.applyMargins(this.occupiedArea.getBBox(), true);
                this.correctFixedLayout(layoutBox);
                LayoutArea editedArea = FloatingHelper.adjustResultOccupiedAreaForFloatAndClear(this, layoutContext.getFloatRendererAreas(), layoutContext.getArea().getBBox(), clearHeightCorrection, marginsCollapsingEnabled);
                if (wasHeightClipped) {
                    return new LayoutResult(1, editedArea, splitRenderer, null);
                }
                return new LayoutResult(2, editedArea, splitRenderer, overflowRenderer, causeOfNothing);
            }
            this.childRenderers.set(childPos, result.getSplitRenderer());
            this.childRenderers.add(childPos + 1, result.getOverflowRenderer());
            return null;
        }
        if (result.getStatus() == 3) {
            boolean keepTogether = this.isKeepTogether(causeOfNothing);
            int layoutResult = anythingPlaced && !keepTogether ? 2 : 3;
            AbstractRenderer[] splitAndOverflowRenderers = this.createSplitAndOverflowRenderers(childPos, layoutResult, result, waitingFloatsSplitRenderers, waitingOverflowFloatRenderers);
            AbstractRenderer splitRenderer = splitAndOverflowRenderers[0];
            AbstractRenderer overflowRenderer = splitAndOverflowRenderers[1];
            if (this.isRelativePosition() && this.positionedRenderers.size() > 0) {
                overflowRenderer.positionedRenderers = new ArrayList<IRenderer>(this.positionedRenderers);
            }
            this.updateHeightsOnSplit(wasHeightClipped, splitRenderer, overflowRenderer);
            if (keepTogether) {
                splitRenderer = null;
                overflowRenderer.childRenderers.clear();
                overflowRenderer.addAllChildRenderers(this.childRenderers);
            }
            this.correctFixedLayout(layoutBox);
            this.applyPaddings(this.occupiedArea.getBBox(), paddings, true);
            this.applyBorderBox(this.occupiedArea.getBBox(), borders, true);
            this.applyMargins(this.occupiedArea.getBBox(), true);
            this.applyAbsolutePositionIfNeeded(layoutContext);
            if (Boolean.TRUE.equals(this.getPropertyAsBoolean(26)) || wasHeightClipped) {
                LayoutArea editedArea = FloatingHelper.adjustResultOccupiedAreaForFloatAndClear(this, layoutContext.getFloatRendererAreas(), layoutContext.getArea().getBBox(), clearHeightCorrection, marginsCollapsingEnabled);
                return new LayoutResult(1, editedArea, splitRenderer, null, null);
            }
            if (layoutResult != 3) {
                LayoutArea editedArea = FloatingHelper.adjustResultOccupiedAreaForFloatAndClear(this, layoutContext.getFloatRendererAreas(), layoutContext.getArea().getBBox(), clearHeightCorrection, marginsCollapsingEnabled);
                return new LayoutResult(layoutResult, editedArea, splitRenderer, overflowRenderer, null).setAreaBreak(result.getAreaBreak());
            }
            floatRendererAreas.retainAll(nonChildFloatingRendererAreas);
            return new LayoutResult(layoutResult, null, null, overflowRenderer, result.getCauseOfNothing()).setAreaBreak(result.getAreaBreak());
        }
        return null;
    }

    void decreaseLayoutBoxAfterChildPlacement(Rectangle layoutBox, LayoutResult result, IRenderer childRenderer) {
        layoutBox.setHeight(result.getOccupiedArea().getBBox().getY() - layoutBox.getY());
    }

    void correctFixedLayout(Rectangle layoutBox) {
        if (this.isFixedLayout()) {
            float y = this.getPropertyAsFloat(14).floatValue();
            this.move(0.0f, y - this.occupiedArea.getBBox().getY());
        }
    }

    void applyWidth(Rectangle parentBBox, Float blockWidth, OverflowPropertyValue overflowX) {
        Float rotation = this.getPropertyAsFloat(55);
        if (blockWidth != null && (blockWidth.floatValue() < parentBBox.getWidth() || this.isPositioned() || rotation != null || !BlockRenderer.isOverflowFit(overflowX))) {
            parentBBox.setWidth(blockWidth.floatValue());
        } else {
            Float minWidth = this.retrieveMinWidth(parentBBox.getWidth());
            if (minWidth != null && minWidth.floatValue() > parentBBox.getWidth()) {
                parentBBox.setWidth(minWidth.floatValue());
            }
        }
    }

    boolean applyMaxHeight(Rectangle parentBBox, Float blockMaxHeight, MarginsCollapseHandler marginsCollapseHandler, boolean isCellRenderer, boolean wasParentsHeightClipped, OverflowPropertyValue overflowY) {
        if (null == blockMaxHeight || blockMaxHeight.floatValue() >= parentBBox.getHeight() && BlockRenderer.isOverflowFit(overflowY)) {
            return false;
        }
        boolean wasHeightClipped = false;
        if (blockMaxHeight.floatValue() <= parentBBox.getHeight()) {
            wasHeightClipped = true;
        }
        float heightDelta = parentBBox.getHeight() - blockMaxHeight.floatValue();
        if (marginsCollapseHandler != null && !isCellRenderer) {
            marginsCollapseHandler.processFixedHeightAdjustment(heightDelta);
        }
        parentBBox.moveUp(heightDelta).setHeight(blockMaxHeight.floatValue());
        return wasHeightClipped;
    }

    AbstractRenderer applyMinHeight(OverflowPropertyValue overflowY, Rectangle layoutBox) {
        AbstractRenderer overflowRenderer = null;
        Float blockMinHeight = this.retrieveMinHeight();
        if (!Boolean.TRUE.equals(this.getPropertyAsBoolean(26)) && null != blockMinHeight && blockMinHeight.floatValue() > this.occupiedArea.getBBox().getHeight()) {
            float blockBottom = this.occupiedArea.getBBox().getBottom() - (blockMinHeight.floatValue() - this.occupiedArea.getBBox().getHeight());
            if (this.isFixedLayout()) {
                this.occupiedArea.getBBox().setY(blockBottom).setHeight(blockMinHeight.floatValue());
            } else if (BlockRenderer.isOverflowFit(overflowY) && blockBottom + 1.0E-4f < layoutBox.getBottom()) {
                float hDelta = this.occupiedArea.getBBox().getBottom() - layoutBox.getBottom();
                this.occupiedArea.getBBox().increaseHeight(hDelta).setY(layoutBox.getBottom());
                if (this.occupiedArea.getBBox().getHeight() < 0.0f) {
                    this.occupiedArea.getBBox().setHeight(0.0f);
                }
                this.isLastRendererForModelElement = false;
                overflowRenderer = this.createOverflowRenderer(2);
                overflowRenderer.updateMinHeight(UnitValue.createPointValue(blockMinHeight.floatValue() - this.occupiedArea.getBBox().getHeight()));
                if (this.hasProperty(27)) {
                    overflowRenderer.updateHeight(UnitValue.createPointValue(this.retrieveHeight().floatValue() - this.occupiedArea.getBBox().getHeight()));
                }
            } else {
                this.occupiedArea.getBBox().setY(blockBottom).setHeight(blockMinHeight.floatValue());
            }
        }
        return overflowRenderer;
    }

    void fixOccupiedAreaIfOverflowedX(OverflowPropertyValue overflowX, Rectangle layoutBox) {
        if (BlockRenderer.isOverflowFit(overflowX)) {
            return;
        }
        if (this.occupiedArea.getBBox().getWidth() > layoutBox.getWidth() || this.occupiedArea.getBBox().getLeft() < layoutBox.getLeft()) {
            this.occupiedArea.getBBox().setX(layoutBox.getX()).setWidth(layoutBox.getWidth());
        }
    }

    void fixOccupiedAreaIfOverflowedY(OverflowPropertyValue overflowY, Rectangle layoutBox) {
        if (BlockRenderer.isOverflowFit(overflowY)) {
            return;
        }
        if (this.occupiedArea.getBBox().getBottom() < layoutBox.getBottom()) {
            float difference = layoutBox.getBottom() - this.occupiedArea.getBBox().getBottom();
            this.occupiedArea.getBBox().moveUp(difference).decreaseHeight(difference);
        }
    }

    @Override
    public MinMaxWidth getMinMaxWidth() {
        MinMaxWidth minMaxWidth = new MinMaxWidth(BlockRenderer.calculateAdditionalWidth(this));
        if (!this.setMinMaxWidthBasedOnFixedWidth(minMaxWidth)) {
            Float maxWidth;
            Float minWidth = this.hasAbsoluteUnitValue(80) ? this.retrieveMinWidth(0.0f) : null;
            Float f = maxWidth = this.hasAbsoluteUnitValue(79) ? this.retrieveMaxWidth(0.0f) : null;
            if (minWidth == null || maxWidth == null) {
                MaxMaxWidthHandler handler = new MaxMaxWidthHandler(minMaxWidth);
                int epsilonNum = 0;
                int curEpsNum = 0;
                float previousFloatingChildWidth = 0.0f;
                for (IRenderer childRenderer : this.childRenderers) {
                    childRenderer.setParent(this);
                    MinMaxWidth childMinMaxWidth = childRenderer instanceof AbstractRenderer ? ((AbstractRenderer)childRenderer).getMinMaxWidth() : MinMaxWidthUtils.countDefaultMinMaxWidth(childRenderer);
                    ((AbstractWidthHandler)handler).updateMaxChildWidth(childMinMaxWidth.getMaxWidth() + (FloatingHelper.isRendererFloating(childRenderer) ? previousFloatingChildWidth : 0.0f));
                    ((AbstractWidthHandler)handler).updateMinChildWidth(childMinMaxWidth.getMinWidth());
                    float f2 = previousFloatingChildWidth = FloatingHelper.isRendererFloating(childRenderer) ? previousFloatingChildWidth + childMinMaxWidth.getMaxWidth() : 0.0f;
                    if (FloatingHelper.isRendererFloating(childRenderer)) {
                        ++curEpsNum;
                        continue;
                    }
                    epsilonNum = Math.max(epsilonNum, curEpsNum);
                    curEpsNum = 0;
                }
                epsilonNum = Math.max(epsilonNum, curEpsNum);
                handler.minMaxWidth.setChildrenMaxWidth(handler.minMaxWidth.getChildrenMaxWidth() + (float)epsilonNum * 1.0E-4f);
                handler.minMaxWidth.setChildrenMinWidth(handler.minMaxWidth.getChildrenMinWidth() + (float)epsilonNum * 1.0E-4f);
            }
            if (minWidth != null) {
                minMaxWidth.setChildrenMinWidth(minWidth.floatValue());
            }
            if (maxWidth != null) {
                minMaxWidth.setChildrenMaxWidth(maxWidth.floatValue());
            } else if (minMaxWidth.getChildrenMinWidth() > minMaxWidth.getChildrenMaxWidth()) {
                minMaxWidth.setChildrenMaxWidth(minMaxWidth.getChildrenMinWidth());
            }
        }
        if (this.getPropertyAsFloat(55) != null) {
            return RotationUtils.countRotationMinMaxWidth(minMaxWidth, this);
        }
        return minMaxWidth;
    }

    void handleForcedPlacement(boolean anythingPlaced) {
        if (anythingPlaced && this.hasOwnProperty(26)) {
            this.deleteOwnProperty(26);
        }
    }

    private boolean isAnythingOccupied() {
        return !(this.occupiedArea.getBBox().getHeight() < 1.0E-4f);
    }

    private void replaceSplitRendererKidFloats(Map<Integer, IRenderer> waitingFloatsSplitRenderers, IRenderer splitRenderer) {
        for (Map.Entry<Integer, IRenderer> waitingSplitRenderer : waitingFloatsSplitRenderers.entrySet()) {
            if (waitingSplitRenderer.getValue() != null) {
                splitRenderer.getChildRenderers().set(waitingSplitRenderer.getKey(), waitingSplitRenderer.getValue());
                continue;
            }
            splitRenderer.getChildRenderers().set(waitingSplitRenderer.getKey(), null);
        }
        for (int i = splitRenderer.getChildRenderers().size() - 1; i >= 0; --i) {
            if (splitRenderer.getChildRenderers().get(i) != null) continue;
            splitRenderer.getChildRenderers().remove(i);
        }
    }

    private void addMarkedContent(DrawContext drawContext, boolean isBegin) {
        if (Boolean.TRUE.equals(this.getProperty(137))) {
            PdfCanvas canvas = drawContext.getCanvas();
            if (isBegin) {
                canvas.beginVariableText().saveState().endPath();
            } else {
                canvas.restoreState().endVariableText();
            }
        }
    }

    private List<Point> clipPolygon(List<Point> points, Point clipLineBeg, Point clipLineEnd) {
        ArrayList<Point> filteredPoints = new ArrayList<Point>();
        boolean prevOnRightSide = false;
        Point filteringPoint = points.get(0);
        if (this.checkPointSide(filteringPoint, clipLineBeg, clipLineEnd) >= 0) {
            filteredPoints.add(filteringPoint);
            prevOnRightSide = true;
        }
        Point prevPoint = filteringPoint;
        for (int i = 1; i < points.size() + 1; ++i) {
            filteringPoint = points.get(i % points.size());
            if (this.checkPointSide(filteringPoint, clipLineBeg, clipLineEnd) >= 0) {
                if (!prevOnRightSide) {
                    filteredPoints.add(this.getIntersectionPoint(prevPoint, filteringPoint, clipLineBeg, clipLineEnd));
                }
                filteredPoints.add(filteringPoint);
                prevOnRightSide = true;
            } else if (prevOnRightSide) {
                filteredPoints.add(this.getIntersectionPoint(prevPoint, filteringPoint, clipLineBeg, clipLineEnd));
            }
            prevPoint = filteringPoint;
        }
        return filteredPoints;
    }

    private int checkPointSide(Point filteredPoint, Point clipLineBeg, Point clipLineEnd) {
        double y1;
        double x2;
        double y2;
        double x1 = filteredPoint.getX() - clipLineBeg.getX();
        double sgn = x1 * (y2 = clipLineEnd.getY() - clipLineBeg.getY()) - (x2 = clipLineEnd.getX() - clipLineBeg.getX()) * (y1 = filteredPoint.getY() - clipLineBeg.getY());
        if (Math.abs(sgn) < 0.001) {
            return 0;
        }
        if (sgn > 0.0) {
            return 1;
        }
        if (sgn < 0.0) {
            return -1;
        }
        return 0;
    }

    private Point getIntersectionPoint(Point lineBeg, Point lineEnd, Point clipLineBeg, Point clipLineEnd) {
        double A1 = lineBeg.getY() - lineEnd.getY();
        double A2 = clipLineBeg.getY() - clipLineEnd.getY();
        double B1 = lineEnd.getX() - lineBeg.getX();
        double B2 = clipLineEnd.getX() - clipLineBeg.getX();
        double C1 = lineBeg.getX() * lineEnd.getY() - lineBeg.getY() * lineEnd.getX();
        double C2 = clipLineBeg.getX() * clipLineEnd.getY() - clipLineBeg.getY() * clipLineEnd.getX();
        double M = B1 * A2 - B2 * A1;
        return new Point((B2 * C1 - B1 * C2) / M, (C2 * A1 - C1 * A2) / M);
    }
}

