/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import com.itextpdf.commons.datastructures.ISimpleList;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.di.pagetree.IPageTreeListFactory;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfCatalog;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfIndirectReference;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfPages;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PdfPagesTree {
    static final int DEFAULT_LEAF_SIZE = 10;
    private final int leafSize = 10;
    private ISimpleList<PdfIndirectReference> pageRefs;
    private List<PdfPages> parents;
    private ISimpleList<PdfPage> pages;
    private final PdfDocument document;
    private boolean generated = false;
    private PdfPages root;
    private static final Logger LOGGER = LoggerFactory.getLogger(PdfPagesTree.class);

    public PdfPagesTree(PdfCatalog pdfCatalog) {
        this.document = pdfCatalog.getDocument();
        this.parents = new ArrayList<PdfPages>();
        IPageTreeListFactory pageTreeFactory = this.document.getDiContainer().getInstance(IPageTreeListFactory.class);
        if (((PdfDictionary)pdfCatalog.getPdfObject()).containsKey(PdfName.Pages)) {
            PdfDictionary pages = ((PdfDictionary)pdfCatalog.getPdfObject()).getAsDictionary(PdfName.Pages);
            if (pages == null) {
                throw new PdfException("Invalid page structure. /Pages must be PdfDictionary.");
            }
            this.pages = pageTreeFactory.createList(pages);
            this.pageRefs = pageTreeFactory.createList(pages);
            this.root = new PdfPages(0, Integer.MAX_VALUE, pages, null);
            this.parents.add(this.root);
            for (int i = 0; i < this.root.getCount(); ++i) {
                this.pageRefs.add(null);
                this.pages.add(null);
            }
        } else {
            this.root = null;
            this.parents.add(new PdfPages(0, this.document));
            this.pages = pageTreeFactory.createList(null);
            this.pageRefs = pageTreeFactory.createList(null);
        }
    }

    public PdfPage getPage(int pageNum) {
        PdfPage pdfPage;
        if (pageNum < 1 || pageNum > this.getNumberOfPages()) {
            throw new IndexOutOfBoundsException(MessageFormatUtil.format("Requested page number {0} is out of bounds.", pageNum));
        }
        if ((pdfPage = this.pages.get(--pageNum)) == null) {
            this.loadPage(pageNum);
            if (this.pageRefs.get(pageNum) != null) {
                int parentIndex = this.findPageParent(pageNum);
                PdfObject pageObject = this.pageRefs.get(pageNum).getRefersTo();
                if (pageObject instanceof PdfDictionary) {
                    pdfPage = this.document.getPageFactory().createPdfPage((PdfDictionary)pageObject);
                    pdfPage.parentPages = this.parents.get(parentIndex);
                } else {
                    LOGGER.error(MessageFormatUtil.format("Page tree is broken. Failed to retrieve page number {0}. Null will be returned.", pageNum + 1));
                }
            } else {
                LOGGER.error(MessageFormatUtil.format("Page tree is broken. Failed to retrieve page number {0}. Null will be returned.", pageNum + 1));
            }
            this.pages.set(pageNum, pdfPage);
        }
        if (pdfPage == null) {
            throw new PdfException(MessageFormatUtil.format("Page tree is broken. Failed to retrieve page number {0}. Null will be returned.", pageNum + 1));
        }
        return pdfPage;
    }

    public PdfPage getPage(PdfDictionary pageDictionary) {
        int pageNum = this.getPageNumber(pageDictionary);
        if (pageNum > 0) {
            return this.getPage(pageNum);
        }
        return null;
    }

    public int getNumberOfPages() {
        return this.pageRefs.size();
    }

    public int getPageNumber(PdfPage page) {
        return this.pages.indexOf(page) + 1;
    }

    public int getPageNumber(PdfDictionary pageDictionary) {
        int pageNum = this.pageRefs.indexOf(pageDictionary.getIndirectReference());
        if (pageNum >= 0) {
            return pageNum + 1;
        }
        for (int i = 0; i < this.pageRefs.size(); ++i) {
            if (this.pageRefs.get(i) == null) {
                this.loadPage(i);
            }
            if (!this.pageRefs.get(i).equals(pageDictionary.getIndirectReference())) continue;
            return i + 1;
        }
        return 0;
    }

    public void addPage(PdfPage pdfPage) {
        PdfPages pdfPages;
        if (this.root != null) {
            if (this.pageRefs.size() == 0) {
                pdfPages = this.root;
            } else {
                this.loadPage(this.pageRefs.size() - 1);
                pdfPages = this.parents.get(this.parents.size() - 1);
            }
        } else {
            pdfPages = this.parents.get(this.parents.size() - 1);
            if (pdfPages.getCount() % 10 == 0 && this.pageRefs.size() > 0) {
                pdfPages = new PdfPages(pdfPages.getFrom() + pdfPages.getCount(), this.document);
                this.parents.add(pdfPages);
            }
        }
        pdfPage.makeIndirect(this.document);
        pdfPages.addPage((PdfDictionary)pdfPage.getPdfObject());
        pdfPage.parentPages = pdfPages;
        this.pageRefs.add(((PdfDictionary)pdfPage.getPdfObject()).getIndirectReference());
        this.pages.add(pdfPage);
    }

    public void addPage(int index, PdfPage pdfPage) {
        if (--index > this.pageRefs.size()) {
            throw new IndexOutOfBoundsException("index");
        }
        if (index == this.pageRefs.size()) {
            this.addPage(pdfPage);
            return;
        }
        this.loadPage(index);
        pdfPage.makeIndirect(this.document);
        int parentIndex = this.findPageParent(index);
        PdfPages parentPages = this.parents.get(parentIndex);
        parentPages.addPage(index, pdfPage);
        pdfPage.parentPages = parentPages;
        this.correctPdfPagesFromProperty(parentIndex + 1, 1);
        this.pageRefs.add(index, ((PdfDictionary)pdfPage.getPdfObject()).getIndirectReference());
        this.pages.add(index, pdfPage);
    }

    public PdfPage removePage(int pageNum) {
        PdfPage pdfPage = this.getPage(pageNum);
        if (pdfPage.isFlushed()) {
            LOGGER.warn("The page requested to be removed has already been flushed.");
        }
        if (this.internalRemovePage(--pageNum)) {
            return pdfPage;
        }
        return null;
    }

    void releasePage(int pageNumber) {
        if (!(this.pageRefs.get(--pageNumber) == null || this.pageRefs.get(pageNumber).checkState((short)1) || this.pageRefs.get(pageNumber).checkState((short)8) || this.pageRefs.get(pageNumber).getOffset() <= 0L && this.pageRefs.get(pageNumber).getIndex() < 0)) {
            this.pages.set(pageNumber, null);
        }
    }

    protected PdfObject generateTree() {
        if (this.pageRefs.size() == 0) {
            LOGGER.info("Attempt to generate PDF pages tree without any pages, so a new page will be added.");
            this.document.addNewPage();
        }
        if (this.generated) {
            throw new PdfException("PdfPages tree could be generated only once.");
        }
        if (this.root == null) {
            while (this.parents.size() != 1) {
                ArrayList<PdfPages> nextParents = new ArrayList<PdfPages>();
                int dynamicLeafSize = 10;
                PdfPages current = null;
                for (int i = 0; i < this.parents.size(); ++i) {
                    PdfPages pages = this.parents.get(i);
                    int pageCount = pages.getCount();
                    if (i % dynamicLeafSize == 0) {
                        if (pageCount <= 1) {
                            ++dynamicLeafSize;
                        } else {
                            current = new PdfPages(-1, this.document);
                            nextParents.add(current);
                            dynamicLeafSize = 10;
                        }
                    }
                    current.addPages(pages);
                }
                this.parents = nextParents;
            }
            this.root = this.parents.get(0);
        }
        this.generated = true;
        return this.root.getPdfObject();
    }

    protected void clearPageRefs() {
        this.pageRefs = null;
        this.pages = null;
    }

    protected List<PdfPages> getParents() {
        return this.parents;
    }

    protected PdfPages getRoot() {
        return this.root;
    }

    protected PdfPages findPageParent(PdfPage pdfPage) {
        int pageNum = this.getPageNumber(pdfPage) - 1;
        int parentIndex = this.findPageParent(pageNum);
        return this.parents.get(parentIndex);
    }

    private void loadPage(int pageNum) {
        this.loadPage(pageNum, new HashSet<PdfIndirectReference>());
    }

    private void loadPage(int pageNum, Set<PdfIndirectReference> processedParents) {
        PdfArray kids;
        PdfIndirectReference targetPage = this.pageRefs.get(pageNum);
        if (targetPage != null) {
            return;
        }
        int parentIndex = this.findPageParent(pageNum);
        PdfPages parent = this.parents.get(parentIndex);
        PdfIndirectReference parentIndirectReference = ((PdfDictionary)parent.getPdfObject()).getIndirectReference();
        if (parentIndirectReference != null) {
            if (processedParents.contains(parentIndirectReference)) {
                throw new PdfException("Invalid page structure {0}.").setMessageParams(pageNum + 1);
            }
            processedParents.add(parentIndirectReference);
        }
        if ((kids = parent.getKids()) == null) {
            throw new PdfException("Invalid page structure {0}.").setMessageParams(pageNum + 1);
        }
        int kidsCount = parent.getCount();
        boolean findPdfPages = false;
        for (int i = 0; i < kids.size(); ++i) {
            PdfDictionary page = kids.getAsDictionary(i);
            if (page == null) {
                throw new PdfException("Invalid page structure {0}.").setMessageParams(pageNum + 1);
            }
            PdfObject pageKids = page.get(PdfName.Kids);
            if (pageKids != null) {
                if (pageKids.isArray()) {
                    findPdfPages = true;
                } else {
                    throw new PdfException("Invalid page structure {0}.").setMessageParams(pageNum + 1);
                }
            }
            if (!this.document.getReader().isMemorySavingMode() || findPdfPages || parent.getFrom() + i == pageNum) continue;
            page.release();
        }
        if (findPdfPages) {
            int i;
            ArrayList<PdfPages> newParents = new ArrayList<PdfPages>(kids.size());
            PdfPages lastPdfPages = null;
            for (i = 0; i < kids.size() && kidsCount > 0; ++i) {
                PdfDictionary pdfPagesObject = kids.getAsDictionary(i);
                if (pdfPagesObject.getAsArray(PdfName.Kids) == null) {
                    if (lastPdfPages == null) {
                        lastPdfPages = new PdfPages(parent.getFrom(), this.document, parent);
                        kids.set(i, (PdfObject)lastPdfPages.getPdfObject());
                        newParents.add(lastPdfPages);
                    } else {
                        kids.remove(i);
                        --i;
                    }
                    parent.decrementCount();
                    lastPdfPages.addPage(pdfPagesObject);
                    --kidsCount;
                    continue;
                }
                int from = lastPdfPages == null ? parent.getFrom() : lastPdfPages.getFrom() + lastPdfPages.getCount();
                lastPdfPages = new PdfPages(from, kidsCount, pdfPagesObject, parent);
                newParents.add(lastPdfPages);
                kidsCount -= lastPdfPages.getCount();
            }
            this.parents.remove(parentIndex);
            for (i = newParents.size() - 1; i >= 0; --i) {
                this.parents.add(parentIndex, (PdfPages)newParents.get(i));
            }
            this.loadPage(pageNum, processedParents);
        } else {
            int from = parent.getFrom();
            int pageCount = Math.min(parent.getCount(), kids.size());
            for (int i = 0; i < pageCount; ++i) {
                PdfObject kid = kids.get(i, false);
                if (kid instanceof PdfIndirectReference) {
                    this.pageRefs.set(from + i, (PdfIndirectReference)kid);
                    continue;
                }
                this.pageRefs.set(from + i, kid.getIndirectReference());
            }
        }
    }

    private boolean internalRemovePage(int pageNum) {
        int parentIndex = this.findPageParent(pageNum);
        PdfPages pdfPages = this.parents.get(parentIndex);
        if (pdfPages.removePage(pageNum)) {
            if (pdfPages.getCount() == 0) {
                this.parents.remove(parentIndex);
                pdfPages.removeFromParent();
                --parentIndex;
            }
            if (this.parents.size() == 0) {
                this.root = null;
                this.parents.add(new PdfPages(0, this.document));
            } else {
                this.correctPdfPagesFromProperty(parentIndex + 1, -1);
            }
            this.pageRefs.remove(pageNum);
            this.pages.remove(pageNum);
            return true;
        }
        return false;
    }

    private int findPageParent(int pageNum) {
        int low = 0;
        int high = this.parents.size() - 1;
        while (low != high) {
            int middle = (low + high + 1) / 2;
            if (this.parents.get(middle).compareTo(pageNum) > 0) {
                high = middle - 1;
                continue;
            }
            low = middle;
        }
        return low;
    }

    private void correctPdfPagesFromProperty(int index, int correction) {
        for (int i = index; i < this.parents.size(); ++i) {
            if (this.parents.get(i) == null) continue;
            this.parents.get(i).correctFrom(correction);
        }
    }
}

