/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.pdf.IPdfNameTreeAccess;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfIndirectReference;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.PdfStringComparator;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericNameTree
implements IPdfNameTreeAccess {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericNameTree.class);
    private static final int NODE_SIZE = 40;
    private LinkedHashMap<PdfString, PdfObject> items = new LinkedHashMap();
    private final PdfDocument pdfDoc;
    private boolean modified;

    protected GenericNameTree(PdfDocument pdfDoc) {
        this.pdfDoc = pdfDoc;
    }

    public void addEntry(PdfString key, PdfObject value) {
        this.addEntry(key, value, null);
    }

    public void addEntry(String key, PdfObject value) {
        this.addEntry(new PdfString(key, null), value);
    }

    public void removeEntry(PdfString key) {
        PdfObject existingVal = (PdfObject)this.items.remove(key);
        if (existingVal != null) {
            this.modified = true;
        }
    }

    @Override
    public PdfObject getEntry(PdfString key) {
        return this.items.get(key);
    }

    @Override
    public PdfObject getEntry(String key) {
        return this.getEntry(new PdfString(key));
    }

    @Override
    public Set<PdfString> getKeys() {
        return new LinkedHashSet<PdfString>(this.items.keySet());
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified() {
        this.modified = true;
    }

    public PdfDictionary buildTree() {
        PdfString[] names = this.items.keySet().toArray(new PdfString[0]);
        Arrays.sort(names, new PdfStringComparator());
        if (names.length <= 40) {
            PdfDictionary dic = new PdfDictionary();
            PdfArray ar = new PdfArray();
            for (PdfString name : names) {
                ar.add(name);
                ar.add(this.items.get(name));
            }
            dic.put(PdfName.Names, ar);
            return dic;
        }
        PdfDictionary[] leaves = this.constructLeafArr(names);
        return this.reduceTree(names, leaves, leaves.length, 1600);
    }

    protected void addEntry(PdfString key, PdfObject value, Consumer<PdfDocument> onErrorAction) {
        PdfObject existingVal = this.items.get(key);
        if (existingVal != null) {
            PdfIndirectReference valueRef = value.getIndirectReference();
            if (valueRef != null && valueRef.equals(existingVal.getIndirectReference())) {
                return;
            }
            LOGGER.warn(MessageFormatUtil.format("Name \"{0}\" already exists in the name tree; old value will be replaced by the new one.", key));
            if (onErrorAction != null) {
                onErrorAction.accept(this.pdfDoc);
            }
        }
        this.modified = true;
        this.items.put(key, value);
    }

    protected final void setItems(LinkedHashMap<PdfString, PdfObject> items) {
        this.items = items;
    }

    protected final LinkedHashMap<PdfString, PdfObject> getItems() {
        return this.items;
    }

    protected static LinkedHashMap<PdfString, PdfObject> readTree(PdfDictionary dictionary) {
        LinkedHashMap<PdfString, PdfObject> items = new LinkedHashMap<PdfString, PdfObject>();
        if (dictionary != null) {
            GenericNameTree.iterateItems(dictionary, items, null);
        }
        return items;
    }

    private PdfDictionary formatNodeWithLimits(PdfString[] names, int lower, int upper) {
        PdfDictionary dic = new PdfDictionary();
        dic.makeIndirect(this.pdfDoc);
        PdfArray limitsArr = new PdfArray();
        limitsArr.add(names[lower]);
        limitsArr.add(names[upper]);
        dic.put(PdfName.Limits, limitsArr);
        return dic;
    }

    private PdfDictionary reduceTree(PdfString[] names, PdfDictionary[] topLayer, int topLayerLen, int curNodeSpan) {
        if (topLayerLen <= 40) {
            PdfArray kidsArr = new PdfArray();
            for (int i = 0; i < topLayerLen; ++i) {
                kidsArr.add(topLayer[i]);
            }
            PdfDictionary root = new PdfDictionary();
            root.put(PdfName.Kids, kidsArr);
            return root;
        }
        int nextLayerLen = (names.length + curNodeSpan - 1) / curNodeSpan;
        for (int i = 0; i < nextLayerLen; ++i) {
            int offset;
            int lowerLimit = i * curNodeSpan;
            int upperLimit = Math.min((i + 1) * curNodeSpan, names.length) - 1;
            PdfDictionary dic = this.formatNodeWithLimits(names, lowerLimit, upperLimit);
            PdfArray kidsArr = new PdfArray();
            int end = Math.min(offset + 40, topLayerLen);
            for (offset = i * 40; offset < end; ++offset) {
                kidsArr.add(topLayer[offset]);
            }
            dic.put(PdfName.Kids, kidsArr);
            topLayer[i] = dic;
        }
        return this.reduceTree(names, topLayer, nextLayerLen, curNodeSpan * 40);
    }

    private PdfDictionary[] constructLeafArr(PdfString[] names) {
        PdfDictionary[] leaves = new PdfDictionary[(names.length + 40 - 1) / 40];
        for (int k = 0; k < leaves.length; ++k) {
            int offset;
            int end = Math.min(offset + 40, names.length);
            PdfDictionary dic = this.formatNodeWithLimits(names, offset, end - 1);
            PdfArray namesArr = new PdfArray();
            for (offset = k * 40; offset < end; ++offset) {
                namesArr.add(names[offset]);
                namesArr.add(this.items.get(names[offset]));
            }
            dic.put(PdfName.Names, namesArr);
            dic.makeIndirect(this.pdfDoc);
            leaves[k] = dic;
        }
        return leaves;
    }

    private static PdfString iterateItems(PdfDictionary dictionary, Map<PdfString, PdfObject> items, PdfString leftOver) {
        boolean isIntermNode;
        PdfArray names = dictionary.getAsArray(PdfName.Names);
        PdfArray kids = dictionary.getAsArray(PdfName.Kids);
        boolean isLeafNode = names != null && names.size() > 0;
        boolean bl = isIntermNode = kids != null && kids.size() > 0;
        if (isLeafNode) {
            return GenericNameTree.iterateLeafNode(names, items, leftOver);
        }
        if (isIntermNode) {
            PdfString curLeftOver = leftOver;
            for (int k = 0; k < kids.size(); ++k) {
                PdfDictionary kid = kids.getAsDictionary(k);
                curLeftOver = GenericNameTree.iterateItems(kid, items, curLeftOver);
            }
            return curLeftOver;
        }
        return leftOver;
    }

    private static PdfString iterateLeafNode(PdfArray names, Map<PdfString, PdfObject> items, PdfString leftOver) {
        int k = 0;
        if (leftOver != null) {
            items.put(leftOver, names.get(0));
            ++k;
        }
        while (k < names.size()) {
            PdfString name = names.getAsString(k);
            if (++k == names.size()) {
                return name;
            }
            if (name != null) {
                items.put(name, names.get(k));
            }
            ++k;
        }
        return null;
    }
}

