/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.actions.events;

import com.itextpdf.commons.actions.AbstractITextConfigurationEvent;
import com.itextpdf.commons.actions.data.ProductData;
import com.itextpdf.commons.actions.processors.ITextProductEventProcessor;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.actions.data.ITextCoreProductData;
import com.itextpdf.kernel.pdf.FingerPrint;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfWriter;
import java.lang.ref.WeakReference;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AddFingerPrintEvent
extends AbstractITextConfigurationEvent {
    private final WeakReference<PdfDocument> document;
    private static final Logger LOGGER = LoggerFactory.getLogger(AddFingerPrintEvent.class);
    private static final String AGPL_MODE = "AGPL";

    public AddFingerPrintEvent(PdfDocument document) {
        this.document = new WeakReference<PdfDocument>(document);
    }

    @Override
    public void doAction() {
        PdfDocument pdfDocument = (PdfDocument)this.document.get();
        if (pdfDocument == null) {
            return;
        }
        FingerPrint fingerPrint = pdfDocument.getFingerPrint();
        Collection<ProductData> products = fingerPrint.getProducts();
        if (!fingerPrint.isFingerPrintEnabled()) {
            boolean nonAGPLMode = true;
            for (ProductData productData : products) {
                ITextProductEventProcessor processor = this.getActiveProcessor(productData.getProductName());
                if (processor == null || !AGPL_MODE.equals(processor.getUsageType())) continue;
                nonAGPLMode = false;
                break;
            }
            if (nonAGPLMode) {
                return;
            }
            LOGGER.warn("Fingerprint disabling is only available in non AGPL mode. Fingerprint will be added at the end of the document.");
        }
        PdfWriter writer = pdfDocument.getWriter();
        if (products.isEmpty()) {
            writer.writeString(MessageFormatUtil.format("%iText-{0}-no-registered-products\n", ITextCoreProductData.getInstance().getVersion()));
            return;
        }
        for (ProductData productData : products) {
            writer.writeString(MessageFormatUtil.format("%iText-{0}-{1}\n", productData.getPublicProductName(), productData.getVersion()));
        }
    }
}

