/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font.woff2;

import com.itextpdf.io.exceptions.FontCompressionException;
import com.itextpdf.io.font.woff2.Woff2Out;

class Woff2MemoryOut
implements Woff2Out {
    private byte[] buf_;
    private int buf_size_;
    private int offset_;

    public Woff2MemoryOut(byte[] buf_, int buf_size_) {
        this.buf_ = buf_;
        this.buf_size_ = buf_size_;
        this.offset_ = 0;
    }

    @Override
    public void write(byte[] buf, int buff_offset, int n) {
        this.write(buf, buff_offset, this.offset_, n);
    }

    @Override
    public void write(byte[] buf, int buff_offset, int offset, int n) {
        if (offset > this.buf_size_ || n > this.buf_size_ - offset) {
            throw new FontCompressionException("Writing woff2 exception");
        }
        System.arraycopy(buf, buff_offset, this.buf_, offset, n);
        this.offset_ = Math.max(this.offset_, offset + n);
    }

    @Override
    public int size() {
        return this.offset_;
    }
}

